/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security.handler;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.NamespacePermission;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.commons.codec.digest.Crypt;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ZKSecurityTool {
    private static final Logger log = LoggerFactory.getLogger(ZKSecurityTool.class);
    private static final Cache<Text, String> CRYPT_PASSWORD_CACHE = Caffeine.newBuilder().scheduler(Scheduler.systemScheduler()).expireAfterAccess(Duration.ofMinutes(1L)).initialCapacity(4).maximumSize(64L).build();

    ZKSecurityTool() {
    }

    public static byte[] createPass(byte[] password) throws AccumuloException {
        String cryptHash = Crypt.crypt((byte[])password);
        return cryptHash.getBytes(StandardCharsets.UTF_8);
    }

    public static boolean checkCryptPass(byte[] password, byte[] cryptHashInZkToTest) {
        String cryptHashToCache;
        Text key = new Text(password);
        key.append(cryptHashInZkToTest, 0, cryptHashInZkToTest.length);
        String cachedCryptHash = (String)CRYPT_PASSWORD_CACHE.getIfPresent((Object)key);
        if (cachedCryptHash != null) {
            if (MessageDigest.isEqual(cryptHashInZkToTest, cachedCryptHash.getBytes(StandardCharsets.UTF_8))) {
                return true;
            }
            CRYPT_PASSWORD_CACHE.invalidate((Object)key);
        }
        try {
            cryptHashToCache = Crypt.crypt((byte[])password, (String)new String(cryptHashInZkToTest, StandardCharsets.UTF_8));
        }
        catch (IllegalArgumentException e) {
            log.error("Unrecognized hash format", (Throwable)e);
            return false;
        }
        boolean matches = MessageDigest.isEqual(cryptHashInZkToTest, cryptHashToCache.getBytes(StandardCharsets.UTF_8));
        if (matches) {
            CRYPT_PASSWORD_CACHE.put((Object)key, (Object)cryptHashToCache);
        }
        return matches;
    }

    @VisibleForTesting
    static long getCryptPasswordCacheSize() {
        CRYPT_PASSWORD_CACHE.cleanUp();
        return CRYPT_PASSWORD_CACHE.estimatedSize();
    }

    @VisibleForTesting
    static void clearCryptPasswordCache() {
        CRYPT_PASSWORD_CACHE.invalidateAll();
    }

    public static Authorizations convertAuthorizations(byte[] authorizations) {
        return new Authorizations(authorizations);
    }

    public static byte[] convertAuthorizations(Authorizations authorizations) {
        return authorizations.getAuthorizationsArray();
    }

    public static byte[] convertSystemPermissions(Set<SystemPermission> systempermissions) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(systempermissions.size());
        DataOutputStream out = new DataOutputStream(bytes);
        try {
            for (SystemPermission sp : systempermissions) {
                out.writeByte(sp.getId());
            }
        }
        catch (IOException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new UncheckedIOException(e);
        }
        return bytes.toByteArray();
    }

    public static Set<SystemPermission> convertSystemPermissions(byte[] systempermissions) {
        ByteArrayInputStream bytes = new ByteArrayInputStream(systempermissions);
        DataInputStream in = new DataInputStream(bytes);
        HashSet<SystemPermission> toReturn = new HashSet<SystemPermission>();
        try {
            while (in.available() > 0) {
                toReturn.add(SystemPermission.getPermissionById((byte)in.readByte()));
            }
        }
        catch (IOException e) {
            log.error("User database is corrupt; error converting system permissions", (Throwable)e);
            toReturn.clear();
        }
        return toReturn;
    }

    public static byte[] convertTablePermissions(Set<TablePermission> tablepermissions) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(tablepermissions.size());
        DataOutputStream out = new DataOutputStream(bytes);
        try {
            for (TablePermission tp : tablepermissions) {
                out.writeByte(tp.getId());
            }
        }
        catch (IOException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new UncheckedIOException(e);
        }
        return bytes.toByteArray();
    }

    public static Set<TablePermission> convertTablePermissions(byte[] tablepermissions) {
        HashSet<TablePermission> toReturn = new HashSet<TablePermission>();
        for (byte b : tablepermissions) {
            toReturn.add(TablePermission.getPermissionById((byte)b));
        }
        return toReturn;
    }

    public static byte[] convertNamespacePermissions(Set<NamespacePermission> namespacepermissions) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(namespacepermissions.size());
        DataOutputStream out = new DataOutputStream(bytes);
        try {
            for (NamespacePermission tnp : namespacepermissions) {
                out.writeByte(tnp.getId());
            }
        }
        catch (IOException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new UncheckedIOException(e);
        }
        return bytes.toByteArray();
    }

    public static Set<NamespacePermission> convertNamespacePermissions(byte[] namespacepermissions) {
        HashSet<NamespacePermission> toReturn = new HashSet<NamespacePermission>();
        for (byte b : namespacepermissions) {
            toReturn.add(NamespacePermission.getPermissionById((byte)b));
        }
        return toReturn;
    }

    public static String getInstancePath(InstanceId instanceId) {
        return "/accumulo/" + instanceId;
    }
}

