/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.clientImpl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.util.tables.TableNameUtil;

public class TableNotFoundException
extends Exception {
    private static final long serialVersionUID = 1L;
    private String tableName;

    public TableNotFoundException(String tableId, String tableName, String description) {
        super("Table" + (String)(tableName != null && !tableName.isEmpty() ? " " + tableName : "") + (String)(tableId != null && !tableId.isEmpty() ? " (Id=" + tableId + ")" : "") + " does not exist" + (String)(description != null && !description.isEmpty() ? " (" + description + ")" : ""));
        this.tableName = tableName;
    }

    public TableNotFoundException(String tableId, String tableName, String description, Throwable cause) {
        this(tableId, tableName, description);
        super.initCause(cause);
    }

    public TableNotFoundException(ThriftTableOperationException e) {
        this(e.getTableId(), e.getTableName(), e.getDescription(), (Throwable)((Object)e));
    }

    public TableNotFoundException(String tableName, NamespaceNotFoundException e) {
        this(null, tableName, "Namespace " + TableNameUtil.qualify(tableName).getFirst() + " does not exist.", e);
    }

    public String getTableName() {
        return this.tableName;
    }
}

