/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.lexicoder.AbstractLexicoder;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.TypedValueCombiner;
import org.apache.accumulo.core.iterators.ValueFormatException;

public abstract class BigDecimalCombiner
extends TypedValueCombiner<BigDecimal> {
    private static final BigDecimalEncoder BDE = new BigDecimalEncoder();

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.setEncoder(BDE);
    }

    @Override
    public OptionDescriber.IteratorOptions describeOptions() {
        OptionDescriber.IteratorOptions io = super.describeOptions();
        io.setName("bigdecimalcombiner");
        io.setDescription("bigdecimalcombiner interprets Values as BigDecimals before combining");
        return io;
    }

    @Override
    public boolean validateOptions(Map<String, String> options) {
        return super.validateOptions(options);
    }

    public static class BigDecimalEncoder
    extends AbstractLexicoder<BigDecimal> {
        @Override
        public byte[] encode(BigDecimal v) {
            return v.toString().getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public BigDecimal decode(byte[] b) {
            return (BigDecimal)super.decode(b);
        }

        @Override
        protected BigDecimal decodeUnchecked(byte[] b, int offset, int len) throws ValueFormatException {
            try {
                return new BigDecimal(new String(b, offset, len, StandardCharsets.UTF_8));
            }
            catch (NumberFormatException nfe) {
                throw new ValueFormatException(nfe);
            }
        }
    }

    public static class BigDecimalMinCombiner
    extends BigDecimalCombiner {
        @Override
        public BigDecimal typedReduce(Key key, Iterator<BigDecimal> iter) {
            if (!iter.hasNext()) {
                return null;
            }
            BigDecimal min = iter.next();
            while (iter.hasNext()) {
                min = min.min(iter.next());
            }
            return min;
        }
    }

    public static class BigDecimalMaxCombiner
    extends BigDecimalCombiner {
        @Override
        public BigDecimal typedReduce(Key key, Iterator<BigDecimal> iter) {
            if (!iter.hasNext()) {
                return null;
            }
            BigDecimal max = iter.next();
            while (iter.hasNext()) {
                max = max.max(iter.next());
            }
            return max;
        }
    }

    public static class BigDecimalSummingCombiner
    extends BigDecimalCombiner {
        @Override
        public BigDecimal typedReduce(Key key, Iterator<BigDecimal> iter) {
            if (!iter.hasNext()) {
                return null;
            }
            BigDecimal sum = iter.next();
            while (iter.hasNext()) {
                sum = sum.add(iter.next());
            }
            return sum;
        }
    }
}

