/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import java.util.LinkedList;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.activemq.ActiveMQSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionPool {
    private static final Logger LOG = LoggerFactory.getLogger(SessionPool.class);
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private final LinkedList<Session> sessions = new LinkedList();

    public Connection getConnection() throws JMSException {
        if (this.checkConnection()) {
            return this.connection;
        }
        SessionPool sessionPool = this;
        synchronized (sessionPool) {
            try {
                this.connection = this.getConnectionFactory().createConnection();
                this.connection.start();
                return this.connection;
            }
            catch (JMSException jmsEx) {
                LOG.debug("Caught exception while attempting to get a new Connection.", (Throwable)jmsEx);
                this.connection.close();
                this.connection = null;
                throw jmsEx;
            }
        }
    }

    private boolean checkConnection() {
        if (this.connection == null) {
            return false;
        }
        try {
            this.connection.getMetaData();
            return true;
        }
        catch (JMSException e) {
            return false;
        }
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            throw new IllegalStateException("No ConnectionFactory has been set for the session pool");
        }
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session borrowSession() throws JMSException {
        Session answer = null;
        LinkedList<Session> linkedList = this.sessions;
        synchronized (linkedList) {
            if (this.sessions.isEmpty()) {
                LOG.trace("Creating a new session.");
                answer = this.createSession();
            } else {
                LOG.trace("Serving session from the pool.");
                answer = this.sessions.removeLast();
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnSession(Session session) {
        if (session != null && !((ActiveMQSession)session).isClosed()) {
            LinkedList<Session> linkedList = this.sessions;
            synchronized (linkedList) {
                LOG.trace("Returning session to the pool.");
                this.sessions.add(session);
            }
        } else {
            LOG.debug("Session closed or null, not returning to the pool.");
        }
    }

    protected Session createSession() throws JMSException {
        return this.getConnection().createSession(false, 1);
    }
}

