/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command.store;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.activemq.console.command.store.proto.MapEntryPB;
import org.apache.activemq.console.command.store.proto.MessagePB;
import org.apache.activemq.console.command.store.proto.QueueEntryPB;
import org.apache.activemq.console.command.store.proto.QueuePB;
import org.apache.activemq.console.command.store.tar.TarEntry;
import org.apache.activemq.console.command.store.tar.TarOutputStream;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.proto.MessageBuffer;

public class ExportStreamManager {
    private final OutputStream target;
    private final int version;
    TarOutputStream stream;
    long seq = 0L;

    ExportStreamManager(OutputStream target, int version) throws IOException {
        this.target = target;
        this.version = version;
        this.stream = new TarOutputStream(new GZIPOutputStream(target));
        this.store("ver", (Buffer)new AsciiBuffer("" + version));
    }

    public void finish() throws IOException {
        this.stream.close();
    }

    private void store(String ext, Buffer value) throws IOException {
        TarEntry entry = new TarEntry(this.seq + "." + ext);
        ++this.seq;
        entry.setSize(value.length());
        this.stream.putNextEntry(entry);
        value.writeTo((OutputStream)this.stream);
        this.stream.closeEntry();
    }

    private void store(String ext, MessageBuffer<?, ?> value) throws IOException {
        TarEntry entry = new TarEntry(this.seq + "." + ext);
        ++this.seq;
        entry.setSize(value.serializedSizeFramed());
        this.stream.putNextEntry(entry);
        value.writeFramed((OutputStream)this.stream);
        this.stream.closeEntry();
    }

    public void store_queue(QueuePB.Getter value) throws IOException {
        this.store("que", value.freeze());
    }

    public void store_queue_entry(QueueEntryPB.Getter value) throws IOException {
        this.store("qen", value.freeze());
    }

    public void store_message(MessagePB.Getter value) throws IOException {
        this.store("msg", value.freeze());
    }

    public void store_map_entry(MapEntryPB.Getter value) throws IOException {
        this.store("map", value.freeze());
    }
}

