/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.model.PreconditionContainer;
import org.apache.camel.model.language.SimpleExpression;
import org.apache.camel.support.DefaultExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PreconditionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(PreconditionHelper.class);

    private PreconditionHelper() {
    }

    static boolean included(PreconditionContainer container, CamelContext context) {
        String precondition = container.getPrecondition();
        if (precondition == null) {
            LOG.trace("No precondition found, the {} is included by default", (Object)container.getLabel());
            return true;
        }
        SimpleExpression expression = new SimpleExpression(precondition);
        expression.initPredicate(context);
        Predicate predicate = expression.getPredicate();
        predicate.initPredicate(context);
        boolean matches = predicate.matches((Exchange)new DefaultExchange(context));
        if (LOG.isTraceEnabled()) {
            LOG.trace("The precondition has been evaluated to {}, consequently the {} is {}", new Object[]{matches, container.getLabel(), matches ? "included" : "excluded"});
        }
        return matches;
    }
}

