<?php
namespace Airavata\Model\Experiment;

/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
use Thrift\Base\TBase;
use Thrift\Type\TType;
use Thrift\Type\TMessageType;
use Thrift\Exception\TException;
use Thrift\Exception\TProtocolException;
use Thrift\Protocol\TProtocol;
use Thrift\Protocol\TBinaryProtocolAccelerated;
use Thrift\Exception\TApplicationException;


final class ExperimentType {
  const SINGLE_APPLICATION = 0;
  const WORKFLOW = 1;
  static public $__names = array(
    0 => 'SINGLE_APPLICATION',
    1 => 'WORKFLOW',
  );
}

final class ExperimentSearchFields {
  const EXPERIMENT_NAME = 0;
  const EXPERIMENT_DESC = 1;
  const APPLICATION_ID = 2;
  const FROM_DATE = 3;
  const TO_DATE = 4;
  const STATUS = 5;
  const PROJECT_ID = 6;
  static public $__names = array(
    0 => 'EXPERIMENT_NAME',
    1 => 'EXPERIMENT_DESC',
    2 => 'APPLICATION_ID',
    3 => 'FROM_DATE',
    4 => 'TO_DATE',
    5 => 'STATUS',
    6 => 'PROJECT_ID',
  );
}

final class ProjectSearchFields {
  const PROJECT_NAME = 0;
  const PROJECT_DESCRIPTION = 1;
  static public $__names = array(
    0 => 'PROJECT_NAME',
    1 => 'PROJECT_DESCRIPTION',
  );
}

/**
 * A structure holding the experiment configuration.
 * 
 * 
 */
class UserConfigurationDataModel {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $airavataAutoSchedule = false;
  /**
   * @var bool
   */
  public $overrideManualScheduledParams = false;
  /**
   * @var bool
   */
  public $shareExperimentPublicly = false;
  /**
   * @var \Airavata\Model\Scheduling\ComputationalResourceSchedulingModel
   */
  public $computationalResourceScheduling = null;
  /**
   * @var bool
   */
  public $throttleResources = false;
  /**
   * @var string
   */
  public $userDN = null;
  /**
   * @var bool
   */
  public $generateCert = false;
  /**
   * @var string
   */
  public $storageId = null;
  /**
   * @var string
   */
  public $experimentDataDir = null;
  /**
   * @var bool
   */
  public $useUserCRPref = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'airavataAutoSchedule',
          'type' => TType::BOOL,
          ),
        2 => array(
          'var' => 'overrideManualScheduledParams',
          'type' => TType::BOOL,
          ),
        3 => array(
          'var' => 'shareExperimentPublicly',
          'type' => TType::BOOL,
          ),
        4 => array(
          'var' => 'computationalResourceScheduling',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Scheduling\ComputationalResourceSchedulingModel',
          ),
        5 => array(
          'var' => 'throttleResources',
          'type' => TType::BOOL,
          ),
        6 => array(
          'var' => 'userDN',
          'type' => TType::STRING,
          ),
        7 => array(
          'var' => 'generateCert',
          'type' => TType::BOOL,
          ),
        8 => array(
          'var' => 'storageId',
          'type' => TType::STRING,
          ),
        9 => array(
          'var' => 'experimentDataDir',
          'type' => TType::STRING,
          ),
        10 => array(
          'var' => 'useUserCRPref',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['airavataAutoSchedule'])) {
        $this->airavataAutoSchedule = $vals['airavataAutoSchedule'];
      }
      if (isset($vals['overrideManualScheduledParams'])) {
        $this->overrideManualScheduledParams = $vals['overrideManualScheduledParams'];
      }
      if (isset($vals['shareExperimentPublicly'])) {
        $this->shareExperimentPublicly = $vals['shareExperimentPublicly'];
      }
      if (isset($vals['computationalResourceScheduling'])) {
        $this->computationalResourceScheduling = $vals['computationalResourceScheduling'];
      }
      if (isset($vals['throttleResources'])) {
        $this->throttleResources = $vals['throttleResources'];
      }
      if (isset($vals['userDN'])) {
        $this->userDN = $vals['userDN'];
      }
      if (isset($vals['generateCert'])) {
        $this->generateCert = $vals['generateCert'];
      }
      if (isset($vals['storageId'])) {
        $this->storageId = $vals['storageId'];
      }
      if (isset($vals['experimentDataDir'])) {
        $this->experimentDataDir = $vals['experimentDataDir'];
      }
      if (isset($vals['useUserCRPref'])) {
        $this->useUserCRPref = $vals['useUserCRPref'];
      }
    }
  }

  public function getName() {
    return 'UserConfigurationDataModel';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->airavataAutoSchedule);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->overrideManualScheduledParams);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->shareExperimentPublicly);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->computationalResourceScheduling = new \Airavata\Model\Scheduling\ComputationalResourceSchedulingModel();
            $xfer += $this->computationalResourceScheduling->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->throttleResources);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->userDN);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 7:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->generateCert);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 8:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->storageId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 9:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->experimentDataDir);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 10:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->useUserCRPref);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('UserConfigurationDataModel');
    if ($this->airavataAutoSchedule !== null) {
      $xfer += $output->writeFieldBegin('airavataAutoSchedule', TType::BOOL, 1);
      $xfer += $output->writeBool($this->airavataAutoSchedule);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->overrideManualScheduledParams !== null) {
      $xfer += $output->writeFieldBegin('overrideManualScheduledParams', TType::BOOL, 2);
      $xfer += $output->writeBool($this->overrideManualScheduledParams);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->shareExperimentPublicly !== null) {
      $xfer += $output->writeFieldBegin('shareExperimentPublicly', TType::BOOL, 3);
      $xfer += $output->writeBool($this->shareExperimentPublicly);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->computationalResourceScheduling !== null) {
      if (!is_object($this->computationalResourceScheduling)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('computationalResourceScheduling', TType::STRUCT, 4);
      $xfer += $this->computationalResourceScheduling->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->throttleResources !== null) {
      $xfer += $output->writeFieldBegin('throttleResources', TType::BOOL, 5);
      $xfer += $output->writeBool($this->throttleResources);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userDN !== null) {
      $xfer += $output->writeFieldBegin('userDN', TType::STRING, 6);
      $xfer += $output->writeString($this->userDN);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->generateCert !== null) {
      $xfer += $output->writeFieldBegin('generateCert', TType::BOOL, 7);
      $xfer += $output->writeBool($this->generateCert);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->storageId !== null) {
      $xfer += $output->writeFieldBegin('storageId', TType::STRING, 8);
      $xfer += $output->writeString($this->storageId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->experimentDataDir !== null) {
      $xfer += $output->writeFieldBegin('experimentDataDir', TType::STRING, 9);
      $xfer += $output->writeString($this->experimentDataDir);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->useUserCRPref !== null) {
      $xfer += $output->writeFieldBegin('useUserCRPref', TType::BOOL, 10);
      $xfer += $output->writeBool($this->useUserCRPref);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

/**
 * A structure holding the experiment metadata and its child models.
 * 
 * userName:
 *   The user name of the targeted gateway end user on whose behalf the experiment is being created.
 *     the associated gateway identity can only be inferred from the security hand-shake so as to avoid
 *     authorized Airavata Clients mimicking an unauthorized request. If a gateway is not registered with
 *     Airavata, an authorization exception is thrown.
 * 
 * experimentName:
 *   The name of the experiment as defined by the user. The name need not be unique as uniqueness is enforced
 *      by the generated experiment id.
 * 
 * experimentDescription:
 *    The verbose description of the experiment. This is an optional parameter.
 */
class ExperimentModel {
  static $_TSPEC;

  /**
   * @var string
   */
  public $experimentId = "DO_NOT_SET_AT_CLIENTS";
  /**
   * @var string
   */
  public $projectId = null;
  /**
   * @var string
   */
  public $gatewayId = null;
  /**
   * @var int
   */
  public $experimentType =   0;
  /**
   * @var string
   */
  public $userName = null;
  /**
   * @var string
   */
  public $experimentName = null;
  /**
   * @var int
   */
  public $creationTime = null;
  /**
   * @var string
   */
  public $description = null;
  /**
   * @var string
   */
  public $executionId = null;
  /**
   * @var string
   */
  public $gatewayExecutionId = null;
  /**
   * @var string
   */
  public $gatewayInstanceId = null;
  /**
   * @var bool
   */
  public $enableEmailNotification = null;
  /**
   * @var string[]
   */
  public $emailAddresses = null;
  /**
   * @var \Airavata\Model\Experiment\UserConfigurationDataModel
   */
  public $userConfigurationData = null;
  /**
   * @var \Airavata\Model\Application\Io\InputDataObjectType[]
   */
  public $experimentInputs = null;
  /**
   * @var \Airavata\Model\Application\Io\OutputDataObjectType[]
   */
  public $experimentOutputs = null;
  /**
   * @var \Airavata\Model\Status\ExperimentStatus[]
   */
  public $experimentStatus = null;
  /**
   * @var \Airavata\Model\Commons\ErrorModel[]
   */
  public $errors = null;
  /**
   * @var \Airavata\Model\Process\ProcessModel[]
   */
  public $processes = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'experimentId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'projectId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'experimentType',
          'type' => TType::I32,
          ),
        5 => array(
          'var' => 'userName',
          'type' => TType::STRING,
          ),
        6 => array(
          'var' => 'experimentName',
          'type' => TType::STRING,
          ),
        7 => array(
          'var' => 'creationTime',
          'type' => TType::I64,
          ),
        8 => array(
          'var' => 'description',
          'type' => TType::STRING,
          ),
        9 => array(
          'var' => 'executionId',
          'type' => TType::STRING,
          ),
        10 => array(
          'var' => 'gatewayExecutionId',
          'type' => TType::STRING,
          ),
        11 => array(
          'var' => 'gatewayInstanceId',
          'type' => TType::STRING,
          ),
        12 => array(
          'var' => 'enableEmailNotification',
          'type' => TType::BOOL,
          ),
        13 => array(
          'var' => 'emailAddresses',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        14 => array(
          'var' => 'userConfigurationData',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Experiment\UserConfigurationDataModel',
          ),
        15 => array(
          'var' => 'experimentInputs',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Application\Io\InputDataObjectType',
            ),
          ),
        16 => array(
          'var' => 'experimentOutputs',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Application\Io\OutputDataObjectType',
            ),
          ),
        17 => array(
          'var' => 'experimentStatus',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Status\ExperimentStatus',
            ),
          ),
        18 => array(
          'var' => 'errors',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Commons\ErrorModel',
            ),
          ),
        19 => array(
          'var' => 'processes',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Process\ProcessModel',
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['experimentId'])) {
        $this->experimentId = $vals['experimentId'];
      }
      if (isset($vals['projectId'])) {
        $this->projectId = $vals['projectId'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
      if (isset($vals['experimentType'])) {
        $this->experimentType = $vals['experimentType'];
      }
      if (isset($vals['userName'])) {
        $this->userName = $vals['userName'];
      }
      if (isset($vals['experimentName'])) {
        $this->experimentName = $vals['experimentName'];
      }
      if (isset($vals['creationTime'])) {
        $this->creationTime = $vals['creationTime'];
      }
      if (isset($vals['description'])) {
        $this->description = $vals['description'];
      }
      if (isset($vals['executionId'])) {
        $this->executionId = $vals['executionId'];
      }
      if (isset($vals['gatewayExecutionId'])) {
        $this->gatewayExecutionId = $vals['gatewayExecutionId'];
      }
      if (isset($vals['gatewayInstanceId'])) {
        $this->gatewayInstanceId = $vals['gatewayInstanceId'];
      }
      if (isset($vals['enableEmailNotification'])) {
        $this->enableEmailNotification = $vals['enableEmailNotification'];
      }
      if (isset($vals['emailAddresses'])) {
        $this->emailAddresses = $vals['emailAddresses'];
      }
      if (isset($vals['userConfigurationData'])) {
        $this->userConfigurationData = $vals['userConfigurationData'];
      }
      if (isset($vals['experimentInputs'])) {
        $this->experimentInputs = $vals['experimentInputs'];
      }
      if (isset($vals['experimentOutputs'])) {
        $this->experimentOutputs = $vals['experimentOutputs'];
      }
      if (isset($vals['experimentStatus'])) {
        $this->experimentStatus = $vals['experimentStatus'];
      }
      if (isset($vals['errors'])) {
        $this->errors = $vals['errors'];
      }
      if (isset($vals['processes'])) {
        $this->processes = $vals['processes'];
      }
    }
  }

  public function getName() {
    return 'ExperimentModel';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->experimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->projectId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->experimentType);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->userName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->experimentName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 7:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->creationTime);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 8:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->description);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 9:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->executionId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 10:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayExecutionId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 11:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayInstanceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 12:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->enableEmailNotification);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 13:
          if ($ftype == TType::LST) {
            $this->emailAddresses = array();
            $_size0 = 0;
            $_etype3 = 0;
            $xfer += $input->readListBegin($_etype3, $_size0);
            for ($_i4 = 0; $_i4 < $_size0; ++$_i4)
            {
              $elem5 = null;
              $xfer += $input->readString($elem5);
              $this->emailAddresses []= $elem5;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 14:
          if ($ftype == TType::STRUCT) {
            $this->userConfigurationData = new \Airavata\Model\Experiment\UserConfigurationDataModel();
            $xfer += $this->userConfigurationData->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 15:
          if ($ftype == TType::LST) {
            $this->experimentInputs = array();
            $_size6 = 0;
            $_etype9 = 0;
            $xfer += $input->readListBegin($_etype9, $_size6);
            for ($_i10 = 0; $_i10 < $_size6; ++$_i10)
            {
              $elem11 = null;
              $elem11 = new \Airavata\Model\Application\Io\InputDataObjectType();
              $xfer += $elem11->read($input);
              $this->experimentInputs []= $elem11;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 16:
          if ($ftype == TType::LST) {
            $this->experimentOutputs = array();
            $_size12 = 0;
            $_etype15 = 0;
            $xfer += $input->readListBegin($_etype15, $_size12);
            for ($_i16 = 0; $_i16 < $_size12; ++$_i16)
            {
              $elem17 = null;
              $elem17 = new \Airavata\Model\Application\Io\OutputDataObjectType();
              $xfer += $elem17->read($input);
              $this->experimentOutputs []= $elem17;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 17:
          if ($ftype == TType::LST) {
            $this->experimentStatus = array();
            $_size18 = 0;
            $_etype21 = 0;
            $xfer += $input->readListBegin($_etype21, $_size18);
            for ($_i22 = 0; $_i22 < $_size18; ++$_i22)
            {
              $elem23 = null;
              $elem23 = new \Airavata\Model\Status\ExperimentStatus();
              $xfer += $elem23->read($input);
              $this->experimentStatus []= $elem23;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 18:
          if ($ftype == TType::LST) {
            $this->errors = array();
            $_size24 = 0;
            $_etype27 = 0;
            $xfer += $input->readListBegin($_etype27, $_size24);
            for ($_i28 = 0; $_i28 < $_size24; ++$_i28)
            {
              $elem29 = null;
              $elem29 = new \Airavata\Model\Commons\ErrorModel();
              $xfer += $elem29->read($input);
              $this->errors []= $elem29;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 19:
          if ($ftype == TType::LST) {
            $this->processes = array();
            $_size30 = 0;
            $_etype33 = 0;
            $xfer += $input->readListBegin($_etype33, $_size30);
            for ($_i34 = 0; $_i34 < $_size30; ++$_i34)
            {
              $elem35 = null;
              $elem35 = new \Airavata\Model\Process\ProcessModel();
              $xfer += $elem35->read($input);
              $this->processes []= $elem35;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ExperimentModel');
    if ($this->experimentId !== null) {
      $xfer += $output->writeFieldBegin('experimentId', TType::STRING, 1);
      $xfer += $output->writeString($this->experimentId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->projectId !== null) {
      $xfer += $output->writeFieldBegin('projectId', TType::STRING, 2);
      $xfer += $output->writeString($this->projectId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 3);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->experimentType !== null) {
      $xfer += $output->writeFieldBegin('experimentType', TType::I32, 4);
      $xfer += $output->writeI32($this->experimentType);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userName !== null) {
      $xfer += $output->writeFieldBegin('userName', TType::STRING, 5);
      $xfer += $output->writeString($this->userName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->experimentName !== null) {
      $xfer += $output->writeFieldBegin('experimentName', TType::STRING, 6);
      $xfer += $output->writeString($this->experimentName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->creationTime !== null) {
      $xfer += $output->writeFieldBegin('creationTime', TType::I64, 7);
      $xfer += $output->writeI64($this->creationTime);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->description !== null) {
      $xfer += $output->writeFieldBegin('description', TType::STRING, 8);
      $xfer += $output->writeString($this->description);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->executionId !== null) {
      $xfer += $output->writeFieldBegin('executionId', TType::STRING, 9);
      $xfer += $output->writeString($this->executionId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayExecutionId !== null) {
      $xfer += $output->writeFieldBegin('gatewayExecutionId', TType::STRING, 10);
      $xfer += $output->writeString($this->gatewayExecutionId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayInstanceId !== null) {
      $xfer += $output->writeFieldBegin('gatewayInstanceId', TType::STRING, 11);
      $xfer += $output->writeString($this->gatewayInstanceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->enableEmailNotification !== null) {
      $xfer += $output->writeFieldBegin('enableEmailNotification', TType::BOOL, 12);
      $xfer += $output->writeBool($this->enableEmailNotification);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->emailAddresses !== null) {
      if (!is_array($this->emailAddresses)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('emailAddresses', TType::LST, 13);
      {
        $output->writeListBegin(TType::STRING, count($this->emailAddresses));
        {
          foreach ($this->emailAddresses as $iter36)
          {
            $xfer += $output->writeString($iter36);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userConfigurationData !== null) {
      if (!is_object($this->userConfigurationData)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('userConfigurationData', TType::STRUCT, 14);
      $xfer += $this->userConfigurationData->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->experimentInputs !== null) {
      if (!is_array($this->experimentInputs)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('experimentInputs', TType::LST, 15);
      {
        $output->writeListBegin(TType::STRUCT, count($this->experimentInputs));
        {
          foreach ($this->experimentInputs as $iter37)
          {
            $xfer += $iter37->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->experimentOutputs !== null) {
      if (!is_array($this->experimentOutputs)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('experimentOutputs', TType::LST, 16);
      {
        $output->writeListBegin(TType::STRUCT, count($this->experimentOutputs));
        {
          foreach ($this->experimentOutputs as $iter38)
          {
            $xfer += $iter38->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->experimentStatus !== null) {
      if (!is_array($this->experimentStatus)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('experimentStatus', TType::LST, 17);
      {
        $output->writeListBegin(TType::STRUCT, count($this->experimentStatus));
        {
          foreach ($this->experimentStatus as $iter39)
          {
            $xfer += $iter39->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->errors !== null) {
      if (!is_array($this->errors)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('errors', TType::LST, 18);
      {
        $output->writeListBegin(TType::STRUCT, count($this->errors));
        {
          foreach ($this->errors as $iter40)
          {
            $xfer += $iter40->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->processes !== null) {
      if (!is_array($this->processes)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('processes', TType::LST, 19);
      {
        $output->writeListBegin(TType::STRUCT, count($this->processes));
        {
          foreach ($this->processes as $iter41)
          {
            $xfer += $iter41->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ExperimentSummaryModel {
  static $_TSPEC;

  /**
   * @var string
   */
  public $experimentId = null;
  /**
   * @var string
   */
  public $projectId = null;
  /**
   * @var string
   */
  public $gatewayId = null;
  /**
   * @var int
   */
  public $creationTime = null;
  /**
   * @var string
   */
  public $userName = null;
  /**
   * @var string
   */
  public $name = null;
  /**
   * @var string
   */
  public $description = null;
  /**
   * @var string
   */
  public $executionId = null;
  /**
   * @var string
   */
  public $resourceHostId = null;
  /**
   * @var string
   */
  public $experimentStatus = null;
  /**
   * @var int
   */
  public $statusUpdateTime = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'experimentId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'projectId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'creationTime',
          'type' => TType::I64,
          ),
        5 => array(
          'var' => 'userName',
          'type' => TType::STRING,
          ),
        6 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        7 => array(
          'var' => 'description',
          'type' => TType::STRING,
          ),
        8 => array(
          'var' => 'executionId',
          'type' => TType::STRING,
          ),
        9 => array(
          'var' => 'resourceHostId',
          'type' => TType::STRING,
          ),
        10 => array(
          'var' => 'experimentStatus',
          'type' => TType::STRING,
          ),
        12 => array(
          'var' => 'statusUpdateTime',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['experimentId'])) {
        $this->experimentId = $vals['experimentId'];
      }
      if (isset($vals['projectId'])) {
        $this->projectId = $vals['projectId'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
      if (isset($vals['creationTime'])) {
        $this->creationTime = $vals['creationTime'];
      }
      if (isset($vals['userName'])) {
        $this->userName = $vals['userName'];
      }
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
      if (isset($vals['description'])) {
        $this->description = $vals['description'];
      }
      if (isset($vals['executionId'])) {
        $this->executionId = $vals['executionId'];
      }
      if (isset($vals['resourceHostId'])) {
        $this->resourceHostId = $vals['resourceHostId'];
      }
      if (isset($vals['experimentStatus'])) {
        $this->experimentStatus = $vals['experimentStatus'];
      }
      if (isset($vals['statusUpdateTime'])) {
        $this->statusUpdateTime = $vals['statusUpdateTime'];
      }
    }
  }

  public function getName() {
    return 'ExperimentSummaryModel';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->experimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->projectId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->creationTime);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->userName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 7:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->description);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 8:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->executionId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 9:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->resourceHostId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 10:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->experimentStatus);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 12:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->statusUpdateTime);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ExperimentSummaryModel');
    if ($this->experimentId !== null) {
      $xfer += $output->writeFieldBegin('experimentId', TType::STRING, 1);
      $xfer += $output->writeString($this->experimentId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->projectId !== null) {
      $xfer += $output->writeFieldBegin('projectId', TType::STRING, 2);
      $xfer += $output->writeString($this->projectId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 3);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->creationTime !== null) {
      $xfer += $output->writeFieldBegin('creationTime', TType::I64, 4);
      $xfer += $output->writeI64($this->creationTime);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userName !== null) {
      $xfer += $output->writeFieldBegin('userName', TType::STRING, 5);
      $xfer += $output->writeString($this->userName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 6);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->description !== null) {
      $xfer += $output->writeFieldBegin('description', TType::STRING, 7);
      $xfer += $output->writeString($this->description);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->executionId !== null) {
      $xfer += $output->writeFieldBegin('executionId', TType::STRING, 8);
      $xfer += $output->writeString($this->executionId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->resourceHostId !== null) {
      $xfer += $output->writeFieldBegin('resourceHostId', TType::STRING, 9);
      $xfer += $output->writeString($this->resourceHostId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->experimentStatus !== null) {
      $xfer += $output->writeFieldBegin('experimentStatus', TType::STRING, 10);
      $xfer += $output->writeString($this->experimentStatus);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->statusUpdateTime !== null) {
      $xfer += $output->writeFieldBegin('statusUpdateTime', TType::I64, 12);
      $xfer += $output->writeI64($this->statusUpdateTime);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ExperimentStatistics {
  static $_TSPEC;

  /**
   * @var int
   */
  public $allExperimentCount = null;
  /**
   * @var int
   */
  public $completedExperimentCount = null;
  /**
   * @var int
   */
  public $cancelledExperimentCount = null;
  /**
   * @var int
   */
  public $failedExperimentCount = null;
  /**
   * @var int
   */
  public $createdExperimentCount = null;
  /**
   * @var int
   */
  public $runningExperimentCount = null;
  /**
   * @var \Airavata\Model\Experiment\ExperimentSummaryModel[]
   */
  public $allExperiments = null;
  /**
   * @var \Airavata\Model\Experiment\ExperimentSummaryModel[]
   */
  public $completedExperiments = null;
  /**
   * @var \Airavata\Model\Experiment\ExperimentSummaryModel[]
   */
  public $failedExperiments = null;
  /**
   * @var \Airavata\Model\Experiment\ExperimentSummaryModel[]
   */
  public $cancelledExperiments = null;
  /**
   * @var \Airavata\Model\Experiment\ExperimentSummaryModel[]
   */
  public $createdExperiments = null;
  /**
   * @var \Airavata\Model\Experiment\ExperimentSummaryModel[]
   */
  public $runningExperiments = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'allExperimentCount',
          'type' => TType::I32,
          ),
        2 => array(
          'var' => 'completedExperimentCount',
          'type' => TType::I32,
          ),
        3 => array(
          'var' => 'cancelledExperimentCount',
          'type' => TType::I32,
          ),
        4 => array(
          'var' => 'failedExperimentCount',
          'type' => TType::I32,
          ),
        5 => array(
          'var' => 'createdExperimentCount',
          'type' => TType::I32,
          ),
        6 => array(
          'var' => 'runningExperimentCount',
          'type' => TType::I32,
          ),
        7 => array(
          'var' => 'allExperiments',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Experiment\ExperimentSummaryModel',
            ),
          ),
        8 => array(
          'var' => 'completedExperiments',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Experiment\ExperimentSummaryModel',
            ),
          ),
        9 => array(
          'var' => 'failedExperiments',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Experiment\ExperimentSummaryModel',
            ),
          ),
        10 => array(
          'var' => 'cancelledExperiments',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Experiment\ExperimentSummaryModel',
            ),
          ),
        11 => array(
          'var' => 'createdExperiments',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Experiment\ExperimentSummaryModel',
            ),
          ),
        12 => array(
          'var' => 'runningExperiments',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Experiment\ExperimentSummaryModel',
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['allExperimentCount'])) {
        $this->allExperimentCount = $vals['allExperimentCount'];
      }
      if (isset($vals['completedExperimentCount'])) {
        $this->completedExperimentCount = $vals['completedExperimentCount'];
      }
      if (isset($vals['cancelledExperimentCount'])) {
        $this->cancelledExperimentCount = $vals['cancelledExperimentCount'];
      }
      if (isset($vals['failedExperimentCount'])) {
        $this->failedExperimentCount = $vals['failedExperimentCount'];
      }
      if (isset($vals['createdExperimentCount'])) {
        $this->createdExperimentCount = $vals['createdExperimentCount'];
      }
      if (isset($vals['runningExperimentCount'])) {
        $this->runningExperimentCount = $vals['runningExperimentCount'];
      }
      if (isset($vals['allExperiments'])) {
        $this->allExperiments = $vals['allExperiments'];
      }
      if (isset($vals['completedExperiments'])) {
        $this->completedExperiments = $vals['completedExperiments'];
      }
      if (isset($vals['failedExperiments'])) {
        $this->failedExperiments = $vals['failedExperiments'];
      }
      if (isset($vals['cancelledExperiments'])) {
        $this->cancelledExperiments = $vals['cancelledExperiments'];
      }
      if (isset($vals['createdExperiments'])) {
        $this->createdExperiments = $vals['createdExperiments'];
      }
      if (isset($vals['runningExperiments'])) {
        $this->runningExperiments = $vals['runningExperiments'];
      }
    }
  }

  public function getName() {
    return 'ExperimentStatistics';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->allExperimentCount);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->completedExperimentCount);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->cancelledExperimentCount);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->failedExperimentCount);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->createdExperimentCount);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->runningExperimentCount);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 7:
          if ($ftype == TType::LST) {
            $this->allExperiments = array();
            $_size42 = 0;
            $_etype45 = 0;
            $xfer += $input->readListBegin($_etype45, $_size42);
            for ($_i46 = 0; $_i46 < $_size42; ++$_i46)
            {
              $elem47 = null;
              $elem47 = new \Airavata\Model\Experiment\ExperimentSummaryModel();
              $xfer += $elem47->read($input);
              $this->allExperiments []= $elem47;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 8:
          if ($ftype == TType::LST) {
            $this->completedExperiments = array();
            $_size48 = 0;
            $_etype51 = 0;
            $xfer += $input->readListBegin($_etype51, $_size48);
            for ($_i52 = 0; $_i52 < $_size48; ++$_i52)
            {
              $elem53 = null;
              $elem53 = new \Airavata\Model\Experiment\ExperimentSummaryModel();
              $xfer += $elem53->read($input);
              $this->completedExperiments []= $elem53;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 9:
          if ($ftype == TType::LST) {
            $this->failedExperiments = array();
            $_size54 = 0;
            $_etype57 = 0;
            $xfer += $input->readListBegin($_etype57, $_size54);
            for ($_i58 = 0; $_i58 < $_size54; ++$_i58)
            {
              $elem59 = null;
              $elem59 = new \Airavata\Model\Experiment\ExperimentSummaryModel();
              $xfer += $elem59->read($input);
              $this->failedExperiments []= $elem59;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 10:
          if ($ftype == TType::LST) {
            $this->cancelledExperiments = array();
            $_size60 = 0;
            $_etype63 = 0;
            $xfer += $input->readListBegin($_etype63, $_size60);
            for ($_i64 = 0; $_i64 < $_size60; ++$_i64)
            {
              $elem65 = null;
              $elem65 = new \Airavata\Model\Experiment\ExperimentSummaryModel();
              $xfer += $elem65->read($input);
              $this->cancelledExperiments []= $elem65;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 11:
          if ($ftype == TType::LST) {
            $this->createdExperiments = array();
            $_size66 = 0;
            $_etype69 = 0;
            $xfer += $input->readListBegin($_etype69, $_size66);
            for ($_i70 = 0; $_i70 < $_size66; ++$_i70)
            {
              $elem71 = null;
              $elem71 = new \Airavata\Model\Experiment\ExperimentSummaryModel();
              $xfer += $elem71->read($input);
              $this->createdExperiments []= $elem71;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 12:
          if ($ftype == TType::LST) {
            $this->runningExperiments = array();
            $_size72 = 0;
            $_etype75 = 0;
            $xfer += $input->readListBegin($_etype75, $_size72);
            for ($_i76 = 0; $_i76 < $_size72; ++$_i76)
            {
              $elem77 = null;
              $elem77 = new \Airavata\Model\Experiment\ExperimentSummaryModel();
              $xfer += $elem77->read($input);
              $this->runningExperiments []= $elem77;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ExperimentStatistics');
    if ($this->allExperimentCount !== null) {
      $xfer += $output->writeFieldBegin('allExperimentCount', TType::I32, 1);
      $xfer += $output->writeI32($this->allExperimentCount);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->completedExperimentCount !== null) {
      $xfer += $output->writeFieldBegin('completedExperimentCount', TType::I32, 2);
      $xfer += $output->writeI32($this->completedExperimentCount);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cancelledExperimentCount !== null) {
      $xfer += $output->writeFieldBegin('cancelledExperimentCount', TType::I32, 3);
      $xfer += $output->writeI32($this->cancelledExperimentCount);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->failedExperimentCount !== null) {
      $xfer += $output->writeFieldBegin('failedExperimentCount', TType::I32, 4);
      $xfer += $output->writeI32($this->failedExperimentCount);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->createdExperimentCount !== null) {
      $xfer += $output->writeFieldBegin('createdExperimentCount', TType::I32, 5);
      $xfer += $output->writeI32($this->createdExperimentCount);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->runningExperimentCount !== null) {
      $xfer += $output->writeFieldBegin('runningExperimentCount', TType::I32, 6);
      $xfer += $output->writeI32($this->runningExperimentCount);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->allExperiments !== null) {
      if (!is_array($this->allExperiments)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('allExperiments', TType::LST, 7);
      {
        $output->writeListBegin(TType::STRUCT, count($this->allExperiments));
        {
          foreach ($this->allExperiments as $iter78)
          {
            $xfer += $iter78->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->completedExperiments !== null) {
      if (!is_array($this->completedExperiments)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('completedExperiments', TType::LST, 8);
      {
        $output->writeListBegin(TType::STRUCT, count($this->completedExperiments));
        {
          foreach ($this->completedExperiments as $iter79)
          {
            $xfer += $iter79->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->failedExperiments !== null) {
      if (!is_array($this->failedExperiments)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('failedExperiments', TType::LST, 9);
      {
        $output->writeListBegin(TType::STRUCT, count($this->failedExperiments));
        {
          foreach ($this->failedExperiments as $iter80)
          {
            $xfer += $iter80->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cancelledExperiments !== null) {
      if (!is_array($this->cancelledExperiments)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('cancelledExperiments', TType::LST, 10);
      {
        $output->writeListBegin(TType::STRUCT, count($this->cancelledExperiments));
        {
          foreach ($this->cancelledExperiments as $iter81)
          {
            $xfer += $iter81->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->createdExperiments !== null) {
      if (!is_array($this->createdExperiments)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('createdExperiments', TType::LST, 11);
      {
        $output->writeListBegin(TType::STRUCT, count($this->createdExperiments));
        {
          foreach ($this->createdExperiments as $iter82)
          {
            $xfer += $iter82->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->runningExperiments !== null) {
      if (!is_array($this->runningExperiments)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('runningExperiments', TType::LST, 12);
      {
        $output->writeListBegin(TType::STRUCT, count($this->runningExperiments));
        {
          foreach ($this->runningExperiments as $iter83)
          {
            $xfer += $iter83->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}


