/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.replica.catalog.utils;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.airavata.model.data.replica.DataProductModel;
import org.apache.airavata.model.data.replica.DataProductType;
import org.apache.airavata.model.data.replica.DataReplicaLocationModel;
import org.apache.airavata.model.data.replica.ReplicaLocationCategory;
import org.apache.airavata.model.data.replica.ReplicaPersistentType;
import org.apache.airavata.registry.core.replica.catalog.model.DataProduct;
import org.apache.airavata.registry.core.replica.catalog.model.DataProductMetaData;
import org.apache.airavata.registry.core.replica.catalog.model.DataReplicaLocation;
import org.apache.airavata.registry.core.replica.catalog.model.DataReplicaMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftDataModelConversion {
    private static final Logger logger = LoggerFactory.getLogger(ThriftDataModelConversion.class);

    public static DataProductModel getDataProductModel(DataProduct dataProduct) {
        if (dataProduct != null) {
            DataProductModel dataProductModel = new DataProductModel();
            dataProductModel.setProductUri(dataProduct.getProductUri());
            dataProductModel.setGatewayId(dataProduct.getGatewayId());
            dataProductModel.setParentProductUri(dataProduct.getParentProductUri());
            dataProductModel.setProductName(dataProduct.getProductName());
            if (dataProduct.getDataProductType() != null) {
                dataProductModel.setDataProductType(DataProductType.valueOf((String)dataProduct.getDataProductType()));
            } else {
                dataProductModel.setDataProductType(DataProductType.FILE);
            }
            dataProductModel.setProductDescription(dataProduct.getProductDescription());
            dataProductModel.setOwnerName(dataProduct.getOwnerName());
            dataProductModel.setProductSize(dataProduct.getProductSize());
            if (dataProduct.getCreationTime() != null) {
                dataProductModel.setCreationTime(dataProduct.getCreationTime().getTime());
            }
            if (dataProduct.getLastModifiedTime() != null) {
                dataProductModel.setLastModifiedTime(dataProduct.getLastModifiedTime().getTime());
            }
            dataProductModel.setProductMetadata(ThriftDataModelConversion.getResourceMetaData(dataProduct.getDataProductMetaData()));
            if (dataProduct.getDataReplicaLocations() != null) {
                ArrayList dataReplicaLocationModels = new ArrayList();
                dataProduct.getDataReplicaLocations().stream().forEach(r -> dataReplicaLocationModels.add(ThriftDataModelConversion.getDataReplicaLocationModel(r)));
                dataProductModel.setReplicaLocations(dataReplicaLocationModels);
            }
            return dataProductModel;
        }
        return null;
    }

    public static DataProduct getDataProduct(DataProductModel dataProductModel) {
        if (dataProductModel != null) {
            DataProduct dataProduct = new DataProduct();
            return ThriftDataModelConversion.getUpdatedDataProduct(dataProductModel, dataProduct);
        }
        return null;
    }

    public static DataProduct getUpdatedDataProduct(DataProductModel dataProductModel, DataProduct dataProduct) {
        dataProduct.setProductUri(dataProductModel.getProductUri());
        dataProduct.setGatewayId(dataProductModel.getGatewayId());
        dataProduct.setProductName(dataProductModel.getProductName());
        dataProduct.setParentProductUri(dataProductModel.getParentProductUri());
        if (dataProductModel.getDataProductType() != null) {
            dataProduct.setDataProductType(dataProductModel.getDataProductType().toString());
        } else {
            dataProduct.setDataProductType(DataProductType.FILE.toString());
        }
        dataProduct.setProductDescription(dataProductModel.getProductDescription());
        dataProduct.setOwnerName(dataProductModel.getOwnerName());
        dataProduct.setProductSize(dataProductModel.getProductSize());
        if (dataProductModel.getCreationTime() > 0L) {
            dataProduct.setCreationTime(new Timestamp(dataProductModel.getCreationTime()));
        }
        if (dataProductModel.getLastModifiedTime() > 0L) {
            dataProduct.setLastModifiedTime(new Timestamp(dataProductModel.getLastModifiedTime()));
        }
        ArrayList<DataProductMetaData> dataProductMetaData = new ArrayList<DataProductMetaData>();
        if (dataProductModel.getProductMetadata() != null) {
            dataProductModel.getProductMetadata().keySet().stream().forEach(k -> {
                String v = (String)dataProductModel.getProductMetadata().get(k);
                DataProductMetaData temp = new DataProductMetaData();
                temp.setProductUri(dataProduct.getProductUri());
                temp.setKey((String)k);
                temp.setValue(v);
                dataProductMetaData.add(temp);
            });
            dataProduct.setDataProductMetaData(dataProductMetaData);
        }
        if (dataProductModel.getReplicaLocations() != null) {
            ArrayList<DataReplicaLocation> dataReplicaLocations = new ArrayList<DataReplicaLocation>();
            dataProductModel.getReplicaLocations().stream().forEach(r -> {
                DataReplicaLocation dataReplicaLocationModel = ThriftDataModelConversion.getDataReplicaLocation(r);
                dataReplicaLocationModel.setProductUri(dataProductModel.getProductUri());
                dataReplicaLocations.add(dataReplicaLocationModel);
            });
            dataProduct.setDataReplicaLocations(dataReplicaLocations);
        }
        return dataProduct;
    }

    public static DataReplicaLocationModel getDataReplicaLocationModel(DataReplicaLocation replicaLocation) {
        if (replicaLocation != null) {
            DataReplicaLocationModel replicaLocationModel = new DataReplicaLocationModel();
            replicaLocationModel.setReplicaId(replicaLocation.getReplicaId());
            replicaLocationModel.setProductUri(replicaLocation.getProductUri());
            replicaLocationModel.setReplicaName(replicaLocation.getReplicaName());
            replicaLocationModel.setReplicaDescription(replicaLocation.getReplicaDescription());
            replicaLocationModel.setStorageResourceId(replicaLocation.getStorageResourceId());
            if (replicaLocation.getValidUntilTime() != null) {
                replicaLocationModel.setValidUntilTime(replicaLocation.getValidUntilTime().getTime());
            }
            replicaLocationModel.setFilePath(replicaLocation.getFilePath());
            if (replicaLocation.getCreationTime() != null) {
                replicaLocationModel.setCreationTime(replicaLocation.getCreationTime().getTime());
            }
            if (replicaLocation.getLastModifiedTime() != null) {
                replicaLocationModel.setLastModifiedTime(replicaLocation.getLastModifiedTime().getTime());
            }
            if (replicaLocation.getReplicaLocationCategory() != null) {
                replicaLocationModel.setReplicaLocationCategory(ReplicaLocationCategory.valueOf((String)replicaLocation.getReplicaLocationCategory().toString()));
            }
            if (replicaLocation.getReplicaPersistentType() != null) {
                replicaLocationModel.setReplicaPersistentType(ReplicaPersistentType.valueOf((String)replicaLocation.getReplicaPersistentType().toString()));
            }
            replicaLocationModel.setReplicaMetadata(ThriftDataModelConversion.getReplicaMetaData(replicaLocation.getDataReplicaMetaData()));
            return replicaLocationModel;
        }
        return null;
    }

    public static DataReplicaLocation getDataReplicaLocation(DataReplicaLocationModel dataReplicaLocationModel) {
        if (dataReplicaLocationModel != null) {
            DataReplicaLocation dataReplicaLocation = new DataReplicaLocation();
            return ThriftDataModelConversion.getUpdatedDataReplicaLocation(dataReplicaLocationModel, dataReplicaLocation);
        }
        return null;
    }

    public static DataReplicaLocation getUpdatedDataReplicaLocation(DataReplicaLocationModel dataReplicaLocationModel, DataReplicaLocation dataReplicaLocation) {
        dataReplicaLocation.setReplicaId(dataReplicaLocationModel.getReplicaId());
        dataReplicaLocation.setProductUri(dataReplicaLocationModel.getProductUri());
        dataReplicaLocation.setReplicaName(dataReplicaLocationModel.getReplicaName());
        dataReplicaLocation.setReplicaDescription(dataReplicaLocationModel.getReplicaDescription());
        dataReplicaLocation.setStorageResourceId(dataReplicaLocationModel.getStorageResourceId());
        dataReplicaLocation.setFilePath(dataReplicaLocationModel.getFilePath());
        if (dataReplicaLocationModel.getValidUntilTime() > 0L) {
            dataReplicaLocation.setValidUntilTime(new Timestamp(dataReplicaLocationModel.getValidUntilTime()));
        }
        if (dataReplicaLocationModel.getCreationTime() > 0L) {
            dataReplicaLocation.setCreationTime(new Timestamp(dataReplicaLocationModel.getCreationTime()));
        }
        if (dataReplicaLocationModel.getLastModifiedTime() > 0L) {
            dataReplicaLocation.setLastModifiedTime(new Timestamp(dataReplicaLocationModel.getLastModifiedTime()));
        }
        if (dataReplicaLocationModel.getReplicaLocationCategory() != null) {
            dataReplicaLocation.setReplicaLocationCategory(dataReplicaLocationModel.getReplicaLocationCategory().toString());
        }
        if (dataReplicaLocationModel.getReplicaPersistentType() != null) {
            dataReplicaLocation.setReplicaPersistentType(dataReplicaLocationModel.getReplicaPersistentType().toString());
        }
        ArrayList<DataReplicaMetaData> dataReplicaMetadata = new ArrayList<DataReplicaMetaData>();
        if (dataReplicaLocation.getDataReplicaMetaData() != null) {
            dataReplicaLocationModel.getReplicaMetadata().keySet().stream().forEach(k -> {
                String v = (String)dataReplicaLocationModel.getReplicaMetadata().get(k);
                DataReplicaMetaData temp = new DataReplicaMetaData();
                temp.setReplicaId(dataReplicaLocationModel.getProductUri());
                temp.setKey((String)k);
                temp.setValue(v);
                dataReplicaMetadata.add(temp);
            });
            dataReplicaLocation.setDataReplicaMetaData(dataReplicaMetadata);
        }
        return dataReplicaLocation;
    }

    public static Map<String, String> getResourceMetaData(Collection<DataProductMetaData> dataProductMetaData) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (dataProductMetaData != null && !dataProductMetaData.isEmpty()) {
            dataProductMetaData.stream().forEach(m -> metadata.put(m.getKey(), m.getValue()));
        }
        return metadata;
    }

    public static Map<String, String> getReplicaMetaData(Collection<DataReplicaMetaData> dataReplicaMetaData) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (dataReplicaMetaData != null && !dataReplicaMetaData.isEmpty()) {
            dataReplicaMetaData.stream().forEach(m -> metadata.put(m.getKey(), m.getValue()));
        }
        return metadata;
    }
}

