/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.ns;

import java.io.IOException;

public class ParserUtils {
    public static int checkToken(String token, char[] chars, int offset, boolean caseSensitive) throws IOException {
        int ret = ParserUtils.checkTokenSoft(token, chars, offset, caseSensitive);
        if (ret < 0) {
            throw new IOException("Syntax problem, expected token '" + token + "' but got: '" + new String(chars, offset, chars.length - offset));
        }
        return ret;
    }

    public static int checkTokenSoft(String token, char[] chars, int offset, boolean caseSensitive) {
        int i;
        char[] tokenChars = token.toCharArray();
        if (chars.length < offset + tokenChars.length) {
            return -1;
        }
        for (i = 0; i < tokenChars.length; ++i) {
            char b;
            char a = caseSensitive ? tokenChars[i] : Character.toLowerCase(tokenChars[i]);
            char c = b = caseSensitive ? chars[i + offset] : Character.toLowerCase(chars[i + offset]);
            if (a == b) continue;
            return -1;
        }
        return i;
    }

    public static void checkEndOfLine(char[] chars, int j) throws IOException {
        if (j < chars.length) {
            throw new IOException("Syntax problem, garbage at the end of line: " + new String(chars, j, chars.length - j));
        }
    }
}

