/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.pkipath;

import eu.emi.security.authn.x509.ValidationError;
import eu.emi.security.authn.x509.ValidationErrorCode;
import java.security.cert.X509Certificate;
import org.bouncycastle.i18n.ErrorBundle;
import org.bouncycastle.i18n.LocaleString;

public class BCErrorMapper {
    private static final String PFX = "CertPathReviewer.";

    public static ValidationError map(ErrorBundle error, int pos, X509Certificate[] cc) {
        String id = error.getId();
        if (!id.startsWith(PFX)) {
            return new ValidationError(cc, pos, ValidationErrorCode.unknownMsg, id);
        }
        id = id.substring(PFX.length());
        Object[] args = error.getArguments();
        if (id.equals("NoIssuerPublicKey")) {
            return new ValidationError(cc, pos, ValidationErrorCode.noIssuerPublicKey, new Object[0]);
        }
        if (id.equals("signatureNotVerified")) {
            return new ValidationError(cc, pos, ValidationErrorCode.signatureNotVerified, args[1]);
        }
        if (id.equals("certRevoked")) {
            LocaleString ls = (LocaleString)args[1];
            return new ValidationError(cc, pos, ValidationErrorCode.certRevoked, args[0], ls.getId());
        }
        try {
            ValidationErrorCode code = ValidationErrorCode.valueOf(ValidationErrorCode.class, id);
            return new ValidationError(cc, pos, code, args);
        }
        catch (IllegalArgumentException ile) {
            return new ValidationError(cc, pos, ValidationErrorCode.unknownMsg, id);
        }
    }
}

