/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.util.ssl;

import edu.uiuc.ncsa.security.core.configuration.Configurations;
import edu.uiuc.ncsa.security.util.ssl.SSLConfiguration;
import java.util.List;
import org.apache.commons.configuration.tree.ConfigurationNode;

public class SSLConfigurationUtil {
    public static final String SSL_KEYSTORE = "keystore";
    public static final String SSL_KEYSTORE_PATH = "path";
    public static final String SSL_KEYSTORE_PASSWORD = "password";
    public static final String SSL_KEYSTORE_TYPE = "type";
    public static final String SSL_KEYSTORE_FACTORY = "factory";
    public static final String SSL_KEYSTORE_USE_JAVA_KEYSTORE = "useJavaKeystore";

    public static SSLConfiguration getSSLConfiguration(ConfigurationNode node) {
        SSLConfiguration sslKeystoreConfiguration = new SSLConfiguration();
        List keystores = null;
        if (node != null) {
            keystores = node.getChildren(SSL_KEYSTORE);
        }
        if (keystores == null || keystores.isEmpty()) {
            sslKeystoreConfiguration.setUseDefaultJavaKeyStore(true);
        } else {
            ConfigurationNode cn2 = (ConfigurationNode)keystores.get(0);
            sslKeystoreConfiguration.setKeystore(Configurations.getFirstAttribute((ConfigurationNode)cn2, (String)SSL_KEYSTORE_PATH));
            sslKeystoreConfiguration.setKeystorePassword(Configurations.getFirstAttribute((ConfigurationNode)cn2, (String)SSL_KEYSTORE_PASSWORD));
            sslKeystoreConfiguration.setKeyManagerFactory(Configurations.getFirstAttribute((ConfigurationNode)cn2, (String)SSL_KEYSTORE_FACTORY));
            sslKeystoreConfiguration.setKeystoreType(Configurations.getFirstAttribute((ConfigurationNode)cn2, (String)SSL_KEYSTORE_TYPE));
            String x = Configurations.getFirstAttribute((ConfigurationNode)cn2, (String)SSL_KEYSTORE_USE_JAVA_KEYSTORE);
            if (x == null) {
                sslKeystoreConfiguration.setUseDefaultJavaKeyStore(true);
            } else {
                sslKeystoreConfiguration.setUseDefaultJavaKeyStore(Boolean.parseBoolean(x));
            }
        }
        return sslKeystoreConfiguration;
    }
}

