/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.transports;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;

public class CarbonHttpRequest {
    private String requestURL;
    private String requestURI;
    private String contextPath;
    private String queryString;
    private String httpMethod;
    private InputStream is;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> parameters = new HashMap<String, String>();

    public CarbonHttpRequest(String httpMethod, String requestUri) {
        this(httpMethod, requestUri, null);
    }

    public CarbonHttpRequest(String httpMethod, String requestURI, String requestURL) {
        this.httpMethod = httpMethod;
        this.requestURI = requestURI;
        this.requestURL = requestURL;
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void removeHeaders(String name) {
        this.headers.remove(name);
    }

    public void removeHeader(Header header) {
        this.headers.remove(header.getName());
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public void removeParameter(String str) {
        this.parameters.remove(str);
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public void setInputStream(InputStream is) {
        this.is = is;
    }

    public String getRequestURL() {
        return this.requestURL;
    }

    public void setRequestURL(String requestURL) {
        this.requestURL = requestURL;
    }
}

