/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.transports.util;

import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.core.transports.CarbonHttpRequest;
import org.wso2.carbon.core.transports.CarbonHttpResponse;
import org.wso2.carbon.core.transports.HttpGetRequestProcessor;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.core.util.KeyStoreUtil;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class CertProcessor
implements HttpGetRequestProcessor {
    private static Log log = LogFactory.getLog(CertProcessor.class);
    private CarbonCoreDataHolder dataHolder = CarbonCoreDataHolder.getInstance();

    @Override
    public void process(CarbonHttpRequest request, CarbonHttpResponse response, ConfigurationContext configurationContext) throws Exception {
        String requestURI = request.getRequestURI();
        String contextPath = configurationContext.getServiceContextPath();
        String serviceName = requestURI.substring(requestURI.indexOf(contextPath) + contextPath.length() + 1);
        AxisService axisService = configurationContext.getAxisConfiguration().getServiceForActivation(serviceName);
        OutputStream outputStream = response.getOutputStream();
        if (!axisService.isActive()) {
            response.addHeader("Content-Type", "text/html");
            outputStream.write(("<h4>Service " + serviceName + " is inactive. Cannot retrieve certificate.</h4>").getBytes());
            outputStream.flush();
        } else {
            RegistryService registryService = this.dataHolder.getRegistryService();
            UserRegistry registry = registryService.getConfigSystemRegistry();
            String servicePath = "/repository/axis2/service-groups/" + axisService.getAxisServiceGroup().getServiceGroupName() + "/services/" + axisService.getName();
            Resource serviceResource = registry.get(servicePath);
            Association[] assoc = registry.getAssociations(servicePath, "service-keystore");
            KeyStoreManager keyStoreManager = KeyStoreManager.getInstance(-1234);
            KeyStore keyStore = null;
            if (assoc.length < 1) {
                Association[] associations;
                boolean httpsEnabled = false;
                for (Association association : associations = registry.getAssociations(servicePath, "exposed.transports")) {
                    Resource resource = registry.get(association.getDestinationPath());
                    String transportProtocol = resource.getProperty("Protocol.Name");
                    if (transportProtocol.equals("https")) {
                        httpsEnabled = true;
                        break;
                    }
                    resource.discard();
                }
                if (httpsEnabled || Boolean.valueOf(serviceResource.getProperty("exposed.all.transports")).booleanValue()) {
                    keyStore = keyStoreManager.getPrimaryKeyStore();
                }
            } else {
                Object ks = null;
                String kspath = assoc[0].getDestinationPath();
                if (kspath.equals("/repository/security/key-stores/carbon-primary-ks")) {
                    keyStore = keyStoreManager.getPrimaryKeyStore();
                } else {
                    String keyStoreName = kspath.substring(kspath.lastIndexOf(47) + 1);
                    keyStore = keyStoreManager.getKeyStore(keyStoreName);
                }
            }
            serviceResource.discard();
            String alias = null;
            if (keyStore != null) {
                alias = KeyStoreUtil.getPrivateKeyAlias(keyStore);
            }
            if (alias != null) {
                Certificate cert = KeyStoreUtil.getCertificate(alias, keyStore);
                this.serializeCert(cert, response, outputStream, serviceName);
            } else {
                response.addHeader("Content-Type", "text/html");
                outputStream.write(("<h4>Service " + serviceName + " does not have a private key.</h4>").getBytes());
                outputStream.flush();
            }
        }
    }

    private void serializeCert(Certificate certificate, CarbonHttpResponse response, OutputStream outputStream, String serviceName) throws AxisFault {
        try {
            response.addHeader("Content-Type", "application/octet-stream");
            response.addHeader("Content-Disposition", "filename=" + serviceName + ".cert");
            outputStream.write(certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            String msg = "Could not get encoded format of certificate";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        catch (IOException e) {
            String msg = "Faliour when serializing to stream";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        finally {
            try {
                outputStream.flush();
            }
            catch (IOException e) {
                String msg = "Faliour when serializing to stream";
                log.error((Object)msg, (Throwable)e);
            }
        }
    }
}

