/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.lookup;

import de.fzj.unicore.uas.TargetSystemFactory;
import de.fzj.unicore.uas.client.TSFClient;
import de.fzj.unicore.uas.lookup.AddressFilter;
import de.fzj.unicore.uas.lookup.Lister;
import de.fzj.unicore.uas.lookup.Producer;
import de.fzj.unicore.uas.security.WSRFClientConfigurationProvider;
import de.fzj.unicore.uas.util.Pair;
import de.fzj.unicore.wsrflite.xmlbeans.client.IRegistryQuery;
import eu.unicore.security.wsutil.client.authn.DelegationSpecification;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class TSFLister
extends Lister<TSFClient> {
    static final Logger log = Log.getLogger("unicore.client", TSFLister.class);
    private final IRegistryQuery registry;
    private final WSRFClientConfigurationProvider configurationProvider;

    public TSFLister(IRegistryQuery registry, WSRFClientConfigurationProvider configurationProvider) {
        this(null, registry, configurationProvider, new Lister.AcceptAllFilter<TSFClient>());
    }

    public TSFLister(ExecutorService executor, IRegistryQuery registry, WSRFClientConfigurationProvider configurationProvider) {
        this(executor, registry, configurationProvider, new Lister.AcceptAllFilter<TSFClient>());
    }

    public TSFLister(ExecutorService executor, IRegistryQuery registry, WSRFClientConfigurationProvider configurationProvider, AddressFilter<TSFClient> addressFilter) {
        super(executor, addressFilter, Integer.MAX_VALUE);
        this.registry = registry;
        this.configurationProvider = configurationProvider;
    }

    @Override
    public Iterator<TSFClient> iterator() {
        try {
            this.setupProducers();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return super.iterator();
    }

    protected void setupProducers() throws Exception {
        List<EndpointReferenceType> tsfs = this.registry.listAccessibleServices(TargetSystemFactory.TSF_PORT);
        for (EndpointReferenceType tsf : tsfs) {
            if (!this.addressFilter.accept(tsf)) continue;
            this.addProducer(new TSFProducer(tsf, this.configurationProvider.getClientConfiguration(tsf, DelegationSpecification.STANDARD), this.addressFilter));
        }
    }

    public static class SiteNameFilter
    implements AddressFilter<TSFClient> {
        private final String name;

        public SiteNameFilter(String name) {
            this.name = name;
        }

        @Override
        public boolean accept(EndpointReferenceType epr) {
            return this.accept(epr.getAddress().getStringValue());
        }

        @Override
        public boolean accept(String uri) {
            return uri.contains("/" + this.name + "/");
        }

        @Override
        public boolean accept(TSFClient client) throws Exception {
            return true;
        }
    }

    public static class TSFProducer
    implements Producer<TSFClient> {
        private final EndpointReferenceType epr;
        protected final IClientConfiguration securityProperties;
        protected final List<Pair<EndpointReferenceType, String>> errors = new ArrayList<Pair<EndpointReferenceType, String>>();
        private AtomicInteger runCount;
        protected BlockingQueue<TSFClient> target;
        protected AddressFilter<TSFClient> addressFilter;

        public TSFProducer(EndpointReferenceType epr, IClientConfiguration securityProperties, AddressFilter<TSFClient> addressFilter) {
            this.epr = epr;
            this.securityProperties = securityProperties;
            this.addressFilter = addressFilter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Processing storage factory at " + this.epr.getAddress().getStringValue());
                }
                this.handleEPR(this.epr);
            }
            catch (Exception ex) {
                this.errors.add(new Pair<EndpointReferenceType, String>(this.epr, Log.createFaultMessage("", ex)));
            }
            finally {
                this.runCount.decrementAndGet();
            }
        }

        public void handleEPR(EndpointReferenceType epr) throws Exception {
            TSFClient c;
            if (this.addressFilter.accept(epr) && this.addressFilter.accept(c = new TSFClient(epr, this.securityProperties))) {
                this.target.put(c);
            }
        }

        @Override
        public void init(BlockingQueue<TSFClient> target, AtomicInteger runCount) {
            this.target = target;
            this.runCount = runCount;
        }
    }
}

