/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.validators;

import eu.unicore.samly2.SAMLUtils;
import eu.unicore.samly2.exceptions.SAMLRequesterException;
import eu.unicore.samly2.exceptions.SAMLValidationException;
import eu.unicore.samly2.trust.SamlTrustChecker;
import eu.unicore.samly2.validators.AssertionValidator;
import eu.unicore.samly2.validators.StatusResponseValidator;
import java.util.ArrayList;
import java.util.List;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;
import xmlbeans.org.oasis.saml2.assertion.AssertionType;
import xmlbeans.org.oasis.saml2.assertion.NameIDType;
import xmlbeans.org.oasis.saml2.protocol.ResponseDocument;
import xmlbeans.org.oasis.saml2.protocol.ResponseType;

public class AttributeAssertionResponseValidator
extends StatusResponseValidator {
    protected String consumerSamlName;
    protected long samlValidityGraceTime;
    protected NameIDType requestedSubject;
    protected List<AssertionDocument> attributeAssertions;

    public AttributeAssertionResponseValidator(String consumerSamlName, String consumerEndpointUri, String requestId, long samlValidityGraceTime, SamlTrustChecker trustChecker, NameIDType requestedSubject) {
        super(consumerEndpointUri, requestId, trustChecker);
        this.consumerSamlName = consumerSamlName;
        this.samlValidityGraceTime = samlValidityGraceTime;
        this.requestedSubject = requestedSubject;
    }

    public void validate(ResponseDocument attributeResponseDoc) throws SAMLValidationException {
        AssertionDocument[] assertions;
        this.attributeAssertions = new ArrayList<AssertionDocument>();
        ResponseType response = attributeResponseDoc.getResponse();
        super.validate(attributeResponseDoc, response);
        NameIDType issuer = response.getIssuer();
        if (issuer == null || issuer.isNil() || issuer.getStringValue() == null) {
            throw new SAMLRequesterException("Issuer must be present");
        }
        if (issuer.getFormat() != null && !issuer.getFormat().equals("urn:oasis:names:tc:SAML:2.0:nameid-format:entity")) {
            throw new SAMLValidationException("Issuer of SAML response must be of Entity type in SSO AuthN. It is: " + issuer.getFormat());
        }
        try {
            assertions = SAMLUtils.getAssertions(response);
        }
        catch (Exception e) {
            throw new SAMLValidationException("XML handling problem during retrieval of response assertions", e);
        }
        if (assertions == null) {
            throw new SAMLValidationException("SAML response doesn't contain any assertion");
        }
        AssertionValidator asValidator = new AssertionValidator(this.consumerSamlName, this.consumerEndpointUri, this.requestId, this.samlValidityGraceTime, this.trustChecker);
        for (AssertionDocument assertionDoc : assertions) {
            AssertionType assertion = assertionDoc.getAssertion();
            if (assertion.sizeOfAttributeStatementArray() <= 0) {
                throw new SAMLValidationException("In response to attribute query got response with assertion without attribute statements");
            }
            this.validateAssertion(assertionDoc, asValidator);
        }
    }

    protected void validateAssertion(AssertionDocument assertionDoc, AssertionValidator asValidator) throws SAMLValidationException {
        asValidator.validate(assertionDoc);
        AssertionType assertion = assertionDoc.getAssertion();
        NameIDType receivedSubject = assertion.getSubject().getNameID();
        if (!SAMLUtils.compareNameIDs(receivedSubject, this.requestedSubject)) {
            throw new SAMLValidationException("Received assertion for subject which was not requested: " + receivedSubject.xmlText() + "(requested was " + receivedSubject.xmlText() + ")");
        }
        this.attributeAssertions.add(assertionDoc);
    }

    public List<AssertionDocument> getAttributeAssertions() {
        return this.attributeAssertions;
    }
}

