/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.Compass;
import org.compass.core.CompassCallback;
import org.compass.core.CompassCallbackWithoutResult;
import org.compass.core.CompassDetachedHits;
import org.compass.core.CompassException;
import org.compass.core.CompassHits;
import org.compass.core.CompassHitsOperations;
import org.compass.core.CompassOperations;
import org.compass.core.CompassQuery;
import org.compass.core.CompassSession;
import org.compass.core.CompassTransaction;
import org.compass.core.Resource;
import org.compass.core.config.CompassSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompassTemplate
implements CompassOperations {
    private static Log log = LogFactory.getLog(CompassTemplate.class);
    private Compass compass;
    private CompassSettings globalSessionSettings = new CompassSettings();

    public CompassTemplate() {
    }

    public CompassTemplate(Compass compass) {
        this.compass = compass;
    }

    public void setCompass(Compass compass) {
        this.compass = compass;
    }

    public Compass getCompass() {
        return this.compass;
    }

    public <T> T execute(CompassCallback<T> action) throws CompassException {
        return this.execute(null, action);
    }

    public <T> T execute(CompassTransaction.TransactionIsolation transactionIsolation, CompassCallback<T> action) throws CompassException {
        CompassSession session = this.compass.openSession();
        session.getSettings().addSettings(this.globalSessionSettings);
        CompassTransaction tx = null;
        try {
            tx = session.beginTransaction(transactionIsolation);
            T result = action.doInCompass(session);
            tx.commit();
            T t = result;
            return t;
        }
        catch (RuntimeException e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    log.error((Object)"Failed to rollback transaction, ignoring", (Throwable)e1);
                }
            }
            throw e;
        }
        catch (Error err) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    log.error((Object)"Failed to rollback transaction, ignoring", (Throwable)e1);
                }
            }
            throw err;
        }
        finally {
            session.close();
        }
    }

    public <T> T executeLocal(CompassCallback<T> action) throws CompassException {
        CompassSession session = this.compass.openSession();
        session.getSettings().addSettings(this.globalSessionSettings);
        CompassTransaction tx = null;
        try {
            tx = session.beginLocalTransaction();
            T result = action.doInCompass(session);
            tx.commit();
            T t = result;
            return t;
        }
        catch (RuntimeException e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    log.error((Object)"Failed to rollback transaction, ignoring", (Throwable)e1);
                }
            }
            throw e;
        }
        catch (Error err) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    log.error((Object)"Failed to rollback transaction, ignoring", (Throwable)e1);
                }
            }
            throw err;
        }
        finally {
            session.close();
        }
    }

    public CompassHitsOperations executeFind(CompassCallback<CompassHitsOperations> action) throws CompassException {
        return this.execute(action);
    }

    public CompassSettings getSettings() {
        throw new CompassException("getSettings should not be used with CompassTemplate. Either use getGlobalSettings or execute");
    }

    @Override
    public void create(final Object obj) throws CompassException {
        this.execute(new CompassCallback<Object>(){

            @Override
            public Object doInCompass(CompassSession session) throws CompassException {
                session.create(obj);
                return null;
            }
        });
    }

    @Override
    public void create(final String alias, final Object obj) throws CompassException {
        this.execute(new CompassCallback<Object>(){

            @Override
            public Object doInCompass(CompassSession session) throws CompassException {
                session.create(alias, obj);
                return null;
            }
        });
    }

    @Override
    public void delete(final Object obj) throws CompassException {
        this.execute(new CompassCallback<Object>(){

            @Override
            public Object doInCompass(CompassSession session) throws CompassException {
                session.delete(obj);
                return null;
            }
        });
    }

    @Override
    public void delete(final Resource resource) throws CompassException {
        this.execute(new CompassCallback<Object>(){

            @Override
            public Object doInCompass(CompassSession session) throws CompassException {
                session.delete(resource);
                return null;
            }
        });
    }

    @Override
    public void delete(final Class clazz, final Object obj) throws CompassException {
        this.execute(new CompassCallback<Object>(){

            @Override
            public Object doInCompass(CompassSession session) throws CompassException {
                session.delete(clazz, obj);
                return null;
            }
        });
    }

    @Override
    public void delete(final String alias, final Object obj) throws CompassException {
        this.execute(new CompassCallback<Object>(){

            @Override
            public Object doInCompass(CompassSession session) throws CompassException {
                session.delete(alias, obj);
                return null;
            }
        });
    }

    @Override
    public void delete(final CompassQuery query) throws CompassException {
        this.execute(new CompassCallback<Object>(){

            @Override
            public Object doInCompass(CompassSession session) throws CompassException {
                session.delete(query);
                return null;
            }
        });
    }

    @Override
    public CompassHits find(final String query) throws CompassException {
        return this.execute(new CompassCallback<CompassHits>(){

            @Override
            public CompassHits doInCompass(CompassSession session) throws CompassException {
                return session.find(query);
            }
        });
    }

    public CompassDetachedHits findWithDetach(final String query) throws CompassException {
        return this.execute(new CompassCallback<CompassDetachedHits>(){

            @Override
            public CompassDetachedHits doInCompass(CompassSession session) throws CompassException {
                return session.find(query).detach();
            }
        });
    }

    public CompassDetachedHits findWithDetach(final String query, final int from, final int size) throws CompassException {
        return this.execute(new CompassCallback<CompassDetachedHits>(){

            @Override
            public CompassDetachedHits doInCompass(CompassSession session) throws CompassException {
                return session.find(query).detach(from, size);
            }
        });
    }

    @Override
    public <T> T get(final Class<T> clazz, final Object id) throws CompassException {
        return this.execute(new CompassCallback<T>(){

            @Override
            public T doInCompass(CompassSession session) throws CompassException {
                return session.get(clazz, id);
            }
        });
    }

    @Override
    public Object get(final String alias, final Object id) throws CompassException {
        return this.execute(new CompassCallback<Object>(){

            @Override
            public Object doInCompass(CompassSession session) throws CompassException {
                return session.get(alias, id);
            }
        });
    }

    @Override
    public Resource getResource(final Class clazz, final Object id) throws CompassException {
        return (Resource)this.execute(new CompassCallback<Object>(){

            @Override
            public Object doInCompass(CompassSession session) throws CompassException {
                return session.getResource(clazz, id);
            }
        });
    }

    @Override
    public Resource getResource(final String alias, final Object id) throws CompassException {
        return (Resource)this.execute(new CompassCallback<Object>(){

            @Override
            public Object doInCompass(CompassSession session) throws CompassException {
                return session.getResource(alias, id);
            }
        });
    }

    @Override
    public <T> T load(Class<T> clazz, Object ... ids) throws CompassException {
        return this.load(clazz, (Object)ids);
    }

    @Override
    public <T> T load(final Class<T> clazz, final Object id) throws CompassException {
        return this.execute(new CompassCallback<T>(){

            @Override
            public T doInCompass(CompassSession session) throws CompassException {
                return session.load(clazz, id);
            }
        });
    }

    @Override
    public Object load(String alias, Object ... ids) throws CompassException {
        return this.load(alias, (Object)ids);
    }

    @Override
    public Object load(final String alias, final Object id) throws CompassException {
        return this.execute(new CompassCallback<Object>(){

            @Override
            public Object doInCompass(CompassSession session) throws CompassException {
                return session.load(alias, id);
            }
        });
    }

    @Override
    public Resource loadResource(final Class clazz, final Object id) throws CompassException {
        return (Resource)this.execute(new CompassCallback<Object>(){

            @Override
            public Object doInCompass(CompassSession session) throws CompassException {
                return session.loadResource(clazz, id);
            }
        });
    }

    @Override
    public Resource loadResource(final String alias, final Object id) throws CompassException {
        return (Resource)this.execute(new CompassCallback<Object>(){

            @Override
            public Object doInCompass(CompassSession session) throws CompassException {
                return session.loadResource(alias, id);
            }
        });
    }

    @Override
    public void save(final Object obj) throws CompassException {
        this.execute(new CompassCallback<Object>(){

            @Override
            public Object doInCompass(CompassSession session) throws CompassException {
                session.save(obj);
                return null;
            }
        });
    }

    @Override
    public void save(final String alias, final Object obj) throws CompassException {
        this.execute(new CompassCallback<Object>(){

            @Override
            public Object doInCompass(CompassSession session) throws CompassException {
                session.save(alias, obj);
                return null;
            }
        });
    }

    @Override
    public void evict(final Object obj) {
        this.execute(new CompassCallbackWithoutResult(){

            protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                session.evict(obj);
            }
        });
    }

    @Override
    public void evict(final String alias, final Object id) {
        this.execute(new CompassCallbackWithoutResult(){

            protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                session.evict(alias, id);
            }
        });
    }

    @Override
    public void evict(final Resource resource) {
        this.execute(new CompassCallbackWithoutResult(){

            protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                session.evict(resource);
            }
        });
    }

    @Override
    public void evictAll() {
        this.execute(new CompassCallbackWithoutResult(){

            protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                session.evictAll();
            }
        });
    }

    @Override
    public Resource getResource(Class clazz, Object ... ids) throws CompassException {
        return this.getResource(clazz, (Object)ids);
    }

    @Override
    public Resource getResource(String alias, Object ... ids) throws CompassException {
        return this.getResource(alias, (Object)ids);
    }

    @Override
    public Resource loadResource(Class clazz, Object ... ids) throws CompassException {
        return this.loadResource(clazz, (Object)ids);
    }

    @Override
    public Resource loadResource(String alias, Object ... ids) throws CompassException {
        return this.loadResource(alias, (Object)ids);
    }

    @Override
    public void delete(String alias, Object ... ids) throws CompassException {
        this.delete(alias, (Object)ids);
    }

    @Override
    public void delete(Class clazz, Object ... ids) throws CompassException {
        this.delete(clazz, (Object)ids);
    }

    @Override
    public <T> T get(Class<T> clazz, Object ... ids) throws CompassException {
        return this.get(clazz, (Object)ids);
    }

    @Override
    public Object get(String alias, Object ... ids) throws CompassException {
        return this.get(alias, (Object)ids);
    }
}

