/*
 * Decompiled with CFR 0.152.
 */
package org.compass.spring.transaction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.CompassTransaction;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.transaction.AbstractTransaction;
import org.compass.core.transaction.TransactionException;
import org.compass.core.transaction.TransactionFactory;
import org.compass.spring.transaction.SpringSyncTransactionFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringSyncTransaction
extends AbstractTransaction {
    private static final Log log = LogFactory.getLog(SpringSyncTransaction.class);
    private TransactionStatus status;
    private boolean controllingNewTransaction = false;
    private boolean commitFailed;
    private PlatformTransactionManager transactionManager;
    private InternalCompassSession session;

    public SpringSyncTransaction(TransactionFactory transactionFactory) {
        super(transactionFactory);
    }

    public void begin(PlatformTransactionManager transactionManager, InternalCompassSession session, CompassTransaction.TransactionIsolation transactionIsolation, boolean commitBeforeCompletion) {
        SpringTransactionSynchronization sync;
        this.session = session;
        this.transactionManager = transactionManager;
        this.controllingNewTransaction = true;
        if (transactionManager != null) {
            DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
            transactionDefinition.setPropagationBehavior(0);
            int timeout = session.getSettings().getSettingAsInt("compass.transaction.timeout", -1);
            if (timeout != -1) {
                transactionDefinition.setTimeout(timeout);
            }
            boolean readOnly = false;
            if (transactionIsolation == CompassTransaction.TransactionIsolation.READ_ONLY_READ_COMMITTED) {
                readOnly = true;
            }
            transactionDefinition.setReadOnly(readOnly);
            this.status = transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
        }
        session.getSearchEngine().begin(transactionIsolation);
        if (transactionManager != null) {
            if (log.isDebugEnabled()) {
                if (this.status.isNewTransaction()) {
                    log.debug((Object)("Beginning new Spring transaction, and a new compass transaction on thread [" + Thread.currentThread().getName() + "] with isolation [" + transactionIsolation + "]"));
                } else {
                    log.debug((Object)("Joining Spring transaction, and starting a new compass transaction on thread [" + Thread.currentThread().getName() + "] with isolation [" + transactionIsolation + "]"));
                }
            }
            sync = new SpringTransactionSynchronization(session, this.status.isNewTransaction(), commitBeforeCompletion, this.transactionFactory);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Joining Spring transaction, and starting a new compass transaction on thread [" + Thread.currentThread().getName() + "]"));
            }
            sync = new SpringTransactionSynchronization(session, false, commitBeforeCompletion, this.transactionFactory);
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)sync);
        this.setBegun(true);
    }

    public void join(InternalCompassSession session) throws CompassException {
        this.session = session;
        this.controllingNewTransaction = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Joining an existing compass transcation on thread [" + Thread.currentThread().getName() + "]"));
        }
    }

    protected void doCommit() throws CompassException {
        if (!this.controllingNewTransaction) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Not committing transaction since compass does not control it on thread [" + Thread.currentThread().getName() + "]"));
            }
            return;
        }
        if (this.transactionManager == null) {
            return;
        }
        if (this.status.isNewTransaction()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Committing Spring transaction controlled by compass on thread [" + Thread.currentThread().getName() + "]"));
            }
            try {
                this.transactionManager.commit(this.status);
            }
            catch (Exception e) {
                this.commitFailed = true;
                throw new TransactionException("Commit failed", e);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Commit called, let Spring synchronization commit the transaciton on thread [" + Thread.currentThread().getName() + "]"));
        }
    }

    protected void doRollback() throws CompassException {
        if (this.transactionManager == null) {
            return;
        }
        try {
            if (this.status.isNewTransaction()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Rolling back Spring transaction controlled by compass on thread [" + Thread.currentThread().getName() + "]"));
                }
                if (!this.commitFailed) {
                    this.transactionManager.rollback(this.status);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Marking Spring transaction as rolled back since compass controlls it on thread [" + Thread.currentThread().getName() + "]"));
                }
                this.status.setRollbackOnly();
            }
        }
        catch (Exception e) {
            throw new TransactionException("Rollback failed with exception", e);
        }
    }

    public boolean wasRolledBack() throws CompassException {
        throw new TransactionException("Not supported");
    }

    public boolean wasCommitted() throws CompassException {
        throw new TransactionException("Not supported");
    }

    public CompassSession getSession() {
        return this.session;
    }

    public static class SpringTransactionSynchronization
    implements TransactionSynchronization {
        private InternalCompassSession session;
        private boolean compassControledTransaction;
        private boolean commitBeforeCompletion;
        private TransactionFactory transactionFactory;

        public SpringTransactionSynchronization(InternalCompassSession session, boolean compassControledTransaction, boolean commitBeforeCompletion, TransactionFactory transactionFactory) {
            this.session = session;
            this.compassControledTransaction = compassControledTransaction;
            this.commitBeforeCompletion = commitBeforeCompletion;
            this.transactionFactory = transactionFactory;
        }

        public InternalCompassSession getSession() {
            return this.session;
        }

        public void suspend() {
        }

        public void resume() {
        }

        public void beforeCommit(boolean readOnly) {
        }

        public void beforeCompletion() {
            if (!this.commitBeforeCompletion) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Committing compass transaction using Spring synchronization beforeCompletion on thread [" + Thread.currentThread().getName() + "]"));
            }
            this.session.getSearchEngine().commit(true);
        }

        public void afterCommit() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            try {
                if (status == 0) {
                    if (!this.commitBeforeCompletion) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Committing compass transaction using Spring synchronization afterCompletion on thread [" + Thread.currentThread().getName() + "]"));
                        }
                        this.session.getSearchEngine().commit(true);
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Rolling back compass transaction using Spring synchronization afterCompletion on thread [" + Thread.currentThread().getName() + "]"));
                    }
                    this.session.getSearchEngine().rollback();
                }
            }
            catch (Exception e) {
                log.error((Object)"Exception occured when sync with transaction", (Throwable)e);
            }
            finally {
                ((SpringSyncTransactionFactory)this.transactionFactory).unbindSessionFromTransaction(this);
                this.session.evictAll();
                if (!this.compassControledTransaction) {
                    this.session.close();
                }
            }
        }
    }
}

