/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations.client;

import com.hazelcast.client.RetryableRequest;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionRecord;
import com.hazelcast.collection.operations.CollectionResponse;
import com.hazelcast.collection.operations.GetAllOperation;
import com.hazelcast.collection.operations.client.CollectionKeyBasedRequest;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.PortableCollection;
import java.util.ArrayList;
import java.util.Collection;

public class GetAllRequest
extends CollectionKeyBasedRequest
implements RetryableRequest {
    public GetAllRequest() {
    }

    public GetAllRequest(CollectionProxyId proxyId, Data key) {
        super(proxyId, key);
    }

    @Override
    protected Operation prepareOperation() {
        return new GetAllOperation(this.proxyId, this.key);
    }

    @Override
    public int getClassId() {
        return 9;
    }

    @Override
    protected Object filter(Object response) {
        if (response instanceof CollectionResponse) {
            Collection coll = ((CollectionResponse)response).getCollection();
            if (coll == null) {
                return new PortableCollection();
            }
            ArrayList<Data> collection = new ArrayList<Data>(coll.size());
            for (CollectionRecord record : coll) {
                collection.add(this.getClientEngine().toData(record.getObject()));
            }
            return new PortableCollection(collection);
        }
        return super.filter(response);
    }
}

