/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.job;

import java.io.File;
import java.util.Map;
import org.apache.airavata.gfac.core.JobManagerConfiguration;
import org.apache.airavata.gfac.core.cluster.OutputParser;
import org.apache.airavata.gfac.core.cluster.RawCommandInfo;
import org.apache.airavata.model.appcatalog.computeresource.JobManagerCommand;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LSFJobConfiguration
implements JobManagerConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(LSFJobConfiguration.class);
    private final Map<JobManagerCommand, String> jobMangerCommands;
    private String jobDescriptionTemplateName;
    private String scriptExtension;
    private String installedPath;
    private OutputParser parser;

    public LSFJobConfiguration(String jobDescriptionTemplateName, String scriptExtension, String installedPath, Map<JobManagerCommand, String> jobManagerCommands, OutputParser parser) {
        this.jobDescriptionTemplateName = jobDescriptionTemplateName;
        this.scriptExtension = scriptExtension;
        this.parser = parser;
        this.installedPath = installedPath.endsWith("/") || installedPath.isEmpty() ? installedPath : installedPath + "/";
        this.jobMangerCommands = jobManagerCommands;
    }

    public RawCommandInfo getCancelCommand(String jobID) {
        return new RawCommandInfo(this.installedPath + "bkill " + jobID);
    }

    public String getJobDescriptionTemplateName() {
        return this.jobDescriptionTemplateName;
    }

    public RawCommandInfo getMonitorCommand(String jobID) {
        return new RawCommandInfo(this.installedPath + "bjobs " + jobID);
    }

    public RawCommandInfo getUserBasedMonitorCommand(String userName) {
        return new RawCommandInfo(this.installedPath + "bjobs -u " + userName);
    }

    public RawCommandInfo getJobIdMonitorCommand(String jobName, String userName) {
        return new RawCommandInfo(this.installedPath + "bjobs -J " + jobName);
    }

    public String getScriptExtension() {
        return this.scriptExtension;
    }

    public RawCommandInfo getSubmitCommand(String workingDirectory, String pbsFilePath) {
        return new RawCommandInfo(this.installedPath + "bsub < " + workingDirectory + File.separator + FilenameUtils.getName((String)pbsFilePath));
    }

    public OutputParser getParser() {
        return this.parser;
    }

    public void setParser(OutputParser parser) {
        this.parser = parser;
    }

    public String getInstalledPath() {
        return this.installedPath;
    }

    public String getBaseCancelCommand() {
        return "bkill";
    }

    public String getBaseMonitorCommand() {
        return "bjobs";
    }

    public String getBaseSubmitCommand() {
        return "bsub";
    }
}

