/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi;

import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import org.globus.gsi.gssapi.GlobusGSSName;
import org.globus.gsi.gssapi.jaas.GlobusPrincipal;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;

public class JaasGssUtil {
    public static Subject createSubject(GSSCredential cred) throws GSSException {
        return JaasGssUtil.createSubject(null, cred);
    }

    public static Subject createSubject(GSSName name, GSSCredential cred) throws GSSException {
        GlobusPrincipal nm;
        if (cred == null && name == null) {
            return null;
        }
        Subject subject = new Subject();
        if (cred != null) {
            subject.getPrivateCredentials().add(cred);
            if (name == null) {
                nm = JaasGssUtil.toGlobusPrincipal(cred.getName());
                subject.getPrincipals().add((Principal)nm);
            }
        }
        if (name != null) {
            nm = JaasGssUtil.toGlobusPrincipal(name);
            subject.getPrincipals().add((Principal)nm);
        }
        return subject;
    }

    public static GlobusPrincipal toGlobusPrincipal(GSSName name) {
        return !name.isAnonymous() && name instanceof GlobusGSSName ? new GlobusPrincipal(name.toString()) : null;
    }

    public static GSSCredential getCredential(Subject subject) {
        if (subject == null) {
            return null;
        }
        Set<GSSCredential> gssCreds = subject.getPrivateCredentials(GSSCredential.class);
        if (gssCreds == null) {
            return null;
        }
        Iterator<GSSCredential> iter = gssCreds.iterator();
        return iter.hasNext() ? iter.next() : null;
    }
}

