/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.document.internal;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.document.DeleteItemOutcome;
import com.amazonaws.services.dynamodbv2.document.Expected;
import com.amazonaws.services.dynamodbv2.document.KeyAttribute;
import com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.api.DeleteItemApi;
import com.amazonaws.services.dynamodbv2.document.internal.AbstractImpl;
import com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import com.amazonaws.services.dynamodbv2.document.spec.DeleteItemSpec;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import java.util.Collection;
import java.util.Map;

public class DeleteItemImpl
extends AbstractImpl
implements DeleteItemApi {
    public DeleteItemImpl(AmazonDynamoDB client, Table table) {
        super(client, table);
    }

    @Override
    public DeleteItemOutcome deleteItem(KeyAttribute ... primaryKeyComponents) {
        return this.doDeleteItem(new DeleteItemSpec().withPrimaryKey(primaryKeyComponents));
    }

    @Override
    public DeleteItemOutcome deleteItem(PrimaryKey primaryKey) {
        return this.doDeleteItem(new DeleteItemSpec().withPrimaryKey(primaryKey));
    }

    @Override
    public DeleteItemOutcome deleteItem(PrimaryKey primaryKeys, Expected ... expected) {
        return this.doDeleteItem(new DeleteItemSpec().withPrimaryKey(primaryKeys).withExpected(expected));
    }

    @Override
    public DeleteItemOutcome deleteItem(PrimaryKey primaryKeys, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.doDeleteItem(new DeleteItemSpec().withPrimaryKey(primaryKeys).withConditionExpression(conditionExpression).withNameMap(nameMap).withValueMap(valueMap));
    }

    @Override
    public DeleteItemOutcome deleteItem(DeleteItemSpec spec) {
        return this.doDeleteItem(spec);
    }

    private DeleteItemOutcome doDeleteItem(DeleteItemSpec spec) {
        String tableName = this.getTable().getTableName();
        DeleteItemRequest req = ((DeleteItemRequest)spec.getRequest()).withTableName(tableName).withKey(InternalUtils.toAttributeValueMap(spec.getKeyComponents()));
        Collection<Expected> expected = spec.getExpected();
        Map<String, ExpectedAttributeValue> expectedMap = InternalUtils.toExpectedAttributeValueMap(expected);
        Map<String, AttributeValue> attrValMap = InternalUtils.fromSimpleMap(spec.getValueMap());
        req.withConditionalOperator(spec.getConditionalOperator()).withConditionExpression(spec.getConditionExpression()).withExpected(expectedMap).withExpressionAttributeNames(spec.getNameMap()).withExpressionAttributeValues(attrValMap);
        DeleteItemResult result = this.getClient().deleteItem(req);
        return new DeleteItemOutcome(result);
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue) {
        return this.deleteItem(new PrimaryKey(hashKeyName, hashKeyValue));
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue) {
        return this.deleteItem(new PrimaryKey(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue));
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue, Expected ... expected) {
        return this.deleteItem(new PrimaryKey(hashKeyName, hashKeyValue), expected);
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, Expected ... expected) {
        return this.deleteItem(new PrimaryKey(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue), expected);
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.deleteItem(new PrimaryKey(hashKeyName, hashKeyValue), conditionExpression, nameMap, valueMap);
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.deleteItem(new PrimaryKey(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue), conditionExpression, nameMap, valueMap);
    }
}

