/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.document.spec;

import com.amazonaws.event.ProgressListener;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.dynamodbv2.document.Expected;
import com.amazonaws.services.dynamodbv2.document.KeyAttribute;
import com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import com.amazonaws.services.dynamodbv2.document.spec.AbstractSpecWithPrimaryKey;
import com.amazonaws.services.dynamodbv2.model.ConditionalOperator;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.ReturnItemCollectionMetrics;
import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class DeleteItemSpec
extends AbstractSpecWithPrimaryKey<DeleteItemRequest> {
    private Collection<Expected> expected;
    private String conditionExpression;
    private Map<String, String> nameMap;
    private Map<String, Object> valueMap;

    public DeleteItemSpec() {
        super(new DeleteItemRequest());
    }

    public DeleteItemSpec withPrimaryKey(KeyAttribute ... components) {
        super.withPrimaryKey(components);
        return this;
    }

    public DeleteItemSpec withPrimaryKey(PrimaryKey primaryKey) {
        super.withPrimaryKey(primaryKey);
        return this;
    }

    public DeleteItemSpec withPrimaryKey(String hashKeyName, Object hashKeyValue) {
        super.withPrimaryKey(hashKeyName, hashKeyValue);
        return this;
    }

    public DeleteItemSpec withPrimaryKey(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue) {
        super.withPrimaryKey(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue);
        return this;
    }

    public Collection<Expected> getExpected() {
        return this.expected;
    }

    public DeleteItemSpec withExpected(Expected ... expected) {
        if (expected == null) {
            this.expected = null;
            return this;
        }
        return this.withExpected(Arrays.asList(expected));
    }

    public DeleteItemSpec withExpected(Collection<Expected> expected) {
        if (expected == null) {
            this.expected = null;
            return this;
        }
        HashSet<String> names = new HashSet<String>();
        for (Expected e : expected) {
            names.add(e.getAttribute());
        }
        if (names.size() != expected.size()) {
            throw new IllegalArgumentException("attribute names must not duplicate in the list of expected");
        }
        this.expected = Collections.unmodifiableCollection(expected);
        return this;
    }

    public String getConditionExpression() {
        return this.conditionExpression;
    }

    public DeleteItemSpec withConditionExpression(String conditionExpression) {
        this.conditionExpression = conditionExpression;
        return this;
    }

    public Map<String, String> getNameMap() {
        return this.nameMap;
    }

    public DeleteItemSpec withNameMap(Map<String, String> nameMap) {
        this.nameMap = nameMap == null ? null : Collections.unmodifiableMap(new HashMap<String, String>(nameMap));
        return this;
    }

    public Map<String, Object> getValueMap() {
        return this.valueMap;
    }

    public DeleteItemSpec withValueMap(Map<String, Object> valueMap) {
        this.valueMap = valueMap == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(valueMap));
        return this;
    }

    public String getConditionalOperator() {
        return ((DeleteItemRequest)this.getRequest()).getConditionalOperator();
    }

    public DeleteItemSpec withConditionalOperator(ConditionalOperator conditionalOperator) {
        ((DeleteItemRequest)this.getRequest()).setConditionalOperator(conditionalOperator);
        return this;
    }

    public String getReturnConsumedCapacity() {
        return ((DeleteItemRequest)this.getRequest()).getReturnConsumedCapacity();
    }

    public DeleteItemSpec withReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        ((DeleteItemRequest)this.getRequest()).setReturnConsumedCapacity(returnConsumedCapacity);
        return this;
    }

    public String getReturnItemCollectionMetrics() {
        return ((DeleteItemRequest)this.getRequest()).getReturnItemCollectionMetrics();
    }

    public DeleteItemSpec withReturnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
        ((DeleteItemRequest)this.getRequest()).setReturnItemCollectionMetrics(returnItemCollectionMetrics);
        return this;
    }

    public String getReturnValues() {
        return ((DeleteItemRequest)this.getRequest()).getReturnValues();
    }

    public DeleteItemSpec withReturnValues(ReturnValue returnValues) {
        ((DeleteItemRequest)this.getRequest()).setReturnValues(returnValues);
        return this;
    }

    @Override
    public DeleteItemSpec withProgressListener(ProgressListener progressListener) {
        this.setProgressListener(progressListener);
        return this;
    }

    @Override
    public DeleteItemSpec withRequestMetricCollector(RequestMetricCollector requestMetricCollector) {
        this.setRequestMetricCollector(requestMetricCollector);
        return this;
    }
}

