/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.common.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ApplicationSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSettings
extends ApplicationSettings {
    private static final Logger log = LoggerFactory.getLogger(ServerSettings.class);
    private static final String DEFAULT_USER = "default.registry.user";
    private static final String DEFAULT_USER_PASSWORD = "default.registry.password";
    private static final String DEFAULT_USER_GATEWAY = "default.registry.gateway";
    private static final String ENABLE_SHARING = "enable.sharing";
    public static final String IP = "ip";
    private static final String API_SERVER_TLS_ENABLED = "apiserver.tls.enabled";
    private static final String API_SERVER_KEYSTORE = "apiserver.keystore";
    private static final String API_SERVER_KEYSTORE_PASSWD = "apiserver.keystore.password";
    public static final String ORCHESTRATOR_SERVER_HOST = "orchestrator.server.host";
    public static final String ORCHESTRATOR_SERVER_PORT = "orchestrator.server.port";
    public static final String ORCHESTRATOR_SERVER_NAME = "orchestrator.server.name";
    public static final String GFAC_SERVER_HOST = "gfac.server.host";
    public static final String GFAC_SERVER_PORT = "gfac.server.port";
    public static final String GFAC_SERVER_NAME = "gfac.server.name";
    public static final String GFAC_THREAD_POOL_SIZE = "gfac.thread.pool.size";
    public static final int DEFAULT_GFAC_THREAD_POOL_SIZE = 50;
    public static final String GFAC_CONFIG_XML = "gfac-config.xml";
    public static final String CREDENTIAL_SERVER_HOST = "credential.store.server.host";
    public static final String CREDENTIAL_SERVER_PORT = "credential.store.server.port";
    public static final String EMBEDDED_ZK = "embedded.zk";
    public static final String ZOOKEEPER_SERVER_CONNECTION = "zookeeper.server.connection";
    public static final String ZOOKEEPER_TIMEOUT = "zookeeper.timeout";
    public static final String AURORA_SCHEDULER_HOSTS = "aurora.scheduler.hosts";
    public static final String AURORA_EXECUTOR_NAME = "aurora.executor.name";
    public static final String MESOS_CLUSTER_NAME = "mesos.cluster.name";
    public static final String AURORA_SCHEDULER_CONNECT_TIMEOUT_MS = "aurora.scheduler.timeoutms";
    public static final String AURORA_EXECUTOR_CONFIG_TEMPLATE_FILE = "aurora.executor.config.template.filename";
    private static final String CREDENTIAL_STORE_DB_URL = "credential.store.jdbc.url";
    private static final String CREDENTIAL_STORE_DB_USER = "credential.store.jdbc.user";
    private static final String CREDENTIAL_STORE_DB_PASSWORD = "credential.store.jdbc.password";
    private static final String CREDENTIAL_STORE_DB_DRIVER = "credential.store.jdbc.driver";
    private static final String SHARING_REGISTRY_PORT = "sharing.registry.server.port";
    private static final String SHARING_REGISTRY_HOST = "sharing.registry.server.host";
    private static String USER_PROFILE_MONGODB_PORT = "userprofile.mongodb.port";
    private static final String REGISTRY_DB_URL = "registry.jdbc.url";
    private static final String REGISTRY_DB_USER = "registry.jdbc.user";
    private static final String REGISTRY_DB_PASSWORD = "registry.jdbc.password";
    private static final String REGISTRY_DB_DRIVER = "registry.jdbc.driver";
    private static final String HOST_SCHEDULER = "host.scheduler";
    private static final String MY_PROXY_SERVER = "myproxy.server";
    private static final String MY_PROXY_USER = "myproxy.user";
    private static final String MY_PROXY_PASSWORD = "myproxy.password";
    private static final String MY_PROXY_LIFETIME = "myproxy.life";
    public static final String JOB_NOTIFICATION_ENABLE = "job.notification.enable";
    public static final String JOB_NOTIFICATION_EMAILIDS = "job.notification.emailids";
    public static final String JOB_NOTIFICATION_FLAGS = "job.notification.flags";
    public static final String RABBITMQ_BROKER_URL = "rabbitmq.broker.url";
    public static final String RABBITMQ_STATUS_EXCHANGE_NAME = "rabbitmq.status.exchange.name";
    public static final String RABBITMQ_PROCESS_EXCHANGE_NAME = "rabbitmq.process.exchange.name";
    public static final String RABBITMQ_EXPERIMENT_EXCHANGE_NAME = "rabbitmq.experiment.exchange.name";
    public static final String RABBITMQ_PROCESS_LAUNCH_QUEUE_NAME = "process.launch.queue.name";
    public static final String RABBITMQ_EXPERIMENT_LAUNCH_QUEUE_NAME = "experiment.launch.queue.name";
    public static final String RABBITMQ_DURABLE_QUEUE = "durable.queue";
    public static final String RABBITMQ_PREFETCH_COUNT = "prefetch.count";
    private static final String ENACTMENT_THREAD_POOL_SIZE = "enactment.thread.pool.size";
    private static final int DEFAULT_ENACTMENT_THREAD_POOL_SIZE = 10;
    private static final String WORKFLOW_PARSER = "workflow.parser";
    private static final String EMAIL_BASED_MONITORING_PERIOD = "email.based.monitoring.period";
    private static final String EMAIL_BASED_MONITOR_HOST = "email.based.monitor.host";
    private static final String EMAIL_BASED_MONITOR_ADDRESS = "email.based.monitor.address";
    private static final String EMAIL_BASED_MONITOR_PASSWORD = "email.based.monitor.password";
    private static final String EMAIL_BASED_MONITOR_FOLDER_NAME = "email.based.monitor.folder.name";
    private static final String EMAIL_BASED_MONITOR_STORE_PROTOCOL = "email.based.monitor.store.protocol";
    private static final String ENABLE_EMAIL_BASED_MONITORING = "enable.email.based.monitoring";
    private static final String IS_RUNNING_ON_AWS = "isRunningOnAws";
    private static final String ENABLE_KAFKA_LOGGING = "enable.kafka.logging";
    private static final String KAFKA_BROKER_LIST = "kafka.broker.list";
    private static final String KAFKA_TOPIC_PREFIX = "kafka.topic.prefix";
    private static final String SERVER_ROLES = "server.roles";
    public static final String USER_PROFILE_SERVER_HOST = "user.profile.server.host";
    public static final String USER_PROFILE_SERVER_PORT = "user.profile.server.port";
    public static final String PROFILE_SERVICE_SERVER_HOST = "profile.service.server.host";
    public static final String PROFILE_SERVICE_SERVER_PORT = "profile.service.server.port";
    public static final String IAM_SERVER_URL = "iam.server.url";
    public static final String IAM_SERVER_SUPER_ADMIN_USERNAME = "iam.server.super.admin.username";
    public static final String IAM_SERVER_SUPER_ADMIN_PASSWORD = "iam.server.super.admin.password";
    private static final String SESSION_CACHE_ACCESS_TIME_OUT = "ssh.session.cache.access.timeout";
    private static Map<String, String[]> listConfigurations = new HashMap<String, String[]>();
    private static boolean stopAllThreads = false;
    private static boolean emailBaseNotificationEnable;
    private static String outputLocation;

    public static String getDefaultUser() throws ApplicationSettingsException {
        return ServerSettings.getSetting(DEFAULT_USER);
    }

    public static String getRabbitmqProcessLaunchQueueName() {
        return ServerSettings.getSetting(RABBITMQ_PROCESS_LAUNCH_QUEUE_NAME, "process.launch.queue");
    }

    public static String getRabbitmqExperimentLaunchQueueName() {
        return ServerSettings.getSetting(RABBITMQ_EXPERIMENT_EXCHANGE_NAME, "experiment.launch.queue");
    }

    public static String getRabbitmqBrokerUrl() {
        return ServerSettings.getSetting(RABBITMQ_BROKER_URL, "amqp://localhost:5672");
    }

    public static String getRabbitmqStatusExchangeName() {
        return ServerSettings.getSetting(RABBITMQ_STATUS_EXCHANGE_NAME, "status_exchange");
    }

    public static String getRabbitmqProcessExchangeName() {
        return ServerSettings.getSetting(RABBITMQ_PROCESS_EXCHANGE_NAME, "process_exchange");
    }

    public static String getRabbitmqExperimentExchangeName() {
        return ServerSettings.getSetting(RABBITMQ_EXPERIMENT_EXCHANGE_NAME, "experiment_exchange");
    }

    public static boolean getRabbitmqDurableQueue() {
        return Boolean.valueOf(ServerSettings.getSetting(RABBITMQ_DURABLE_QUEUE, "false"));
    }

    public static int getRabbitmqPrefetchCount() {
        return Integer.valueOf(ServerSettings.getSetting(RABBITMQ_PREFETCH_COUNT, "200"));
    }

    public static String getDefaultUserPassword() throws ApplicationSettingsException {
        return ServerSettings.getSetting(DEFAULT_USER_PASSWORD);
    }

    public static String getDefaultUserGateway() throws ApplicationSettingsException {
        return ServerSettings.getSetting(DEFAULT_USER_GATEWAY);
    }

    public static String getCredentialStoreDBUser() throws ApplicationSettingsException {
        try {
            return ServerSettings.getSetting(CREDENTIAL_STORE_DB_USER);
        }
        catch (ApplicationSettingsException e) {
            return ServerSettings.getSetting(REGISTRY_DB_USER);
        }
    }

    public static String getCredentialStoreDBPassword() throws ApplicationSettingsException {
        try {
            return ServerSettings.getSetting(CREDENTIAL_STORE_DB_PASSWORD);
        }
        catch (ApplicationSettingsException e) {
            return ServerSettings.getSetting(REGISTRY_DB_PASSWORD);
        }
    }

    public static String getCredentialStoreDBDriver() throws ApplicationSettingsException {
        try {
            return ServerSettings.getSetting(CREDENTIAL_STORE_DB_DRIVER);
        }
        catch (ApplicationSettingsException e) {
            return ServerSettings.getSetting(REGISTRY_DB_DRIVER);
        }
    }

    public static String getCredentialStoreDBURL() throws ApplicationSettingsException {
        try {
            return ServerSettings.getSetting(CREDENTIAL_STORE_DB_URL);
        }
        catch (ApplicationSettingsException e) {
            return ServerSettings.getSetting(REGISTRY_DB_URL);
        }
    }

    public static boolean isAPIServerTLSEnabled() {
        try {
            return Boolean.parseBoolean(ServerSettings.getSetting(API_SERVER_TLS_ENABLED));
        }
        catch (ApplicationSettingsException e) {
            return false;
        }
    }

    public static String getApiServerKeystorePasswd() throws ApplicationSettingsException {
        return ServerSettings.getSetting(API_SERVER_KEYSTORE_PASSWD);
    }

    public static String getApiServerKeystore() throws ApplicationSettingsException {
        return ServerSettings.getSetting(API_SERVER_KEYSTORE);
    }

    public static String getHostScheduler() throws ApplicationSettingsException {
        return ServerSettings.getSetting(HOST_SCHEDULER);
    }

    public static boolean isStopAllThreads() {
        return stopAllThreads;
    }

    public static void setStopAllThreads(boolean stopAllThreads) {
        ServerSettings.stopAllThreads = stopAllThreads;
    }

    public static String getMyProxyServer() throws ApplicationSettingsException {
        return ServerSettings.getSetting(MY_PROXY_SERVER);
    }

    public static String getMyProxyUser() throws ApplicationSettingsException {
        return ServerSettings.getSetting(MY_PROXY_USER);
    }

    public static String getMyProxyPassword() throws ApplicationSettingsException {
        return ServerSettings.getSetting(MY_PROXY_PASSWORD);
    }

    public static int getMyProxyLifetime() throws ApplicationSettingsException {
        return Integer.parseInt(ServerSettings.getSetting(MY_PROXY_LIFETIME));
    }

    public static boolean isEmbeddedZK() {
        return Boolean.parseBoolean(ServerSettings.getSetting(EMBEDDED_ZK, "true"));
    }

    public static String getIp() {
        try {
            return ServerSettings.getSetting(IP);
        }
        catch (ApplicationSettingsException e) {
            try {
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e1) {
                e1.printStackTrace();
                return null;
            }
        }
    }

    public static int getEnactmentThreadPoolSize() {
        String threadPoolSize = null;
        try {
            threadPoolSize = ServerSettings.getSetting(ENACTMENT_THREAD_POOL_SIZE);
        }
        catch (ApplicationSettingsException e) {
            return 10;
        }
        return Integer.valueOf(threadPoolSize);
    }

    public static String getWorkflowParser() throws ApplicationSettingsException {
        return ServerSettings.getSetting(WORKFLOW_PARSER);
    }

    public static int getEmailMonitorPeriod() throws ApplicationSettingsException {
        return Integer.valueOf(ServerSettings.getSetting(EMAIL_BASED_MONITORING_PERIOD, "100000"));
    }

    public static String getEmailBasedMonitorHost() throws ApplicationSettingsException {
        return ServerSettings.getSetting(EMAIL_BASED_MONITOR_HOST);
    }

    public static String getEmailBasedMonitorAddress() throws ApplicationSettingsException {
        return ServerSettings.getSetting(EMAIL_BASED_MONITOR_ADDRESS);
    }

    public static String getEmailBasedMonitorPassword() throws ApplicationSettingsException {
        return ServerSettings.getSetting(EMAIL_BASED_MONITOR_PASSWORD);
    }

    public static String getEmailBasedMonitorFolderName() throws ApplicationSettingsException {
        return ServerSettings.getSetting(EMAIL_BASED_MONITOR_FOLDER_NAME);
    }

    public static String getEmailBasedMonitorStoreProtocol() throws ApplicationSettingsException {
        return ServerSettings.getSetting(EMAIL_BASED_MONITOR_STORE_PROTOCOL);
    }

    public static boolean isEmailBasedNotificationEnable() {
        return Boolean.valueOf(ServerSettings.getSetting(ENABLE_EMAIL_BASED_MONITORING, "false"));
    }

    public static boolean isAPISecured() throws ApplicationSettingsException {
        return Boolean.valueOf(ServerSettings.getSetting("api.secured"));
    }

    public static String getRemoteAuthzServerUrl() throws ApplicationSettingsException {
        return ServerSettings.getSetting("remote.oauth.authorization.server");
    }

    public static String getRemoteIDPServiceUrl() throws ApplicationSettingsException {
        return ServerSettings.getSetting(IAM_SERVER_URL);
    }

    public static String getIamServerSuperAdminUsername() throws ApplicationSettingsException {
        return ServerSettings.getSetting(IAM_SERVER_SUPER_ADMIN_USERNAME);
    }

    public static String getIamServerSuperAdminPassword() throws ApplicationSettingsException {
        return ServerSettings.getSetting(IAM_SERVER_SUPER_ADMIN_PASSWORD);
    }

    public static String getAuthorizationPoliyName() throws ApplicationSettingsException {
        return ServerSettings.getSetting("authorization.policy");
    }

    public static String getZookeeperConnection() throws ApplicationSettingsException {
        return ServerSettings.getSetting(ZOOKEEPER_SERVER_CONNECTION, "localhost:2181");
    }

    public static int getZookeeperTimeout() {
        return Integer.valueOf(ServerSettings.getSetting(ZOOKEEPER_TIMEOUT, "3000"));
    }

    public static String getGFacServerName() throws ApplicationSettingsException {
        return ServerSettings.getSetting(GFAC_SERVER_NAME);
    }

    public static String getGfacServerHost() throws ApplicationSettingsException {
        return ServerSettings.getSetting(GFAC_SERVER_HOST);
    }

    public static String getGFacServerPort() throws ApplicationSettingsException {
        return ServerSettings.getSetting(GFAC_SERVER_PORT);
    }

    public static int getGFacThreadPoolSize() {
        try {
            String threadPoolSize = ServerSettings.getSetting(GFAC_THREAD_POOL_SIZE);
            if (threadPoolSize != null && !threadPoolSize.isEmpty()) {
                return Integer.valueOf(threadPoolSize);
            }
            log.warn("Thread pool size is not configured, use default gfac thread pool size 50");
        }
        catch (ApplicationSettingsException e) {
            log.warn("Couldn't read thread pool size from configuration on exception, use default gfac thread pool size 50");
        }
        return 50;
    }

    public static String getOrchestratorServerName() throws ApplicationSettingsException {
        return ServerSettings.getSetting(ORCHESTRATOR_SERVER_NAME);
    }

    public static String getOrchestratorServerHost() throws ApplicationSettingsException {
        return ServerSettings.getSetting(ORCHESTRATOR_SERVER_HOST);
    }

    public static int getOrchestratorServerPort() throws ApplicationSettingsException {
        return Integer.valueOf(ServerSettings.getSetting(ORCHESTRATOR_SERVER_PORT));
    }

    public static boolean isTLSEnabled() throws ApplicationSettingsException {
        return Boolean.valueOf(ServerSettings.getSetting("TLS.enabled"));
    }

    public static int getTLSServerPort() throws ApplicationSettingsException {
        return Integer.valueOf(ServerSettings.getSetting("TLS.api.server.port"));
    }

    public static String getKeyStorePath() throws ApplicationSettingsException {
        return ServerSettings.getSetting("keystore.path");
    }

    public static String getKeyStorePassword() throws ApplicationSettingsException {
        return ServerSettings.getSetting("keystore.password");
    }

    public static int getTLSClientTimeout() throws ApplicationSettingsException {
        return Integer.valueOf(ServerSettings.getSetting("TLS.client.timeout"));
    }

    public static String getSecurityManagerClassName() throws ApplicationSettingsException {
        return ServerSettings.getSetting("security.manager.class");
    }

    public static String getAuthzCacheManagerClassName() throws ApplicationSettingsException {
        return ServerSettings.getSetting("authz.cache.manager.class");
    }

    public static boolean isAuthzCacheEnabled() throws ApplicationSettingsException {
        return Boolean.valueOf(ServerSettings.getSetting("authz.cache.enabled"));
    }

    public static int getCacheSize() throws ApplicationSettingsException {
        return Integer.valueOf(ServerSettings.getSetting("in.memory.cache.size"));
    }

    public static String getLocalDataLocation() {
        return System.getProperty("java.io.tmpdir");
    }

    public static Boolean isEnableSharing() throws ApplicationSettingsException {
        return Boolean.parseBoolean(ServerSettings.getSetting(ENABLE_SHARING));
    }

    public static boolean isRunningOnAws() {
        return Boolean.valueOf(ServerSettings.getSetting(IS_RUNNING_ON_AWS, "false"));
    }

    public static String getKafkaBrokerList() {
        return ServerSettings.getSetting(KAFKA_BROKER_LIST, null);
    }

    public static String getKafkaTopicPrefix() {
        return ServerSettings.getSetting(KAFKA_TOPIC_PREFIX, "all");
    }

    public static boolean isEnabledKafkaLogging() {
        return Boolean.valueOf(ServerSettings.getSetting(ENABLE_KAFKA_LOGGING, "false"));
    }

    public static void setServerRoles(String[] roles) {
        listConfigurations.put(SERVER_ROLES, roles);
    }

    public static String[] getServerRoles() {
        return listConfigurations.get(SERVER_ROLES);
    }

    public static String getAuroraSchedulerHosts() throws ApplicationSettingsException {
        return ServerSettings.getSetting(AURORA_SCHEDULER_HOSTS);
    }

    public static String getMesosClusterName() throws ApplicationSettingsException {
        return ServerSettings.getSetting(MESOS_CLUSTER_NAME);
    }

    public static String getAuroraExecutorName() throws ApplicationSettingsException {
        return ServerSettings.getSetting(AURORA_EXECUTOR_NAME);
    }

    public static String getAuroraExecutorConfigTemplateFileName() throws ApplicationSettingsException {
        return ServerSettings.getSetting(AURORA_EXECUTOR_CONFIG_TEMPLATE_FILE);
    }

    public static int getAuroraSchedulerTimeout() throws ApplicationSettingsException {
        return Integer.valueOf(ServerSettings.getSetting(AURORA_SCHEDULER_CONNECT_TIMEOUT_MS));
    }

    public static int getSessionCacheAccessTimeout() {
        return Integer.valueOf(ServerSettings.getSetting(SESSION_CACHE_ACCESS_TIME_OUT, "30"));
    }

    public static String getSharingRegistryPort() {
        return ServerSettings.getSetting(SHARING_REGISTRY_PORT, "7878");
    }

    public static String getSharingRegistryHost() {
        return ServerSettings.getSetting(SHARING_REGISTRY_HOST, "localhost");
    }
}

