/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util.executor;

import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class CompletedFuture<V>
implements Future<V> {
    private final SerializationService serializationService;
    private final Object value;

    public CompletedFuture(SerializationService serializationService, Object value) {
        this.serializationService = serializationService;
        this.value = value;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        Object object = this.value;
        if (object instanceof Data) {
            object = this.serializationService.toObject((Data)object);
        }
        if (object instanceof Throwable) {
            if (object instanceof ExecutionException) {
                throw (ExecutionException)object;
            }
            if (object instanceof InterruptedException) {
                throw (InterruptedException)object;
            }
            throw new ExecutionException((Throwable)object);
        }
        return (V)object;
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.get();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }
}

