/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.util.cli;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.util.cli.BasicSorter;
import edu.uiuc.ncsa.security.util.cli.CommonCommands;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import edu.uiuc.ncsa.security.util.cli.Sortable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class StoreCommands
extends CommonCommands {
    Sortable sortable = null;
    Store store;
    protected List<Identifiable> allEntries = null;

    public void setSortable(Sortable sortable) {
        this.sortable = sortable;
    }

    protected Sortable getSortable() {
        return this.sortable;
    }

    protected StoreCommands(String defaultIndent, Store store) {
        this.defaultIndent = defaultIndent;
        this.store = store;
        this.setSortable(new BasicSorter());
    }

    public StoreCommands(Store store) {
        this.setStore(store);
        this.setSortable(new BasicSorter());
    }

    public abstract String getName();

    @Override
    public String getPrompt() {
        return this.getName() + " >";
    }

    public Store getStore() {
        return this.store;
    }

    public void setStore(Store store) {
        this.store = store;
    }

    protected void showUpdateHelp() {
        this.say("Updates an entry, that is to say, allows you to edit the values stored for an entry");
        this.say("Syntax:\n");
        this.say("update index\n");
        this.say("where the index is the index in the list command.");
    }

    public void update(InputLine inputLine) {
        if (this.showHelp(inputLine)) {
            this.showUpdateHelp();
            return;
        }
        if (inputLine.size() == 1) {
            this.say("You must supply the index or id of the item to update");
            return;
        }
        Identifiable identifiable = this.findItem(inputLine);
        if (identifiable != null) {
            this.update(identifiable);
            this.getStore().save(identifiable);
            return;
        }
        this.say("no object with that index or id found. Please try again");
    }

    public abstract void update(Identifiable var1);

    public abstract void extraUpdates(Identifiable var1);

    protected abstract String format(Identifiable var1);

    protected abstract void longFormat(Identifiable var1);

    protected boolean hasEntries() {
        return this.allEntries == null || this.allEntries.isEmpty();
    }

    protected List<Identifiable> loadAllEntries() {
        Set keys = this.getStore().keySet();
        this.allEntries = new LinkedList<Identifiable>();
        boolean i = false;
        for (Object key : keys) {
            if (key == null) {
                System.out.println("Warning, skipping null identifier. Cannot resolve object...");
                continue;
            }
            Identifiable x = (Identifiable)this.getStore().get(key);
            this.allEntries.add(x);
        }
        return this.allEntries;
    }

    protected void clearEntries() {
        this.allEntries = new LinkedList<Identifiable>();
    }

    protected List<Identifiable> listAll(boolean useLongFormat, String otherFlags) {
        this.loadAllEntries();
        if (this.allEntries.isEmpty()) {
            this.say("(no entries found)");
            return this.allEntries;
        }
        int i = 0;
        this.getSortable().setState(otherFlags);
        this.allEntries = this.getSortable().sort(this.allEntries);
        for (Identifiable x : this.allEntries) {
            if (useLongFormat) {
                this.longFormat(x);
                continue;
            }
            this.say(i++ + ". " + this.format(x));
        }
        return this.allEntries;
    }

    protected void showCreateHelp() {
        this.say("Create a new entry in the currently active store.");
        this.say("Syntax is\n");
        this.say("create [/id]\n");
        this.say("where the id is a unique uri which will identify the object. If you do not specify an");
        this.say("identifier, you will be prompted for one. You may also elect to have a new, random one created and assigned.");
    }

    public void create(InputLine inputLine) {
        if (this.showHelp(inputLine)) {
            this.showCreateHelp();
            return;
        }
        Identifier id = null;
        if (1 == inputLine.size()) {
            this.create();
            this.clearEntries();
            return;
        }
        if (1 < inputLine.size()) {
            try {
                id = BasicIdentifier.newID((String)inputLine.getArg(1));
                if (this.getStore().containsKey((Object)id)) {
                    throw new IllegalArgumentException("Error: The identifier \"" + id + "\" already has an entry in this store.");
                }
            }
            catch (Throwable t) {
                this.say("Identifier is not a valid URI, request rejected");
                return;
            }
            Identifiable x = this.getStore().create();
            x.setIdentifier(id);
            this.getStore().save(x);
            this.say("Created object with id \"" + x.getIdentifier() + "\"");
            this.sayi2("edit [y/n]?");
            if (this.isOk(this.readline())) {
                this.update(x);
            }
            this.getStore().save(x);
            this.clearEntries();
        }
    }

    protected void create() {
        boolean tryAgain = true;
        Identifier id = null;
        Identifiable c = null;
        while (tryAgain) {
            this.sayi2("enter the id of the object you want to create or return for a random one >");
            String inLine = this.readline();
            if (!this.isEmpty(inLine)) {
                try {
                    id = BasicIdentifier.newID((String)inLine);
                    tryAgain = false;
                }
                catch (Throwable t) {
                    this.sayi2("That is not a valid uri. Try again (y/n)? ");
                    tryAgain = this.isOk(this.readline());
                }
                continue;
            }
            tryAgain = false;
        }
        c = this.getStore().create();
        if (id != null) {
            if (this.getStore().containsKey(id)) {
                throw new IllegalArgumentException("Error: the identifier \"" + id + "\" is already in use.");
            }
            c.setIdentifier(id);
        }
        this.getStore().save(c);
        this.sayi("Object created with identifier " + c.getIdentifierString());
        this.sayi2("edit [y/n]?");
        if (this.isOk(this.readline())) {
            this.update(c);
        }
        this.getStore().save(c);
        this.clearEntries();
    }

    protected void showRMHelp() {
        this.say("Remove an item from the store. ");
        this.say("Syntax:\n");
        this.say("rm [index|uid]\n");
        this.say("where index is the index number from the list (ls) command or the unique identifier for the item, preceeded");
        this.say("by a forward slash\n");
        this.say("Examples\n");
        this.say("rm 12\n");
        this.say("This removes item 12 on the list\n");
        this.say("rm /http://cilogon.org/serverT/uid/123\n");
        this.say("This removes the item with the given unique identifier from the current store, regardless of its position in the list command");
    }

    protected Identifiable findItem(InputLine inputLine) {
        if (inputLine.size() <= 1) {
            return null;
        }
        if (inputLine.getLastArg().startsWith("/")) {
            String arg = inputLine.getArg(1).substring(1);
            Identifier id = BasicIdentifier.newID((String)arg);
            return (Identifiable)this.getStore().get((Object)id);
        }
        int choice = inputLine.getIntArg(inputLine.size() - 1);
        if (this.allEntries == null || this.allEntries.isEmpty()) {
            this.loadAllEntries();
        }
        return this.allEntries.get(choice);
    }

    public void rm(InputLine inputLine) {
        if (this.showHelp(inputLine)) {
            this.showRMHelp();
            return;
        }
        Identifiable x = this.findItem(inputLine);
        this.getStore().remove((Object)x.getIdentifier());
        this.say("Done. object with id = " + x.getIdentifierString() + " has been removed from the store");
        this.clearEntries();
    }

    protected void showLSHelp() {
        this.say("lists the current store or lists details about an entry. Each entry is given a number of calls to other");
        this.say("tools will use the most numbers from the most recent call to this.");
        this.say("Synatx:\n");
        this.say("ls [number]\n");
        this.say("If no number is supplied, then a complete list of all elements with numbering will be displayed.");
        this.say("If a number has been supplied, a detailed report on that item is shown.");
    }

    public void ls(InputLine inputLine) {
        if (this.showHelp(inputLine)) {
            this.showLSHelp();
            return;
        }
        if (1 == inputLine.size()) {
            this.listAll(false, "");
            return;
        }
        if (!inputLine.getArg(inputLine.size() - 1).startsWith("-")) {
            Identifiable identifiable = this.findItem(inputLine);
            if (identifiable == null) {
                this.say("Sorry, object not found.");
                return;
            }
            this.longFormat(identifiable);
            return;
        }
        boolean longForm = false;
        if (inputLine.getArg(1).contains("l")) {
            longForm = true;
        }
        if (longForm) {
            this.listAll(true, inputLine.getArg(1));
        } else {
            this.listAll(false, inputLine.getArg(1));
        }
    }

    protected void showSizeHelp() {
        this.sayi("Prints out the number of elements in the current store.");
    }

    public void size(InputLine inputLine) {
        if (this.showHelp(inputLine)) {
            this.showSizeHelp();
            return;
        }
        this.sayi("Current store has " + this.getStore().size() + " entries");
    }
}

