/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import org.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jce.ECGOST3410NamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPointEncoder;
import org.bouncycastle.jce.provider.EC5Util;
import org.bouncycastle.jce.provider.ECUtil;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;

public class JCEECPublicKey
implements ECPublicKey,
org.bouncycastle.jce.interfaces.ECPublicKey,
ECPointEncoder {
    private String algorithm = "EC";
    private org.bouncycastle.math.ec.ECPoint q;
    private ECParameterSpec ecSpec;
    private boolean withCompression;
    private GOST3410PublicKeyAlgParameters gostParams;

    JCEECPublicKey(String string, ECPublicKeySpec eCPublicKeySpec) {
        this.algorithm = string;
        this.ecSpec = eCPublicKeySpec.getParams();
        ECField eCField = this.ecSpec.getCurve().getField();
        if (eCField instanceof ECFieldFp) {
            this.q = new ECPoint.Fp(new ECCurve.Fp(((ECFieldFp)eCField).getP(), this.ecSpec.getCurve().getA(), this.ecSpec.getCurve().getB()), new ECFieldElement.Fp(((ECFieldFp)eCField).getP(), eCPublicKeySpec.getW().getAffineX()), new ECFieldElement.Fp(((ECFieldFp)eCField).getP(), eCPublicKeySpec.getW().getAffineY()));
        } else {
            ECFieldF2m eCFieldF2m = (ECFieldF2m)eCField;
            int n = eCFieldF2m.getM();
            int[] nArray = ECUtil.convertMidTerms(eCFieldF2m.getMidTermsOfReductionPolynomial());
            this.q = new ECPoint.F2m(new ECCurve.F2m(n, nArray[0], nArray[1], nArray[2], this.ecSpec.getCurve().getA(), this.ecSpec.getCurve().getB()), new ECFieldElement.F2m(n, nArray[0], nArray[1], nArray[2], eCPublicKeySpec.getW().getAffineX()), new ECFieldElement.F2m(n, nArray[0], nArray[1], nArray[2], eCPublicKeySpec.getW().getAffineY()), false);
        }
    }

    JCEECPublicKey(String string, org.bouncycastle.jce.spec.ECPublicKeySpec eCPublicKeySpec) {
        this.algorithm = string;
        this.q = eCPublicKeySpec.getQ();
        ECCurve eCCurve = eCPublicKeySpec.getParams().getCurve();
        EllipticCurve ellipticCurve = EC5Util.convertCurve(eCCurve, eCPublicKeySpec.getParams().getSeed());
        this.ecSpec = EC5Util.convertSpec(ellipticCurve, eCPublicKeySpec.getParams());
    }

    JCEECPublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters, ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        this.algorithm = string;
        this.q = eCPublicKeyParameters.getQ();
        if (eCParameterSpec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCDomainParameters.getCurve(), eCDomainParameters.getSeed());
            this.ecSpec = this.createSpec(ellipticCurve, eCDomainParameters);
        } else {
            this.ecSpec = eCParameterSpec;
        }
    }

    JCEECPublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters, org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        this.algorithm = string;
        this.q = eCPublicKeyParameters.getQ();
        if (eCParameterSpec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCDomainParameters.getCurve(), eCParameterSpec.getSeed());
            this.ecSpec = this.createSpec(ellipticCurve, eCDomainParameters);
        } else {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCParameterSpec.getCurve(), eCParameterSpec.getSeed());
            this.ecSpec = EC5Util.convertSpec(ellipticCurve, eCParameterSpec);
        }
    }

    private ECParameterSpec createSpec(EllipticCurve ellipticCurve, ECDomainParameters eCDomainParameters) {
        return new ECParameterSpec(ellipticCurve, new ECPoint(eCDomainParameters.getG().getX().toBigInteger(), eCDomainParameters.getG().getY().toBigInteger()), eCDomainParameters.getN(), eCDomainParameters.getH().intValue());
    }

    JCEECPublicKey(String string, ECPublicKey eCPublicKey) {
        this.algorithm = eCPublicKey.getAlgorithm();
        this.ecSpec = eCPublicKey.getParams();
        ECField eCField = this.ecSpec.getCurve().getField();
        if (eCField instanceof ECFieldFp) {
            this.q = new ECPoint.Fp(new ECCurve.Fp(((ECFieldFp)eCField).getP(), this.ecSpec.getCurve().getA(), this.ecSpec.getCurve().getB()), new ECFieldElement.Fp(((ECFieldFp)this.ecSpec.getCurve().getField()).getP(), eCPublicKey.getW().getAffineX()), new ECFieldElement.Fp(((ECFieldFp)this.ecSpec.getCurve().getField()).getP(), eCPublicKey.getW().getAffineY()));
        } else {
            ECFieldF2m eCFieldF2m = (ECFieldF2m)eCField;
            int n = eCFieldF2m.getM();
            int[] nArray = ECUtil.convertMidTerms(eCFieldF2m.getMidTermsOfReductionPolynomial());
            this.q = new ECPoint.F2m(new ECCurve.F2m(n, nArray[0], nArray[1], nArray[0], this.ecSpec.getCurve().getA(), this.ecSpec.getCurve().getB()), new ECFieldElement.F2m(n, nArray[0], nArray[1], nArray[0], eCPublicKey.getW().getAffineX()), new ECFieldElement.F2m(n, nArray[0], nArray[1], nArray[0], eCPublicKey.getW().getAffineY()), false);
        }
    }

    JCEECPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        if (subjectPublicKeyInfo.getAlgorithmId().getObjectId().equals(CryptoProObjectIdentifiers.gostR3410_2001)) {
            int n;
            ASN1OctetString aSN1OctetString;
            Object object;
            DERBitString dERBitString = subjectPublicKeyInfo.getPublicKeyData();
            this.algorithm = "ECGOST3410";
            try {
                object = new ASN1InputStream(dERBitString.getBytes());
                aSN1OctetString = (ASN1OctetString)((ASN1InputStream)object).readObject();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("error recovering public key");
            }
            object = aSN1OctetString.getOctets();
            byte[] byArray = new byte[32];
            byte[] byArray2 = new byte[32];
            for (n = 0; n != byArray2.length; ++n) {
                byArray[n] = (byte)object[31 - n];
            }
            for (n = 0; n != byArray.length; ++n) {
                byArray2[n] = (byte)object[63 - n];
            }
            this.gostParams = new GOST3410PublicKeyAlgParameters((ASN1Sequence)subjectPublicKeyInfo.getAlgorithmId().getParameters());
            ECNamedCurveParameterSpec eCNamedCurveParameterSpec = ECGOST3410NamedCurveTable.getParameterSpec(ECGOST3410NamedCurves.getName(this.gostParams.getPublicKeyParamSet()));
            ECCurve eCCurve = eCNamedCurveParameterSpec.getCurve();
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCCurve, eCNamedCurveParameterSpec.getSeed());
            if (eCCurve instanceof ECCurve.Fp) {
                this.q = new ECPoint.Fp(eCCurve, new ECFieldElement.Fp(((ECCurve.Fp)eCCurve).getQ(), new BigInteger(1, byArray)), new ECFieldElement.Fp(((ECCurve.Fp)eCCurve).getQ(), new BigInteger(1, byArray2)));
            } else {
                ECCurve.F2m f2m = (ECCurve.F2m)eCCurve;
                this.q = new ECPoint.F2m(f2m, new ECFieldElement.F2m(f2m.getM(), f2m.getK1(), f2m.getK2(), f2m.getK3(), new BigInteger(1, byArray)), new ECFieldElement.F2m(f2m.getM(), f2m.getK1(), f2m.getK2(), f2m.getK3(), new BigInteger(1, byArray2)), false);
            }
            this.ecSpec = new ECNamedCurveSpec(ECGOST3410NamedCurves.getName(this.gostParams.getPublicKeyParamSet()), ellipticCurve, new ECPoint(eCNamedCurveParameterSpec.getG().getX().toBigInteger(), eCNamedCurveParameterSpec.getG().getY().toBigInteger()), eCNamedCurveParameterSpec.getN(), eCNamedCurveParameterSpec.getH());
        } else {
            Object object;
            ECCurve eCCurve;
            Object object2;
            ASN1Encodable aSN1Encodable;
            X962Parameters x962Parameters = new X962Parameters((DERObject)subjectPublicKeyInfo.getAlgorithmId().getParameters());
            if (x962Parameters.isNamedCurve()) {
                aSN1Encodable = (DERObjectIdentifier)x962Parameters.getParameters();
                object2 = ECUtil.getNamedCurveByOid((DERObjectIdentifier)aSN1Encodable);
                eCCurve = ((X9ECParameters)object2).getCurve();
                EllipticCurve ellipticCurve = EC5Util.convertCurve(eCCurve, ((X9ECParameters)object2).getSeed());
                this.ecSpec = new ECNamedCurveSpec(ECUtil.getCurveName((DERObjectIdentifier)aSN1Encodable), ellipticCurve, new ECPoint(((X9ECParameters)object2).getG().getX().toBigInteger(), ((X9ECParameters)object2).getG().getY().toBigInteger()), ((X9ECParameters)object2).getN(), ((X9ECParameters)object2).getH());
            } else {
                aSN1Encodable = new X9ECParameters((ASN1Sequence)x962Parameters.getParameters());
                eCCurve = ((X9ECParameters)aSN1Encodable).getCurve();
                EllipticCurve ellipticCurve = EC5Util.convertCurve(eCCurve, ((X9ECParameters)aSN1Encodable).getSeed());
                this.ecSpec = new ECParameterSpec(ellipticCurve, new ECPoint(((X9ECParameters)aSN1Encodable).getG().getX().toBigInteger(), ((X9ECParameters)aSN1Encodable).getG().getY().toBigInteger()), ((X9ECParameters)aSN1Encodable).getN(), ((X9ECParameters)aSN1Encodable).getH().intValue());
            }
            aSN1Encodable = subjectPublicKeyInfo.getPublicKeyData();
            object2 = ((DERBitString)aSN1Encodable).getBytes();
            ASN1OctetString aSN1OctetString = new DEROctetString((byte[])object2);
            if (object2[0] == 4 && object2[1] == ((Object)object2).length - 2 && (object2[2] == 2 || object2[2] == 3)) {
                try {
                    object = new ByteArrayInputStream((byte[])object2);
                    ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)object);
                    aSN1OctetString = (ASN1OctetString)aSN1InputStream.readObject();
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("error recovering public key");
                }
            }
            object = new X9ECPoint(eCCurve, aSN1OctetString);
            this.q = ((X9ECPoint)object).getPoint();
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        ASN1Encodable aSN1Encodable = null;
        if (this.algorithm.equals("ECGOST3410")) {
            aSN1Encodable = new DERNull();
        } else if (this.ecSpec instanceof ECNamedCurveSpec) {
            object5 = ECUtil.getNamedCurveOid(((ECNamedCurveSpec)this.ecSpec).getName());
            aSN1Encodable = new X962Parameters((DERObjectIdentifier)object5);
        } else {
            object5 = this.ecSpec.getCurve().getField();
            if (object5 instanceof ECFieldFp) {
                object4 = new ECCurve.Fp(((ECFieldFp)object5).getP(), this.ecSpec.getCurve().getA(), this.ecSpec.getCurve().getB());
                object3 = new ECPoint.Fp((ECCurve)object4, ((ECCurve)object4).fromBigInteger(this.ecSpec.getGenerator().getAffineX()), ((ECCurve)object4).fromBigInteger(this.ecSpec.getGenerator().getAffineY()), this.withCompression);
            } else {
                object2 = (ECFieldF2m)object5;
                int[] nArray = ECUtil.convertMidTerms(((ECFieldF2m)object2).getMidTermsOfReductionPolynomial());
                object4 = new ECCurve.F2m(((ECFieldF2m)object2).getM(), nArray[0], nArray[1], nArray[2], this.ecSpec.getCurve().getA(), this.ecSpec.getCurve().getB());
                object3 = new ECPoint.F2m((ECCurve)object4, ((ECCurve)object4).fromBigInteger(this.ecSpec.getGenerator().getAffineX()), ((ECCurve)object4).fromBigInteger(this.ecSpec.getGenerator().getAffineY()), this.withCompression);
            }
            object = new X9ECParameters((ECCurve)object4, (org.bouncycastle.math.ec.ECPoint)object3, this.ecSpec.getOrder(), BigInteger.valueOf(this.ecSpec.getCofactor()), this.ecSpec.getCurve().getSeed());
            aSN1Encodable = new X962Parameters((X9ECParameters)object);
        }
        if (this.algorithm.equals("ECGOST3410")) {
            int n;
            object = this.q.getX().toBigInteger();
            object3 = this.q.getY().toBigInteger();
            object4 = new byte[64];
            object2 = ((BigInteger)object).toByteArray();
            for (n = 0; n != 32; ++n) {
                object4[n] = object2[((Object)object2).length - 1 - n];
            }
            object2 = ((BigInteger)object3).toByteArray();
            for (n = 0; n != 32; ++n) {
                object4[32 + n] = object2[((Object)object2).length - 1 - n];
            }
            object5 = new SubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, this.gostParams.getDERObject()), new DEROctetString((byte[])object4));
        } else {
            object = this.getQ().getCurve();
            if (object instanceof ECCurve.Fp) {
                object3 = (ASN1OctetString)new X9ECPoint(new ECPoint.Fp((ECCurve)object, this.getQ().getX(), this.getQ().getY(), this.withCompression)).getDERObject();
                object5 = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, aSN1Encodable.getDERObject()), ((ASN1OctetString)object3).getOctets());
            } else {
                object3 = (ASN1OctetString)new X9ECPoint(new ECPoint.F2m((ECCurve)object, this.getQ().getX(), this.getQ().getY(), this.withCompression)).getDERObject();
                object5 = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, aSN1Encodable.getDERObject()), ((ASN1OctetString)object3).getOctets());
            }
        }
        return ((ASN1Encodable)object5).getDEREncoded();
    }

    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    public org.bouncycastle.jce.spec.ECParameterSpec getParameters() {
        org.bouncycastle.math.ec.ECPoint eCPoint;
        ECCurve eCCurve;
        ECField eCField = this.ecSpec.getCurve().getField();
        if (eCField instanceof ECFieldFp) {
            eCCurve = new ECCurve.Fp(((ECFieldFp)eCField).getP(), this.ecSpec.getCurve().getA(), this.ecSpec.getCurve().getB());
            eCPoint = new ECPoint.Fp(eCCurve, eCCurve.fromBigInteger(this.ecSpec.getGenerator().getAffineX()), eCCurve.fromBigInteger(this.ecSpec.getGenerator().getAffineY()), this.withCompression);
        } else {
            ECFieldF2m eCFieldF2m = (ECFieldF2m)eCField;
            int[] nArray = ECUtil.convertMidTerms(eCFieldF2m.getMidTermsOfReductionPolynomial());
            eCCurve = new ECCurve.F2m(eCFieldF2m.getM(), nArray[0], nArray[1], nArray[2], this.ecSpec.getCurve().getA(), this.ecSpec.getCurve().getB());
            eCPoint = new ECPoint.F2m(eCCurve, eCCurve.fromBigInteger(this.ecSpec.getGenerator().getAffineX()), eCCurve.fromBigInteger(this.ecSpec.getGenerator().getAffineY()), this.withCompression);
        }
        return new org.bouncycastle.jce.spec.ECParameterSpec(eCCurve, eCPoint, this.ecSpec.getOrder(), BigInteger.valueOf(this.ecSpec.getCofactor()), this.ecSpec.getCurve().getSeed());
    }

    public ECPoint getW() {
        return new ECPoint(this.q.getX().toBigInteger(), this.q.getY().toBigInteger());
    }

    public org.bouncycastle.math.ec.ECPoint getQ() {
        return this.q;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("EC Public Key" + string);
        stringBuffer.append("            X: " + this.q.getX().toBigInteger().toString(16) + string);
        stringBuffer.append("            Y: " + this.q.getY().toBigInteger().toString(16) + string);
        return stringBuffer.toString();
    }

    public void setPointFormat(String string) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(string);
    }
}

