/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.SSHApiException;
import org.apache.airavata.gfac.impl.StandardOutReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHUtils {
    private static final Logger log = LoggerFactory.getLogger(SSHUtils.class);

    public static String scpTo(String localFile, String remoteFile, Session session) throws IOException, JSchException, SSHApiException {
        int len;
        FileInputStream fis = null;
        String prefix = null;
        if (new File(localFile).isDirectory()) {
            prefix = localFile + File.separator;
        }
        boolean ptimestamp = true;
        String command = "scp " + (ptimestamp ? "-p" : "") + " -t " + remoteFile;
        Channel channel = session.openChannel("exec");
        StandardOutReader stdOutReader = new StandardOutReader();
        ((ChannelExec)channel).setErrStream(stdOutReader.getStandardError());
        ((ChannelExec)channel).setCommand(command);
        OutputStream out = channel.getOutputStream();
        InputStream in = channel.getInputStream();
        channel.connect();
        if (SSHUtils.checkAck(in) != 0) {
            String error = "Error Reading input Stream";
            log.error(error);
            throw new SSHApiException(error);
        }
        File _lfile = new File(localFile);
        if (ptimestamp) {
            command = "T" + _lfile.lastModified() / 1000L + " 0";
            command = command + " " + _lfile.lastModified() / 1000L + " 0\n";
            out.write(command.getBytes());
            out.flush();
            if (SSHUtils.checkAck(in) != 0) {
                String error = "Error Reading input Stream";
                log.error(error);
                throw new SSHApiException(error);
            }
        }
        long filesize = _lfile.length();
        command = "C0644 " + filesize + " ";
        command = localFile.lastIndexOf(47) > 0 ? command + localFile.substring(localFile.lastIndexOf(47) + 1) : command + localFile;
        command = command + "\n";
        out.write(command.getBytes());
        out.flush();
        if (SSHUtils.checkAck(in) != 0) {
            String error = "Error Reading input Stream";
            log.error(error);
            throw new SSHApiException(error);
        }
        fis = new FileInputStream(localFile);
        byte[] buf = new byte[1024];
        while ((len = fis.read(buf, 0, buf.length)) > 0) {
            out.write(buf, 0, len);
        }
        fis.close();
        fis = null;
        buf[0] = 0;
        out.write(buf, 0, 1);
        out.flush();
        if (SSHUtils.checkAck(in) != 0) {
            String error = "Error Reading input Stream";
            log.error(error);
            throw new SSHApiException(error);
        }
        out.close();
        stdOutReader.onOutput(channel);
        channel.disconnect();
        if (stdOutReader.getStdErrorString().contains("scp:")) {
            throw new SSHApiException(stdOutReader.getStdErrorString());
        }
        return remoteFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scpFrom(String remoteFile, String localFile, Session session) throws IOException, JSchException, SSHApiException {
        FileOutputStream fos = null;
        try {
            int c;
            String prefix = null;
            if (new File(localFile).isDirectory()) {
                prefix = localFile + File.separator;
            }
            String command = "scp -f " + remoteFile;
            Channel channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            StandardOutReader stdOutReader = new StandardOutReader();
            ((ChannelExec)channel).setErrStream(stdOutReader.getStandardError());
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            if (!channel.isClosed()) {
                channel.connect();
            }
            byte[] buf = new byte[1024];
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            while ((c = SSHUtils.checkAck(in)) == 67) {
                int foo;
                in.read(buf, 0, 5);
                long filesize = 0L;
                while (in.read(buf, 0, 1) >= 0 && buf[0] != 32) {
                    filesize = filesize * 10L + (long)(buf[0] - 48);
                }
                String file = null;
                int i = 0;
                while (true) {
                    in.read(buf, i, 1);
                    if (buf[i] == 10) break;
                    ++i;
                }
                file = new String(buf, 0, i);
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
                fos = new FileOutputStream(prefix == null ? localFile : prefix + file);
                do {
                    foo = (long)buf.length < filesize ? buf.length : (int)filesize;
                    if ((foo = in.read(buf, 0, foo)) < 0) break;
                    fos.write(buf, 0, foo);
                } while ((filesize -= (long)foo) != 0L);
                fos.close();
                fos = null;
                if (SSHUtils.checkAck(in) != 0) {
                    String error = "Error transfering the file content";
                    log.error(error);
                    throw new SSHApiException(error);
                }
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
            }
            stdOutReader.onOutput(channel);
            if (stdOutReader.getStdErrorString().contains("scp:")) {
                throw new SSHApiException(stdOutReader.getStdErrorString());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void scpThirdParty(String sourceFile, Session sourceSession, String destinationFile, Session destinationSession, boolean ignoreEmptyFile) throws IOException, JSchException {
        OutputStream sout = null;
        InputStream sin = null;
        OutputStream dout = null;
        InputStream din = null;
        try {
            int c;
            Object prefix = null;
            String sourceCommand = "scp -f " + sourceFile;
            Channel sourceChannel = sourceSession.openChannel("exec");
            ((ChannelExec)sourceChannel).setCommand(sourceCommand);
            StandardOutReader sourceStdOutReader = new StandardOutReader();
            ((ChannelExec)sourceChannel).setErrStream(sourceStdOutReader.getStandardError());
            sout = sourceChannel.getOutputStream();
            sin = sourceChannel.getInputStream();
            sourceChannel.connect();
            boolean ptimestamp = true;
            String command = "scp " + (ptimestamp ? "-p" : "") + " -t " + destinationFile;
            Channel targetChannel = destinationSession.openChannel("exec");
            StandardOutReader targetStdOutReader = new StandardOutReader();
            ((ChannelExec)targetChannel).setErrStream(targetStdOutReader.getStandardError());
            ((ChannelExec)targetChannel).setCommand(command);
            dout = targetChannel.getOutputStream();
            din = targetChannel.getInputStream();
            targetChannel.connect();
            if (SSHUtils.checkAck(din) != 0) {
                String error = "Error Reading input Stream";
                log.error(error);
                throw new Exception(error);
            }
            byte[] buf = new byte[1024];
            buf[0] = 0;
            sout.write(buf, 0, 1);
            sout.flush();
            log.info("Initiating transfer from:" + sourceFile + " To: " + destinationFile + ", Ignore Empty file : " + ignoreEmptyFile);
            while ((c = SSHUtils.checkAck(sin)) == 67) {
                int rLength;
                sin.read(buf, 0, 5);
                long fileSize = 0L;
                while (sin.read(buf, 0, 1) >= 0 && buf[0] != 32) {
                    fileSize = fileSize * 10L + (long)(buf[0] - 48);
                }
                String fileName = null;
                int i = 0;
                while (true) {
                    sin.read(buf, i, 1);
                    if (buf[i] == 10) break;
                    ++i;
                }
                fileName = new String(buf, 0, i);
                if (fileSize == 0L) {
                    log.warn("*****Zero byte file*****. Transferring from:" + sourceFile + " To: " + destinationFile + ", File Size : " + fileSize + ", Ignore Empty file : " + ignoreEmptyFile);
                } else {
                    log.info("Transferring from:" + sourceFile + " To: " + destinationFile + ", File Size : " + fileSize + ", Ignore Empty file : " + ignoreEmptyFile);
                }
                if (fileSize == 0L && !ignoreEmptyFile) {
                    String error = "Input file is empty...";
                    log.error(error);
                    throw new JSchException(error);
                }
                String initData = "C0644 " + fileSize + " " + fileName + "\n";
                assert (dout != null);
                dout.write(initData.getBytes());
                dout.flush();
                buf[0] = 0;
                sout.write(buf, 0, 1);
                sout.flush();
                do {
                    rLength = (long)buf.length < fileSize ? buf.length : (int)fileSize;
                    if ((rLength = sin.read(buf, 0, rLength)) < 0) break;
                    dout.write(buf, 0, rLength);
                } while ((fileSize -= (long)rLength) != 0L);
                buf[0] = 0;
                dout.write(buf, 0, 1);
                dout.flush();
                if (SSHUtils.checkAck(din) != 0) {
                    String error = "Error Reading input Stream";
                    log.error(error);
                    throw new Exception(error);
                }
                dout.close();
                dout = null;
                if (SSHUtils.checkAck(sin) != 0) {
                    String error = "Error transfering the file content";
                    log.error(error);
                    throw new Exception(error);
                }
                buf[0] = 0;
                sout.write(buf, 0, 1);
                sout.flush();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new JSchException(e.getMessage());
        }
        finally {
            try {
                if (dout != null) {
                    dout.close();
                }
            }
            catch (Exception ee) {
                log.error("", (Throwable)ee);
            }
            try {
                if (din != null) {
                    din.close();
                }
            }
            catch (Exception ee) {
                log.error("", (Throwable)ee);
            }
            try {
                if (sout != null) {
                    sout.close();
                }
            }
            catch (Exception ee) {
                log.error("", (Throwable)ee);
            }
            try {
                if (din != null) {
                    din.close();
                }
            }
            catch (Exception ee) {
                log.error("", (Throwable)ee);
            }
        }
    }

    public static void makeDirectory(String path, Session session) throws IOException, JSchException, GFacException {
        String command = "mkdir -p " + path;
        Channel channel = session.openChannel("exec");
        StandardOutReader stdOutReader = new StandardOutReader();
        ((ChannelExec)channel).setCommand(command);
        ((ChannelExec)channel).setErrStream(stdOutReader.getStandardError());
        try {
            channel.connect();
        }
        catch (JSchException e) {
            channel.disconnect();
            log.error("Unable to retrieve command output. Command - " + command + " on server - " + session.getHost() + ":" + session.getPort() + " connecting user name - " + session.getUserName());
            throw e;
        }
        stdOutReader.onOutput(channel);
        if (stdOutReader.getStdErrorString().contains("mkdir:")) {
            throw new GFacException(stdOutReader.getStdErrorString());
        }
        channel.disconnect();
    }

    public static List<String> listDirectory(String path, Session session) throws IOException, JSchException, GFacException {
        String command = "ls " + path;
        Channel channel = session.openChannel("exec");
        StandardOutReader stdOutReader = new StandardOutReader();
        ((ChannelExec)channel).setCommand(command);
        ((ChannelExec)channel).setErrStream(stdOutReader.getStandardError());
        try {
            channel.connect();
        }
        catch (JSchException e) {
            channel.disconnect();
            throw new GFacException("Unable to retrieve command output. Command - " + command + " on server - " + session.getHost() + ":" + session.getPort() + " connecting user name - " + session.getUserName(), (Throwable)e);
        }
        stdOutReader.onOutput(channel);
        stdOutReader.getStdOutputString();
        if (stdOutReader.getStdErrorString().contains("ls:")) {
            throw new GFacException(stdOutReader.getStdErrorString());
        }
        channel.disconnect();
        return Arrays.asList(stdOutReader.getStdOutputString().split("\n"));
    }

    public static long getFileSize(String path, Session session) throws GFacException {
        String command = "du -b " + path;
        Channel channel = null;
        try {
            channel = session.openChannel("exec");
        }
        catch (JSchException e) {
            log.error("Failed to open a channel to " + session.getHost(), (Throwable)e);
            throw new GFacException("Failed to open a channel to " + session.getHost(), (Throwable)e);
        }
        StandardOutReader stdOutReader = new StandardOutReader();
        ((ChannelExec)channel).setCommand(command);
        ((ChannelExec)channel).setErrStream(stdOutReader.getStandardError());
        try {
            channel.connect();
        }
        catch (JSchException e) {
            channel.disconnect();
            throw new GFacException("Unable to retrieve command output. Command - " + command + " on server - " + session.getHost() + ":" + session.getPort() + " connecting user name - " + session.getUserName(), (Throwable)e);
        }
        stdOutReader.onOutput(channel);
        stdOutReader.getStdOutputString();
        if (stdOutReader.getStdErrorString().contains("du:")) {
            throw new GFacException(stdOutReader.getStdErrorString());
        }
        channel.disconnect();
        return Long.parseLong(stdOutReader.getStdOutputString().split("\t")[0]);
    }

    static int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                System.out.print(sb.toString());
            }
            if (b == 2) {
                System.out.print(sb.toString());
            }
            log.warn(sb.toString());
        }
        return b;
    }
}

