/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.monitor.email;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;
import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.GFacThreadPoolExecutor;
import org.apache.airavata.gfac.core.GFacUtils;
import org.apache.airavata.gfac.core.config.ResourceConfig;
import org.apache.airavata.gfac.core.context.ProcessContext;
import org.apache.airavata.gfac.core.context.TaskContext;
import org.apache.airavata.gfac.core.monitor.EmailParser;
import org.apache.airavata.gfac.core.monitor.JobMonitor;
import org.apache.airavata.gfac.core.monitor.JobStatusResult;
import org.apache.airavata.gfac.impl.GFacWorker;
import org.apache.airavata.model.appcatalog.computeresource.ResourceJobManagerType;
import org.apache.airavata.model.job.JobModel;
import org.apache.airavata.model.status.JobState;
import org.apache.airavata.model.status.JobStatus;
import org.apache.airavata.model.status.ProcessState;
import org.apache.airavata.model.status.ProcessStatus;
import org.apache.airavata.model.status.TaskState;
import org.apache.airavata.model.status.TaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailBasedMonitor
implements JobMonitor,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(EmailBasedMonitor.class);
    public static final int COMPARISON = 6;
    public static final String IMAPS = "imaps";
    public static final String POP3 = "pop3";
    private boolean stopMonitoring = false;
    private Session session;
    private Store store;
    private Folder emailFolder;
    private Properties properties;
    private Map<String, TaskContext> jobMonitorMap = new ConcurrentHashMap<String, TaskContext>();
    private String host;
    private String emailAddress;
    private String password;
    private String storeProtocol;
    private String folderName;
    private Date monitorStartDate;
    private Map<ResourceJobManagerType, EmailParser> emailParserMap = new HashMap<ResourceJobManagerType, EmailParser>();
    private Map<String, ResourceJobManagerType> addressMap = new HashMap<String, ResourceJobManagerType>();
    private Message[] flushUnseenMessages;
    private Map<String, Boolean> canceledJobs = new ConcurrentHashMap<String, Boolean>();
    private Timer timer;

    public EmailBasedMonitor(Map<ResourceJobManagerType, ResourceConfig> resourceConfigs) throws AiravataException {
        this.init();
        this.populateAddressAndParserMap(resourceConfigs);
    }

    private void init() throws AiravataException {
        this.host = ServerSettings.getEmailBasedMonitorHost();
        this.emailAddress = ServerSettings.getEmailBasedMonitorAddress();
        this.password = ServerSettings.getEmailBasedMonitorPassword();
        this.storeProtocol = ServerSettings.getEmailBasedMonitorStoreProtocol();
        this.folderName = ServerSettings.getEmailBasedMonitorFolderName();
        if (!this.storeProtocol.equals(IMAPS) && !this.storeProtocol.equals(POP3)) {
            throw new AiravataException("Unsupported store protocol , expected imaps or pop3 but found " + this.storeProtocol);
        }
        this.properties = new Properties();
        this.properties.put("mail.store.protocol", this.storeProtocol);
        this.timer = new Timer("CancelJobHandler", true);
        long period = 300000L;
        this.timer.schedule((TimerTask)new CancelTimerTask(), 0L, period);
    }

    private void populateAddressAndParserMap(Map<ResourceJobManagerType, ResourceConfig> resourceConfigs) throws AiravataException {
        for (Map.Entry<ResourceJobManagerType, ResourceConfig> resourceConfigEntry : resourceConfigs.entrySet()) {
            ResourceJobManagerType type = resourceConfigEntry.getKey();
            ResourceConfig config = resourceConfigEntry.getValue();
            List resourceEmailAddresses = config.getResourceEmailAddresses();
            if (resourceEmailAddresses == null || resourceEmailAddresses.isEmpty()) continue;
            for (String resourceEmailAddress : resourceEmailAddresses) {
                this.addressMap.put(resourceEmailAddress, type);
            }
            try {
                Class<EmailParser> emailParserClass = Class.forName(config.getEmailParser()).asSubclass(EmailParser.class);
                EmailParser emailParser = emailParserClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.emailParserMap.put(type, emailParser);
            }
            catch (Exception e) {
                throw new AiravataException("Error while instantiation email parsers", (Throwable)e);
            }
        }
    }

    public void monitor(String jobId, TaskContext taskContext) {
        log.info("[EJM]: Added monitor Id : {} to email based monitor map", (Object)jobId);
        this.jobMonitorMap.put(jobId, taskContext);
        taskContext.getParentProcessContext().setPauseTaskExecution(true);
    }

    public void stopMonitor(String jobId, boolean runOutflow) {
        TaskContext taskContext = this.jobMonitorMap.remove(jobId);
        if (taskContext != null && runOutflow) {
            try {
                ProcessContext pc = taskContext.getParentProcessContext();
                if (taskContext.isCancel()) {
                    JobModel jobModel = pc.getJobModel();
                    JobStatus newJobStatus = new JobStatus(JobState.CANCELED);
                    newJobStatus.setReason("Moving job status to cancel, as we didn't see any email from this job for a while after execute job cancel command. This may happen if job was in queued state when we run the cancel command");
                    jobModel.setJobStatuses(Arrays.asList(newJobStatus));
                    GFacUtils.saveJobStatus((ProcessContext)pc, (JobModel)jobModel);
                }
                ProcessStatus pStatus = new ProcessStatus(ProcessState.CANCELLING);
                pStatus.setReason("Job cancelled");
                pc.setProcessStatus(pStatus);
                GFacUtils.saveAndPublishProcessStatus((ProcessContext)pc);
                GFacThreadPoolExecutor.getCachedThreadPool().execute(new GFacWorker(pc));
            }
            catch (GFacException e) {
                log.info("[EJM]: Error while running output tasks", (Throwable)e);
            }
        }
    }

    public boolean isMonitoring(String jobId) {
        return this.jobMonitorMap.containsKey(jobId);
    }

    public void canceledJob(String jobId) {
        this.canceledJobs.put(jobId, Boolean.FALSE);
    }

    private JobStatusResult parse(Message message) throws MessagingException, AiravataException {
        Address fromAddress = message.getFrom()[0];
        String addressStr = fromAddress.toString();
        ResourceJobManagerType jobMonitorType = this.getJobMonitorType(addressStr);
        EmailParser emailParser = this.emailParserMap.get(jobMonitorType);
        if (emailParser == null) {
            throw new AiravataException("[EJM]: Un-handle resource job manager type: " + jobMonitorType.toString() + " for email monitoring -->  " + addressStr);
        }
        return emailParser.parseEmail(message);
    }

    private ResourceJobManagerType getJobMonitorType(String addressStr) throws AiravataException {
        for (Map.Entry<String, ResourceJobManagerType> addressEntry : this.addressMap.entrySet()) {
            if (!addressStr.contains(addressEntry.getKey())) continue;
            return addressEntry.getValue();
        }
        throw new AiravataException("[EJM]: Couldn't identify Resource job manager type from address " + addressStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean quite = false;
        while (!this.stopMonitoring && !ServerSettings.isStopAllThreads()) {
            try {
                this.session = Session.getDefaultInstance((Properties)this.properties);
                this.store = this.session.getStore(this.storeProtocol);
                this.store.connect(this.host, this.emailAddress, this.password);
                this.emailFolder = this.store.getFolder(this.folderName);
                FlagTerm unseenBefore = new FlagTerm(new Flags(Flags.Flag.SEEN), false);
                while (!this.stopMonitoring && !ServerSettings.isStopAllThreads()) {
                    Message[] searchMessages;
                    block39: {
                        Thread.sleep(ServerSettings.getEmailMonitorPeriod());
                        if (this.jobMonitorMap.isEmpty()) {
                            if (!quite) {
                                log.info("[EJM]: Job Monitor Map is empty, no need to retrieve emails");
                            }
                            quite = true;
                            continue;
                        }
                        quite = false;
                        log.info("[EJM]: {} job/s in job monitor map", (Object)this.jobMonitorMap.size());
                        if (!this.store.isConnected()) {
                            this.store.connect();
                            this.emailFolder = this.store.getFolder(this.folderName);
                        }
                        log.info("[EJM]: Retrieving unseen emails");
                        this.emailFolder.open(2);
                        if (!this.emailFolder.isOpen()) continue;
                        if (this.flushUnseenMessages != null && this.flushUnseenMessages.length > 0) {
                            try {
                                this.emailFolder.setFlags(this.flushUnseenMessages, new Flags(Flags.Flag.SEEN), false);
                                this.flushUnseenMessages = null;
                            }
                            catch (MessagingException e) {
                                if (this.store.isConnected()) break block39;
                                this.store.connect();
                                this.emailFolder.setFlags(this.flushUnseenMessages, new Flags(Flags.Flag.SEEN), false);
                                this.flushUnseenMessages = null;
                            }
                        }
                    }
                    if ((searchMessages = this.emailFolder.search((SearchTerm)unseenBefore)) == null || searchMessages.length == 0) {
                        log.info("[EJM]: No new email messages");
                    } else {
                        log.info("[EJM]: " + searchMessages.length + " new email/s received");
                    }
                    this.processMessages(searchMessages);
                    this.emailFolder.close(false);
                }
            }
            catch (MessagingException e) {
                log.error("[EJM]: Couldn't connect to the store ", (Throwable)e);
            }
            catch (InterruptedException e) {
                log.error("[EJM]: Interrupt exception while sleep ", (Throwable)e);
            }
            catch (AiravataException e) {
                log.error("[EJM]: UnHandled arguments ", (Throwable)e);
            }
            catch (Throwable e) {
                log.error("[EJM]: Caught a throwable ", e);
            }
            finally {
                try {
                    this.emailFolder.close(false);
                    this.store.close();
                }
                catch (MessagingException e) {
                    log.error("[EJM]: Store close operation failed, couldn't close store", (Throwable)e);
                }
                catch (Throwable e) {
                    log.error("[EJM]: Caught a throwable while closing email store ", e);
                }
            }
        }
        log.info("[EJM]: Email monitoring daemon stopped");
    }

    private void processMessages(Message[] searchMessages) throws MessagingException {
        ArrayList<Message> unreadMessages;
        block20: {
            ArrayList<Message> processedMessages = new ArrayList<Message>();
            unreadMessages = new ArrayList<Message>();
            for (Message message : searchMessages) {
                try {
                    JobStatusResult jobStatusResult = this.parse(message);
                    TaskContext taskContext = null;
                    if (jobStatusResult.getJobId() != null) {
                        taskContext = this.jobMonitorMap.get(jobStatusResult.getJobId());
                    } else {
                        log.info("Returned null for job id, message subject--> {}", (Object)message.getSubject());
                    }
                    if (taskContext == null) {
                        if (jobStatusResult.getJobName() != null) {
                            taskContext = this.jobMonitorMap.get(jobStatusResult.getJobName());
                        } else {
                            log.info("Returned null for job name, message subject --> {}", (Object)message.getSubject());
                        }
                    }
                    if (taskContext != null) {
                        this.process(jobStatusResult, taskContext);
                        processedMessages.add(message);
                        continue;
                    }
                    if (!jobStatusResult.isAuthoritative() && new Date().getTime() - message.getSentDate().getTime() > 300000L) {
                        processedMessages.add(message);
                        log.info("Marking old Airavata custom emails as read, message subject --> {}", (Object)message.getSubject());
                        continue;
                    }
                    unreadMessages.add(message);
                }
                catch (AiravataException e) {
                    log.error("[EJM]: Error parsing email message =====================================>", (Throwable)e);
                    try {
                        this.writeEnvelopeOnError(message);
                    }
                    catch (MessagingException e1) {
                        log.error("[EJM]: Error printing envelop of the email");
                    }
                    unreadMessages.add(message);
                }
                catch (MessagingException e) {
                    log.error("[EJM]: Error while retrieving sender address from message : " + message.toString());
                    unreadMessages.add(message);
                }
            }
            if (!processedMessages.isEmpty()) {
                Message[] seenMessages = new Message[processedMessages.size()];
                processedMessages.toArray(seenMessages);
                try {
                    this.emailFolder.setFlags(seenMessages, new Flags(Flags.Flag.SEEN), true);
                }
                catch (MessagingException e) {
                    if (this.store.isConnected()) break block20;
                    this.store.connect();
                    this.emailFolder.setFlags(seenMessages, new Flags(Flags.Flag.SEEN), true);
                }
            }
        }
        if (!unreadMessages.isEmpty()) {
            Message[] unseenMessages = new Message[unreadMessages.size()];
            unreadMessages.toArray(unseenMessages);
            try {
                this.emailFolder.setFlags(unseenMessages, new Flags(Flags.Flag.SEEN), false);
            }
            catch (MessagingException e) {
                if (!this.store.isConnected()) {
                    this.store.connect();
                    this.emailFolder.setFlags(unseenMessages, new Flags(Flags.Flag.SEEN), false);
                    this.flushUnseenMessages = unseenMessages;
                }
                this.flushUnseenMessages = unseenMessages;
            }
        }
    }

    private void process(JobStatusResult jobStatusResult, TaskContext taskContext) {
        this.canceledJobs.remove(jobStatusResult.getJobId());
        JobState resultState = jobStatusResult.getState();
        boolean runOutflowTasks = false;
        JobStatus jobStatus = new JobStatus();
        ProcessContext parentProcessContext = taskContext.getParentProcessContext();
        JobModel jobModel = parentProcessContext.getJobModel();
        String jobDetails = "JobName : " + jobStatusResult.getJobName() + ", JobId : " + jobStatusResult.getJobId();
        JobState currentState = null;
        List jobStatusList = jobModel.getJobStatuses();
        if (jobStatusList != null && jobStatusList.size() > 0) {
            JobStatus lastStatus = (JobStatus)jobStatusList.get(0);
            for (JobStatus temp : jobStatusList) {
                if (temp.getTimeOfStateChange() < lastStatus.getTimeOfStateChange()) continue;
                lastStatus = temp;
            }
            currentState = lastStatus.getJobState();
        }
        if (resultState == JobState.COMPLETE) {
            if (jobStatusResult.isAuthoritative()) {
                if (currentState != null && currentState == JobState.COMPLETE) {
                    this.jobMonitorMap.remove(jobStatusResult.getJobId());
                    runOutflowTasks = false;
                    log.info("[EJM]: Authoritative job Complete email received after early Airavata custom complete email, removed job from job monitoring. " + jobDetails);
                } else {
                    this.jobMonitorMap.remove(jobStatusResult.getJobId());
                    runOutflowTasks = true;
                    jobStatus.setJobState(JobState.COMPLETE);
                    jobStatus.setReason("Complete email received");
                    jobStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
                    log.info("[EJM]: Authoritative job Complete email received , removed job from job monitoring. " + jobDetails);
                }
            } else {
                runOutflowTasks = true;
                jobStatus.setJobState(JobState.COMPLETE);
                jobStatus.setReason("Complete email received");
                jobStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
                log.info("[EJM]: Non Authoritative Job Complete email received. " + jobDetails);
            }
        } else if (resultState == JobState.QUEUED) {
            if (currentState != JobState.COMPLETE) {
                jobStatus.setJobState(JobState.QUEUED);
                jobStatus.setReason("Queue email received");
                jobStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
                log.info("[EJM]: Job Queued email received, " + jobDetails);
            }
        } else if (resultState == JobState.ACTIVE) {
            if (currentState != JobState.COMPLETE) {
                jobStatus.setJobState(JobState.ACTIVE);
                jobStatus.setReason("Active email received");
                jobStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
                log.info("[EJM]: Job Active email received, " + jobDetails);
            }
        } else if (resultState == JobState.FAILED) {
            if (currentState != JobState.COMPLETE) {
                this.jobMonitorMap.remove(jobStatusResult.getJobId());
                runOutflowTasks = true;
                jobStatus.setJobState(JobState.FAILED);
                jobStatus.setReason("Failed email received");
                jobStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
                log.info("[EJM]: Job failed email received , removed job from job monitoring. " + jobDetails);
            }
        } else if (resultState == JobState.CANCELED && currentState != JobState.COMPLETE) {
            this.jobMonitorMap.remove(jobStatusResult.getJobId());
            jobStatus.setJobState(JobState.CANCELED);
            jobStatus.setReason("Canceled email received");
            jobStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
            log.info("[EJM]: Job canceled mail received, removed job from job monitoring. " + jobDetails);
            runOutflowTasks = true;
        }
        if (jobStatus.getJobState() != null) {
            try {
                jobModel.setJobStatuses(Arrays.asList(jobStatus));
                log.info("[EJM]: Publishing status changes to amqp. " + jobDetails);
                GFacUtils.saveJobStatus((ProcessContext)parentProcessContext, (JobModel)jobModel);
            }
            catch (GFacException e) {
                log.error("expId: {}, processId: {}, taskId: {}, jobId: {} :- Error while save and publishing Job status {}", new Object[]{taskContext.getExperimentId(), taskContext.getProcessId(), jobModel.getTaskId(), jobModel.getJobId(), jobStatus.getJobState()});
            }
        }
        if (runOutflowTasks) {
            log.info("[EJM]: Calling Out Handler chain of " + jobDetails);
            try {
                TaskStatus taskStatus = new TaskStatus(TaskState.COMPLETED);
                taskStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
                taskStatus.setReason("Job monitoring completed with final state: " + TaskState.COMPLETED.name());
                taskContext.setTaskStatus(taskStatus);
                GFacUtils.saveAndPublishTaskStatus((TaskContext)taskContext);
                if (parentProcessContext.isCancel()) {
                    ProcessStatus processStatus = new ProcessStatus(ProcessState.CANCELLING);
                    processStatus.setReason("Process has been cancelled");
                    parentProcessContext.setProcessStatus(processStatus);
                    GFacUtils.saveAndPublishProcessStatus((ProcessContext)parentProcessContext);
                }
                GFacThreadPoolExecutor.getCachedThreadPool().execute(new GFacWorker(parentProcessContext));
            }
            catch (GFacException e) {
                log.info("[EJM]: Error while running output tasks", (Throwable)e);
            }
        }
    }

    private void writeEnvelopeOnError(Message m) throws MessagingException {
        int j;
        Address[] a = m.getFrom();
        if (a != null) {
            for (j = 0; j < a.length; ++j) {
                log.error("FROM: " + a[j].toString());
            }
        }
        if ((a = m.getRecipients(Message.RecipientType.TO)) != null) {
            for (j = 0; j < a.length; ++j) {
                log.error("TO: " + a[j].toString());
            }
        }
        if (m.getSubject() != null) {
            log.error("SUBJECT: " + m.getSubject());
        }
    }

    public void stopMonitoring() {
        this.stopMonitoring = true;
    }

    public void setDate(Date date) {
        this.monitorStartDate = date;
    }

    private class CancelTimerTask
    extends TimerTask {
        private CancelTimerTask() {
        }

        @Override
        public void run() {
            if (!EmailBasedMonitor.this.canceledJobs.isEmpty()) {
                Iterator cancelJobIter = EmailBasedMonitor.this.canceledJobs.entrySet().iterator();
                while (cancelJobIter.hasNext()) {
                    Map.Entry cancelJobIdWithFlag = cancelJobIter.next();
                    if (!((Boolean)cancelJobIdWithFlag.getValue()).booleanValue()) {
                        cancelJobIdWithFlag.setValue(Boolean.TRUE);
                        continue;
                    }
                    TaskContext taskContext = (TaskContext)EmailBasedMonitor.this.jobMonitorMap.get(cancelJobIdWithFlag.getKey());
                    if (taskContext != null) {
                        taskContext.setCancel(true);
                        EmailBasedMonitor.this.stopMonitor((String)cancelJobIdWithFlag.getKey(), true);
                    }
                    cancelJobIter.remove();
                }
            }
        }
    }
}

