/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.orchestrator.core.impl;

import java.util.UUID;
import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.credential.store.store.CredentialReader;
import org.apache.airavata.gfac.client.GFACInstance;
import org.apache.airavata.gfac.core.GFacUtils;
import org.apache.airavata.messaging.core.MessageContext;
import org.apache.airavata.messaging.core.MessagingFactory;
import org.apache.airavata.messaging.core.Publisher;
import org.apache.airavata.messaging.core.Type;
import org.apache.airavata.model.messaging.event.MessageType;
import org.apache.airavata.model.messaging.event.ProcessSubmitEvent;
import org.apache.airavata.model.messaging.event.ProcessTerminateEvent;
import org.apache.airavata.orchestrator.core.context.OrchestratorContext;
import org.apache.airavata.orchestrator.core.exception.OrchestratorException;
import org.apache.airavata.orchestrator.core.job.JobSubmitter;
import org.apache.thrift.TBase;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GFACPassiveJobSubmitter
implements JobSubmitter,
Watcher {
    private static final Logger logger = LoggerFactory.getLogger(GFACPassiveJobSubmitter.class);
    private static Integer mutex = -1;
    private Publisher publisher;

    @Override
    public void initialize(OrchestratorContext orchestratorContext) throws OrchestratorException {
        if (orchestratorContext.getPublisher() != null) {
            this.publisher = orchestratorContext.getPublisher();
        } else {
            try {
                this.publisher = MessagingFactory.getPublisher((Type)Type.PROCESS_LAUNCH);
            }
            catch (AiravataException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new OrchestratorException("Cannot initialize " + GFACPassiveJobSubmitter.class + " need to start Rabbitmq server to use " + GFACPassiveJobSubmitter.class);
            }
        }
    }

    @Override
    public GFACInstance selectGFACInstance() throws OrchestratorException {
        return null;
    }

    @Override
    public boolean submit(String experimentId, String processId, String tokenId) throws OrchestratorException {
        try {
            String gatewayId = null;
            CredentialReader credentialReader = GFacUtils.getCredentialReader();
            if (credentialReader != null) {
                try {
                    gatewayId = credentialReader.getGatewayID(tokenId);
                }
                catch (Exception e) {
                    logger.error(e.getLocalizedMessage());
                }
            }
            if (gatewayId == null || gatewayId.isEmpty()) {
                gatewayId = ServerSettings.getDefaultUserGateway();
            }
            ProcessSubmitEvent processSubmitEvent = new ProcessSubmitEvent(processId, gatewayId, experimentId, tokenId);
            MessageContext messageContext = new MessageContext((TBase)processSubmitEvent, MessageType.LAUNCHPROCESS, "LAUNCH.PROCESS-" + UUID.randomUUID().toString(), gatewayId);
            messageContext.setUpdatedTime(AiravataUtils.getCurrentTimestamp());
            this.publisher.publish(messageContext);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new OrchestratorException(e);
        }
        return true;
    }

    @Override
    public boolean terminate(String experimentId, String processId, String tokenId) throws OrchestratorException {
        String gatewayId = null;
        try {
            CredentialReader credentialReader = GFacUtils.getCredentialReader();
            if (credentialReader != null) {
                try {
                    gatewayId = credentialReader.getGatewayID(tokenId);
                }
                catch (Exception e) {
                    logger.error(e.getLocalizedMessage());
                }
            }
            if (gatewayId == null || gatewayId.isEmpty()) {
                gatewayId = ServerSettings.getDefaultUserGateway();
            }
            ProcessTerminateEvent processTerminateEvent = new ProcessTerminateEvent(processId, gatewayId, tokenId);
            MessageContext messageContext = new MessageContext((TBase)processTerminateEvent, MessageType.TERMINATEPROCESS, "LAUNCH.TERMINATE-" + UUID.randomUUID().toString(), gatewayId);
            messageContext.setUpdatedTime(AiravataUtils.getCurrentTimestamp());
            this.publisher.publish(messageContext);
            return true;
        }
        catch (Exception e) {
            throw new OrchestratorException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void process(WatchedEvent event) {
        logger.info(this.getClass().getName() + event.getPath());
        logger.info(this.getClass().getName() + event.getType());
        Integer n = mutex;
        synchronized (n) {
            switch (event.getState()) {
                case SyncConnected: {
                    mutex.notify();
                }
            }
            switch (event.getType()) {
                case NodeCreated: {
                    mutex.notify();
                }
            }
        }
    }
}

