/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.trustmanager;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.Collection;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;
import org.globus.gsi.X509ProxyCertPathParameters;
import org.globus.gsi.provider.GlobusTrustManagerFactoryParameters;
import org.globus.gsi.trustmanager.PKITrustManager;
import org.globus.gsi.trustmanager.X509ProxyCertPathValidator;

public class PKITrustManagerFactory
extends TrustManagerFactorySpi {
    private Collection<TrustManager> trustManagers = new ArrayList<TrustManager>();

    protected void engineInit(KeyStore keyStore) throws KeyStoreException {
        try {
            this.engineInit(new CertPathTrustManagerParameters(new X509ProxyCertPathParameters(keyStore, null, null, false)));
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new KeyStoreException(e);
        }
    }

    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        if (!(managerFactoryParameters instanceof GlobusTrustManagerFactoryParameters)) {
            throw new InvalidAlgorithmParameterException("Factory cannot accept parameters of type: " + managerFactoryParameters.getClass().getCanonicalName());
        }
        GlobusTrustManagerFactoryParameters ptmfp = (GlobusTrustManagerFactoryParameters)managerFactoryParameters;
        this.trustManagers.add(new PKITrustManager(new X509ProxyCertPathValidator(), ptmfp.getCertPathParameters()));
    }

    protected TrustManager[] engineGetTrustManagers() {
        return this.trustManagers.toArray(new TrustManager[this.trustManagers.size()]);
    }
}

