/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.client;

import de.fzj.unicore.uas.client.BaseUASClient;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.NotificationProducer;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.util.Filters;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.util.SimpleWSNTopicExpression;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.oasisOpen.docs.wsn.b2.SubscribeDocument;
import org.oasisOpen.docs.wsn.b2.SubscribeResponseDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class UASNotificationClient
extends BaseUASClient {
    private final EndpointReferenceType consumer;
    private final HashMap<QName, EndpointReferenceType> subscriptions = new HashMap();

    public UASNotificationClient(EndpointReferenceType consumer, String endpointUrl, EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        super(endpointUrl, epr, sec);
        this.consumer = consumer;
    }

    public UASNotificationClient(EndpointReferenceType consumer, EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        this(consumer, epr.getAddress().getStringValue(), epr, sec);
    }

    public void subscribe(QName event) throws Exception {
        this.subscribe(event, null);
    }

    public void subscribe(QName event, String xpath) throws Exception {
        NotificationProducer np = this.makeProxy(NotificationProducer.class);
        SubscribeDocument sd = SubscribeDocument.Factory.newInstance();
        sd.addNewSubscribe().addNewFilter().set(new SimpleWSNTopicExpression(event).toXml());
        Filters.addXPathMessageContentFilter(sd.getSubscribe().getFilter(), xpath);
        sd.getSubscribe().setConsumerReference(this.consumer);
        SubscribeResponseDocument res = np.Subscribe(sd);
        EndpointReferenceType epr = res.getSubscribeResponse().getSubscriptionReference();
        this.subscriptions.put(event, epr);
    }

    public void unsubscribe(QName event) throws Exception {
        EndpointReferenceType sEpr = this.subscriptions.get(event);
        BaseUASClient rlClient = new BaseUASClient(sEpr, this.getSecurityConfiguration());
        rlClient.destroy();
    }
}

