/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.proto;

import eu.unicore.samly2.SAMLUtils;
import eu.unicore.samly2.trust.SamlTrustChecker;
import eu.unicore.security.dsig.DSigException;
import eu.unicore.security.dsig.DigSignatureUtil;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractSAMLMessage<T extends XmlObject> {
    private static String ID_PREFIX = "SAMLY2lib_msg_";
    protected T xmlDocuemnt;

    public abstract void sign(PrivateKey var1, X509Certificate[] var2) throws DSigException;

    public T getXMLBeanDoc() {
        return this.xmlDocuemnt;
    }

    public Document getDOM() throws DSigException {
        return SAMLUtils.getDOM(this.getXMLBeanDoc());
    }

    public String genID() {
        return SAMLUtils.genID(ID_PREFIX);
    }

    public void sign(PrivateKey pk) throws DSigException {
        this.sign(pk, null);
    }

    protected Document signInt(PrivateKey pk, X509Certificate[] cert) throws DSigException {
        DigSignatureUtil sign = new DigSignatureUtil();
        Document docToSign = this.getDOM();
        NodeList nodes = docToSign.getFirstChild().getChildNodes();
        Node sibling = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (!n.getLocalName().equals("Issuer")) continue;
            if (i + 1 < nodes.getLength()) {
                sibling = nodes.item(i + 1);
                break;
            }
            sibling = null;
            break;
        }
        sign.genEnvelopedSignature(pk, null, cert, docToSign, sibling, SamlTrustChecker.PROTOCOL_ID_QNAME);
        return docToSign;
    }
}

