/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.validators;

import eu.unicore.samly2.exceptions.SAMLValidationException;
import eu.unicore.samly2.trust.SamlTrustChecker;
import eu.unicore.samly2.validators.StatusResponseValidator;
import xmlbeans.org.oasis.saml2.assertion.NameIDType;
import xmlbeans.org.oasis.saml2.protocol.NameIDMappingResponseDocument;
import xmlbeans.org.oasis.saml2.protocol.NameIDMappingResponseType;

public class NameIDMappingResponseValidator
extends StatusResponseValidator {
    public NameIDMappingResponseValidator(String consumerEndpointUri, String requestId, SamlTrustChecker trustChecker) {
        super(consumerEndpointUri, requestId, trustChecker);
    }

    public void validate(NameIDMappingResponseDocument mappingResponseDoc) throws SAMLValidationException {
        NameIDMappingResponseType respXml = mappingResponseDoc.getNameIDMappingResponse();
        super.validate(mappingResponseDoc, respXml);
        if (respXml.getNameID() == null || respXml.getEncryptedID() == null) {
            throw new SAMLValidationException("No mapped name in response");
        }
        NameIDType issuer = respXml.getIssuer();
        if (issuer == null || issuer.isNil()) {
            throw new SAMLValidationException("No issuer in response");
        }
        if (issuer.getFormat() != null && !issuer.getFormat().equals("urn:oasis:names:tc:SAML:2.0:nameid-format:entity")) {
            throw new SAMLValidationException("Issuer must be of entity format, it is " + issuer.getFormat());
        }
        if (issuer.getStringValue() == null) {
            throw new SAMLValidationException("No issuer value in response");
        }
    }
}

