/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil.client;

import eu.emi.security.authn.x509.X509Credential;
import eu.unicore.security.wsutil.DSigDecider;
import eu.unicore.security.wsutil.client.ToBeSignedDecider;
import eu.unicore.security.wsutil.client.WSS4JCryptoImpl;
import eu.unicore.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.TransformerException;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.message.Message;
import org.apache.log4j.Logger;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSignature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DSigOutHandler
extends AbstractSoapInterceptor {
    static final Logger logger = Log.getLogger("unicore.security.dsig", DSigOutHandler.class);
    private static final String WSS_NS_STRING = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    public static final QName WS_SECURITY = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
    private Crypto merlin;
    private DSigDecider decider;
    private X509Credential credential;
    private ToBeSignedDecider partsDecider;
    private boolean disabled = false;
    private static final Set<QName> qnameSet = new HashSet<QName>();

    public DSigOutHandler(X509Credential credential, DSigDecider decider) {
        this(credential, decider, null);
    }

    public DSigOutHandler(X509Credential credential, DSigDecider decider, ToBeSignedDecider partsDecider) {
        super("pre-protocol-ending");
        this.getBefore().add(SAAJOutInterceptor.SAAJOutEndingInterceptor.class.getName());
        this.reinit(credential, decider, partsDecider);
    }

    protected void reinit(X509Credential credential, DSigDecider decider, ToBeSignedDecider partsDecider) {
        this.decider = decider;
        this.partsDecider = partsDecider;
        this.credential = credential;
        try {
            this.merlin = new WSS4JCryptoImpl(credential);
        }
        catch (Exception e) {
            logger.fatal("Could not set up digital signature out handler.", e);
        }
    }

    public void handleMessage(SoapMessage message) {
        SOAPPart docToSign;
        if (this.disabled || this.decider != null && !this.decider.isMessageDSigCandidate((Message)message)) {
            return;
        }
        long start = System.currentTimeMillis();
        try {
            SOAPMessage saajMessage = (SOAPMessage)message.getContent(SOAPMessage.class);
            if (saajMessage == null) {
                logger.fatal("No DOM representation of message found!");
                return;
            }
            docToSign = saajMessage.getSOAPPart();
        }
        catch (Exception e) {
            logger.fatal("IO exception while building DOM of SOAP envelope before signing: ", e);
            return;
        }
        if (logger.isTraceEnabled()) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DOMUtils.writeXml((Node)docToSign.getDocumentElement(), (OutputStream)bos);
                logger.trace("Message before signing:\n" + bos.toString());
            }
            catch (TransformerException e) {
                logger.fatal("", e);
            }
        }
        MyWSSecSignature signatory = new MyWSSecSignature();
        WSSConfig config = WSSConfig.getNewInstance();
        config.setWsiBSPCompliant(true);
        signatory.setWsConfig(config);
        Vector<WSEncryptionPart> toBeSigned = this.getElementsToBeSigned((Document)docToSign);
        WSSecHeader secHeader = new WSSecHeader();
        try {
            secHeader.insertSecurityHeader((Document)docToSign);
            signatory.setUserInfo(this.credential.getKeyAlias(), new String(this.credential.getKeyPassword()));
            signatory.prepare((Document)docToSign, this.merlin, secHeader);
            List references = signatory.addReferencesToSign(toBeSigned, secHeader);
            signatory.computeSignature(references);
        }
        catch (WSSecurityException e) {
            logger.fatal("Problem while signing SOAP message: ", e);
            return;
        }
        long end = System.currentTimeMillis();
        logger.debug("Signed outgoing message, processing time: " + (end - start));
        if (logger.isTraceEnabled()) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DOMUtils.writeXml((Node)docToSign.getDocumentElement(), (OutputStream)bos);
                logger.trace("Signed message:\n" + bos.toString());
            }
            catch (TransformerException e) {
                logger.fatal("", e);
            }
        }
    }

    public Set<QName> getUnderstoodHeaders() {
        return qnameSet;
    }

    private Vector<WSEncryptionPart> getElementsToBeSigned(Document docToSign) {
        if (this.partsDecider != null) {
            return this.partsDecider.getElementsToBeSigned(docToSign);
        }
        Vector<WSEncryptionPart> toBeSigned = new Vector<WSEncryptionPart>();
        toBeSigned.add(new WSEncryptionPart("Body", "http://schemas.xmlsoap.org/soap/envelope/", ""));
        return toBeSigned;
    }

    static {
        qnameSet.add(WS_SECURITY);
    }

    private static class MyWSSecSignature
    extends WSSecSignature {
        private MyWSSecSignature() {
        }

        public List<String> getInclusivePrefixes(Element target, boolean excludeVisible) {
            if (target.getLocalName().equals("Security")) {
                String ns = target.getNamespaceURI();
                if (ns == null) {
                    return super.getInclusivePrefixes(target, excludeVisible);
                }
                if (target.getNamespaceURI().equals(DSigOutHandler.WSS_NS_STRING)) {
                    NodeList nl = target.getElementsByTagName("SignedInfo");
                    if (nl.getLength() == 0) {
                        return Collections.emptyList();
                    }
                    return super.getInclusivePrefixes((Element)nl.item(0), excludeVisible);
                }
            }
            return super.getInclusivePrefixes(target, excludeVisible);
        }
    }
}

