/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.rsync;

import eu.unicore.uftp.rsync.Checksum;

public class RollingChecksum {
    private long lastX;
    private long lastA;
    private long lastB;
    private long lastK;
    private long lastL;

    public long init(byte[] data) {
        return this.reset(data, 0L, data.length - 1);
    }

    public long reset(byte[] data, long k, long l) {
        this.lastX = data[0] & 0xFF;
        this.lastK = k;
        this.lastL = l;
        this.lastA = Checksum.a(data);
        this.lastB = Checksum.b(data, k, l);
        return Checksum.sum(this.lastA, this.lastB);
    }

    public long update(long k, long l, byte X_k, byte X_l) {
        if (k == 0L || k != this.lastK + 1L || l != this.lastL + 1L) {
            throw new IllegalStateException();
        }
        this.lastA = this.lastA - this.lastX + (long)(X_l & 0xFF) & 0xFFFFL;
        this.lastB = this.lastB - (l - k + 1L) * this.lastX + this.lastA & 0xFFFFL;
        ++this.lastK;
        ++this.lastL;
        this.lastX = X_k & 0xFF;
        return Checksum.sum(this.lastA, this.lastB);
    }
}

