/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.deployment;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.ServiceBuilder;
import org.apache.axis2.deployment.ServiceGroupBuilder;
import org.apache.axis2.deployment.repository.util.ArchiveReader;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.FaultyServiceData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.wso2.carbon.utils.IOStreamUtils;
import org.wso2.carbon.utils.deployment.BundleClassLoader;

public class Axis2ServiceRegistry {
    private static Log log = LogFactory.getLog(Axis2ServiceRegistry.class);
    private ConfigurationContext configCtx;
    private AxisConfiguration axisConfig;
    private Map<Bundle, List<AxisServiceGroup>> serviceGroupMap;
    private static String componentsDirPath;

    public Axis2ServiceRegistry(ConfigurationContext configCtx) {
        this.configCtx = configCtx;
        this.axisConfig = configCtx.getAxisConfiguration();
        this.serviceGroupMap = new ConcurrentHashMap<Bundle, List<AxisServiceGroup>>();
    }

    public void register(Bundle[] bundles) {
        for (Bundle bundle : bundles) {
            if (bundle.getState() != 32) continue;
            this.register(bundle);
        }
        this.logFaultyServiceInfo();
    }

    public void register(Bundle bundle) {
        try {
            this.addServices(bundle);
        }
        catch (Throwable e) {
            String msg = "Error while adding services from bundle : " + bundle.getSymbolicName() + "-" + bundle.getVersion();
            log.error((Object)msg, e);
        }
    }

    public void unregister(Bundle bundle) {
        try {
            List<AxisServiceGroup> axisServiceGroupList = this.serviceGroupMap.get(bundle);
            if (axisServiceGroupList != null) {
                for (AxisServiceGroup axisServiceGroup : axisServiceGroupList) {
                    try {
                        this.axisConfig.removeServiceGroup(axisServiceGroup.getServiceGroupName());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Stopping" + axisServiceGroup.getServiceGroupName() + " service group in Bundle - " + bundle.getSymbolicName()));
                        }
                        Iterator iterator = axisServiceGroup.getServices();
                        while (iterator.hasNext()) {
                            AxisService service = (AxisService)iterator.next();
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Service - " + service.getName()));
                        }
                    }
                    catch (AxisFault e) {
                        String msg = "Error while removing services from bundle : " + bundle.getBundleId();
                        log.error((Object)msg, (Throwable)e);
                    }
                }
                this.serviceGroupMap.remove(bundle);
            }
        }
        catch (Exception e) {
            String msg = "Error while unregistering  bundle : " + bundle.getBundleId();
            log.error((Object)msg, (Throwable)e);
        }
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        switch (event.getType()) {
            case 2: {
                this.register(bundle);
                break;
            }
            case 4: {
                this.unregister(bundle);
            }
        }
    }

    private void addServices(Bundle bundle) {
        if (!this.serviceGroupMap.containsKey(bundle)) {
            Enumeration enumeration = bundle.findEntries("META-INF", "*services.xml", true);
            ArrayList<AxisServiceGroup> axisServiceGroupList = null;
            if (enumeration != null) {
                axisServiceGroupList = new ArrayList<AxisServiceGroup>();
            }
            while (enumeration != null && enumeration.hasMoreElements()) {
                try {
                    BundleClassLoader loader = new BundleClassLoader(bundle, Axis2ServiceRegistry.class.getClassLoader());
                    URL url = (URL)enumeration.nextElement();
                    AxisServiceGroup serviceGroup = new AxisServiceGroup(this.axisConfig);
                    Dictionary headers = bundle.getHeaders();
                    String bundleSymbolicName = (String)headers.get("Bundle-SymbolicName");
                    serviceGroup.setServiceGroupName(bundleSymbolicName);
                    serviceGroup.addParameter("bundleId", (Object)bundle.getBundleId());
                    serviceGroup.addParameter("last.updated", (Object)bundle.getLastModified());
                    serviceGroup.setServiceGroupClassLoader((ClassLoader)loader);
                    InputStream inputStream = url.openStream();
                    DescriptionBuilder builder = new DescriptionBuilder(inputStream, this.configCtx);
                    OMElement rootElement = builder.buildOM();
                    String elementName = rootElement.getLocalName();
                    HashMap wsdlServicesMap = this.processWSDL(bundle);
                    if (wsdlServicesMap != null && wsdlServicesMap.size() > 0) {
                        for (AxisService service : wsdlServicesMap.values()) {
                            Iterator operations = service.getOperations();
                            while (operations.hasNext()) {
                                AxisOperation axisOperation = (AxisOperation)operations.next();
                                this.axisConfig.getPhasesInfo().setOperationPhases(axisOperation);
                            }
                        }
                    }
                    if ("service".equals(elementName)) {
                        AxisService axisService = new AxisService(bundleSymbolicName);
                        axisService.setParent(serviceGroup);
                        axisService.setClassLoader((ClassLoader)loader);
                        ServiceBuilder serviceBuilder = new ServiceBuilder(this.configCtx, axisService);
                        serviceBuilder.setWsdlServiceMap(wsdlServicesMap);
                        AxisService service = serviceBuilder.populateService(rootElement);
                        ArrayList<AxisService> serviceList = new ArrayList<AxisService>();
                        serviceList.add(service);
                        DeploymentEngine.addServiceGroup((AxisServiceGroup)serviceGroup, serviceList, null, null, (AxisConfiguration)this.axisConfig);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Deployed axis2 service:" + service.getName() + " in Bundle: " + bundle.getSymbolicName()));
                        }
                    } else if ("serviceGroup".equals(elementName)) {
                        ServiceGroupBuilder groupBuilder = new ServiceGroupBuilder(rootElement, wsdlServicesMap, this.configCtx);
                        ArrayList serviceList = groupBuilder.populateServiceGroup(serviceGroup);
                        DeploymentEngine.addServiceGroup((AxisServiceGroup)serviceGroup, (ArrayList)serviceList, null, null, (AxisConfiguration)this.axisConfig);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Deployed axis2 service group:" + serviceGroup.getServiceGroupName() + " in Bundle: " + bundle.getSymbolicName()));
                        }
                    }
                    axisServiceGroupList.add(serviceGroup);
                }
                catch (Exception e) {
                    String msg = "Error building service from bundle : Symbolic Name: " + bundle.getSymbolicName() + ",Bundle Version: " + bundle.getVersion() + ", ID: " + bundle.getBundleId();
                    log.error((Object)msg, (Throwable)e);
                }
            }
            if (axisServiceGroupList != null && axisServiceGroupList.size() > 0) {
                this.serviceGroupMap.put(bundle, axisServiceGroupList);
            }
        }
    }

    private HashMap processWSDL(Bundle bundle) throws IOException, XMLStreamException {
        File bundleFile;
        Enumeration enumeration = bundle.findEntries("META-INF", "*.wsdl", true);
        if (enumeration == null) {
            return new HashMap();
        }
        String bundleLocation = bundle.getLocation();
        if (bundleLocation.startsWith("reference:")) {
            bundleLocation = bundleLocation.substring("reference:".length());
        }
        String[] subStrings = bundleLocation.split("/");
        String bundleFileName = subStrings[subStrings.length - 1];
        URL bundleURL = new URL(bundleLocation);
        if (bundleURL.getProtocol().equals("file")) {
            bundleFile = new File(bundleURL.getFile());
        } else {
            InputStream bundleStream = bundleURL.openStream();
            String tempBundleDirPath = System.getProperty("java.io.tmpdir") + File.separator + "bundles";
            File tempBundleDir = new File(tempBundleDirPath);
            if (!tempBundleDir.exists() && !tempBundleDir.mkdir()) {
                log.warn((Object)("Could not create temp bundle directory " + tempBundleDir.getAbsolutePath()));
                return new HashMap();
            }
            bundleFile = new File(tempBundleDirPath, bundleFileName);
            FileOutputStream bundleFileOutputSteam = new FileOutputStream(bundleFile);
            IOStreamUtils.copyInputStream(bundleStream, bundleFileOutputSteam);
        }
        if (!bundleFile.exists()) {
            bundleFile = new File(componentsDirPath + File.separator + bundleURL.getFile());
        }
        if (!bundleFile.exists()) {
            return new HashMap();
        }
        DeploymentFileData deploymentFileData = new DeploymentFileData(bundleFile);
        ArchiveReader archiveReader = new ArchiveReader();
        return archiveReader.processWSDLs(deploymentFileData);
    }

    public void logFaultyServiceInfo() {
        Map faultyServices = this.axisConfig.getFaultyServicesDuetoModules();
        if (faultyServices != null && !faultyServices.isEmpty()) {
            for (Map.Entry moduleEntry : faultyServices.entrySet()) {
                Map faultyServicesDueToModule = (Map)moduleEntry.getValue();
                for (Map.Entry entry : faultyServicesDueToModule.entrySet()) {
                    AxisServiceGroup serviceGroup = ((FaultyServiceData)entry.getValue()).getServiceGroup();
                    if (serviceGroup.getParameter("bundleId") == null) continue;
                    log.warn((Object)("Service :" + serviceGroup.getServiceGroupName() + " is faulty, due to unavailability of the module :" + (String)moduleEntry.getKey()));
                }
            }
        }
    }

    static {
        String carbonRepo = System.getenv("CARBON_REPOSITORY");
        if (carbonRepo == null) {
            carbonRepo = System.getProperty("carbon.repository");
        }
        if (carbonRepo == null) {
            carbonRepo = System.getProperty("carbon.home") + File.separator + "repository";
        }
        componentsDirPath = carbonRepo + File.separator + "components";
    }
}

