/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.AbstractSqmSpecificPluralPartPath;
import org.hibernate.query.sqm.tree.domain.SqmPath;

public class SqmElementAggregateFunction<T>
extends AbstractSqmSpecificPluralPartPath<T> {
    private final String functionName;

    public SqmElementAggregateFunction(SqmPath<?> pluralDomainPath, String functionName) {
        super(pluralDomainPath.getNavigablePath().getParent().append(pluralDomainPath.getNavigablePath().getLocalName(), "{" + functionName + "-element}"), pluralDomainPath, (PluralPersistentAttribute)pluralDomainPath.getReferencedPathSource(), ((PluralPersistentAttribute)pluralDomainPath.getReferencedPathSource()).getElementPathSource());
        this.functionName = functionName;
    }

    @Override
    public SqmElementAggregateFunction<T> copy(SqmCopyContext context) {
        SqmElementAggregateFunction existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmElementAggregateFunction<T> path = context.registerCopy(this, new SqmElementAggregateFunction<T>((SqmPath<?>)this.getLhs().copy(context), this.functionName));
        this.copyTo(path, context);
        return path;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public SqmPath<?> resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        JpaPath sqmPath = this.get(name);
        creationState.getProcessingStateStack().getCurrent().getPathRegistry().register((SqmPath<?>)sqmPath);
        return sqmPath;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitElementAggregateFunction(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append(this.functionName).append("(");
        this.getLhs().appendHqlString(sb);
        sb.append(')');
    }
}

