/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.distcp2;

import java.io.IOException;
import java.net.URI;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.tools.distcp2.CopyListing;
import org.apache.hadoop.tools.distcp2.DistCpOptions;
import org.apache.hadoop.tools.distcp2.OptionsParser;
import org.apache.hadoop.tools.distcp2.mapred.CopyMapper;
import org.apache.hadoop.tools.distcp2.mapred.CopyOutputFormat;
import org.apache.hadoop.tools.distcp2.util.DistCpUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class DistCp
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(DistCp.class);
    private DistCpOptions inputOptions;
    private Path metaFolder;
    private static final String PREFIX = "_distcp";
    private static final String WIP_PREFIX = "._WIP_";
    private static final String DISTCP_DEFAULT_XML = "distcp-default.xml";
    public static final Random rand = new Random();
    private boolean submitted;
    private FileSystem jobFS;

    public DistCp(Configuration configuration, DistCpOptions inputOptions) throws Exception {
        JobConf config = new JobConf(configuration);
        config.addResource(DISTCP_DEFAULT_XML);
        this.setConf(config);
        this.inputOptions = inputOptions;
        this.metaFolder = this.createMetaFolderPath();
    }

    private DistCp() {
    }

    @Override
    public int run(String[] argv) {
        if (argv.length < 1) {
            OptionsParser.usage();
            return -1;
        }
        try {
            this.inputOptions = OptionsParser.parse(argv);
            LOG.info("Input Options: " + this.inputOptions);
        }
        catch (Throwable e) {
            LOG.error("Invalid arguments: ", e);
            System.err.println("Invalid arguments: " + e.getMessage());
            OptionsParser.usage();
            return -1;
        }
        try {
            this.execute();
        }
        catch (CopyListing.InvalidInputException e) {
            LOG.error("Invalid input: ", e);
            return -1;
        }
        catch (CopyListing.DuplicateFileException e) {
            LOG.error("Duplicate files in input path: ", e);
            return -2;
        }
        catch (Exception e) {
            LOG.error("Exception encountered ", e);
            return -999;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job execute() throws Exception {
        assert (this.inputOptions != null);
        assert (this.getConf() != null);
        Job job = null;
        try {
            DistCp distCp = this;
            synchronized (distCp) {
                this.metaFolder = this.createMetaFolderPath();
                this.jobFS = this.metaFolder.getFileSystem(this.getConf());
                job = this.createJob();
            }
            this.createInputFileListing(job);
            job.submit();
            this.submitted = true;
        }
        finally {
            if (!this.submitted) {
                this.cleanup();
            }
        }
        String jobID = job.getJobID().toString();
        job.getConfiguration().set("distcp.job.id", jobID);
        LOG.info("DistCp job-id: " + jobID);
        if (this.inputOptions.shouldBlock()) {
            job.waitForCompletion(true);
        }
        return job;
    }

    private Job createJob() throws IOException {
        String jobName = "distcp";
        Job job = Job.getInstance(this.getConf());
        String userChosenName = job.getJobName();
        if (userChosenName != null) {
            jobName = jobName + ": " + userChosenName;
        }
        job.setJobName(jobName);
        job.setInputFormatClass(DistCpUtils.getStrategy(this.getConf(), this.inputOptions));
        job.setJarByClass(CopyMapper.class);
        this.configureOutputFormat(job);
        job.setMapperClass(CopyMapper.class);
        job.setNumReduceTasks(0);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Text.class);
        job.setOutputFormatClass(CopyOutputFormat.class);
        job.setSpeculativeExecution(false);
        ((JobConf)job.getConfiguration()).setNumMapTasks(this.inputOptions.getMaxMaps());
        if (this.inputOptions.getSslConfigurationFile() != null) {
            this.setupSSLConfig(job);
        }
        this.inputOptions.appendToConf(job.getConfiguration());
        return job;
    }

    private void setupSSLConfig(Job job) throws IOException {
        Configuration configuration = job.getConfiguration();
        Path sslConfigPath = new Path(configuration.getResource(this.inputOptions.getSslConfigurationFile()).toString());
        this.addSSLFilesToDistCache(job, sslConfigPath);
        configuration.set("distcp.keystore.resource", sslConfigPath.getName());
        configuration.set("dfs.https.client.keystore.resource", sslConfigPath.getName());
    }

    private void addSSLFilesToDistCache(Job job, Path sslConfigPath) throws IOException {
        Configuration configuration = job.getConfiguration();
        LocalFileSystem localFS = FileSystem.getLocal(configuration);
        Configuration sslConf = new Configuration(false);
        sslConf.addResource(sslConfigPath);
        Path localStorePath = this.getLocalStorePath(sslConf, "ssl.client.truststore.location");
        DistCp.addCacheFile(job, localStorePath.makeQualified(((FileSystem)localFS).getUri(), ((FileSystem)localFS).getWorkingDirectory()).toUri());
        configuration.set("ssl.client.truststore.location", localStorePath.getName());
        localStorePath = this.getLocalStorePath(sslConf, "ssl.client.keystore.location");
        DistCp.addCacheFile(job, localStorePath.makeQualified(((FileSystem)localFS).getUri(), ((FileSystem)localFS).getWorkingDirectory()).toUri());
        configuration.set("ssl.client.keystore.location", localStorePath.getName());
        DistCp.addCacheFile(job, sslConfigPath.makeQualified(((FileSystem)localFS).getUri(), ((FileSystem)localFS).getWorkingDirectory()).toUri());
    }

    private static void addCacheFile(Job job, URI uri) {
        DistributedCache.addCacheFile(uri, job.getConfiguration());
    }

    private Path getLocalStorePath(Configuration sslConf, String storeKey) throws IOException {
        if (sslConf.get(storeKey) != null) {
            return new Path(sslConf.get(storeKey));
        }
        throw new IOException("Store for " + storeKey + " is not set in " + this.inputOptions.getSslConfigurationFile());
    }

    private void configureOutputFormat(Job job) throws IOException {
        Configuration configuration = job.getConfiguration();
        Path targetPath = this.inputOptions.getTargetPath();
        FileSystem targetFS = targetPath.getFileSystem(configuration);
        targetPath = targetPath.makeQualified(targetFS.getUri(), targetFS.getWorkingDirectory());
        if (this.inputOptions.shouldAtomicCommit()) {
            FileSystem workFS;
            Path workDir = this.inputOptions.getAtomicWorkPath();
            if (workDir == null) {
                workDir = targetPath.getParent();
            }
            if (!DistCpUtils.compareFs(targetFS, workFS = (workDir = new Path(workDir, WIP_PREFIX + targetPath.getName() + rand.nextInt())).getFileSystem(configuration))) {
                throw new IllegalArgumentException("Work path " + workDir + " and target path " + targetPath + " are in different file system");
            }
            CopyOutputFormat.setWorkingDirectory(job, workDir);
        } else {
            CopyOutputFormat.setWorkingDirectory(job, targetPath);
        }
        CopyOutputFormat.setCommitDirectory(job, targetPath);
        Path logPath = this.inputOptions.getLogPath();
        if (logPath == null) {
            logPath = new Path(this.metaFolder, "_logs");
        } else {
            LOG.info("DistCp job log path: " + logPath);
        }
        CopyOutputFormat.setOutputPath(job, logPath);
    }

    protected Path createInputFileListing(Job job) throws IOException {
        Path fileListingPath = this.getFileListingPath();
        CopyListing copyListing = CopyListing.getCopyListing(job.getConfiguration(), job.getCredentials(), this.inputOptions);
        copyListing.buildListing(fileListingPath, this.inputOptions);
        return fileListingPath;
    }

    protected Path getFileListingPath() throws IOException {
        String fileListPathStr = this.metaFolder + "/fileList.seq";
        Path path = new Path(fileListPathStr);
        return new Path(path.toUri().normalize().toString());
    }

    private Path createMetaFolderPath() throws Exception {
        JobConf configuration = (JobConf)this.getConf();
        Path stagingDir = JobSubmissionFiles.getStagingDir(new JobClient(configuration), configuration);
        Path metaFolderPath = new Path(stagingDir, PREFIX + String.valueOf(rand.nextInt()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Meta folder location: " + metaFolderPath);
        }
        configuration.set("distcp.meta.folder", metaFolderPath.toString());
        return metaFolderPath;
    }

    public static void main(String[] argv) {
        try {
            DistCp distCp = new DistCp();
            Cleanup CLEANUP = new Cleanup(distCp);
            Runtime.getRuntime().addShutdownHook(CLEANUP);
            System.exit(ToolRunner.run(DistCp.getDefaultConf(), distCp, argv));
        }
        catch (Exception e) {
            LOG.error("Couldn't complete DistCp operation: ", e);
            System.exit(-999);
        }
    }

    private static JobConf getDefaultConf() {
        JobConf config = new JobConf();
        config.addResource(DISTCP_DEFAULT_XML);
        return config;
    }

    private synchronized void cleanup() {
        try {
            if (this.metaFolder == null) {
                return;
            }
            this.jobFS.delete(this.metaFolder, true);
            this.metaFolder = null;
        }
        catch (IOException e) {
            LOG.error("Unable to cleanup meta folder: " + this.metaFolder, e);
        }
    }

    private boolean isSubmitted() {
        return this.submitted;
    }

    private static class Cleanup
    extends Thread {
        private final DistCp distCp;

        public Cleanup(DistCp distCp) {
            this.distCp = distCp;
        }

        @Override
        public void run() {
            if (this.distCp.isSubmitted()) {
                return;
            }
            this.distCp.cleanup();
        }
    }
}

