/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.arrow.vector.ipc.message;

import org.apache.arrow.vector.types.MetadataVersion;

/** IPC options, now only use for write. */
public class IpcOption {

  // Write the pre-0.15.0 encapsulated IPC message format
  // consisting of a 4-byte prefix instead of 8 byte
  public final boolean write_legacy_ipc_format;

  // The metadata version. Defaults to V5.
  public final MetadataVersion metadataVersion;

  public IpcOption() {
    this(false, MetadataVersion.DEFAULT);
  }

  public IpcOption(boolean writeLegacyIpcFormat, MetadataVersion metadataVersion) {
    this.write_legacy_ipc_format = writeLegacyIpcFormat;
    this.metadataVersion = metadataVersion;
  }

  public static final IpcOption DEFAULT = new IpcOption();
}
