/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.win;

import org.apache.hyracks.algebricks.data.IBinaryBooleanInspector;
import org.apache.hyracks.algebricks.data.IBinaryBooleanInspectorFactory;
import org.apache.hyracks.algebricks.data.IBinaryIntegerInspector;
import org.apache.hyracks.algebricks.data.IBinaryIntegerInspectorFactory;
import org.apache.hyracks.algebricks.runtime.base.IRunningAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.operators.win.AbstractWindowNestedPlansPushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.win.WindowAggregatorDescriptorFactory;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.DataUtils;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.PointableTupleReference;
import org.apache.hyracks.storage.common.MultiComparator;

class WindowNestedPlansPushRuntime
extends AbstractWindowNestedPlansPushRuntime {
    private static final int PARTITION_POSITION_SLOT = 0;
    private static final int FRAME_POSITION_SLOT = 1;
    private static final int TMP_POSITION_SLOT = 2;
    private static final int PARTITION_READER_SLOT_COUNT = 3;
    private final boolean frameValueExists;
    private final IScalarEvaluatorFactory[] frameValueEvalFactories;
    private IScalarEvaluator[] frameValueEvals;
    private PointableTupleReference frameValuePointables;
    private final IBinaryComparatorFactory[] frameValueComparatorFactories;
    private MultiComparator frameValueComparators;
    private final boolean frameStartExists;
    private final IScalarEvaluatorFactory[] frameStartEvalFactories;
    private IScalarEvaluator[] frameStartEvals;
    private PointableTupleReference frameStartPointables;
    private final boolean frameStartValidationExists;
    private final IScalarEvaluatorFactory[] frameStartValidationEvalFactories;
    private IScalarEvaluator[] frameStartValidationEvals;
    private PointableTupleReference frameStartValidationPointables;
    private final boolean frameStartIsMonotonic;
    private final boolean frameEndExists;
    private final IScalarEvaluatorFactory[] frameEndEvalFactories;
    private IScalarEvaluator[] frameEndEvals;
    private PointableTupleReference frameEndPointables;
    private final boolean frameEndValidationExists;
    private final IScalarEvaluatorFactory[] frameEndValidationEvalFactories;
    private IScalarEvaluator[] frameEndValidationEvals;
    private PointableTupleReference frameEndValidationPointables;
    private final boolean frameExcludeExists;
    private final IScalarEvaluatorFactory[] frameExcludeEvalFactories;
    private IScalarEvaluator[] frameExcludeEvals;
    private final int frameExcludeNegationStartIdx;
    private PointableTupleReference frameExcludePointables;
    private final IBinaryComparatorFactory[] frameExcludeComparatorFactories;
    private IBinaryComparator[] frameExcludeComparators;
    private final boolean frameExcludeUnaryExists;
    private final IScalarEvaluatorFactory frameExcludeUnaryEvalFactory;
    private IScalarEvaluator frameExcludeUnaryEval;
    private final boolean frameOffsetExists;
    private final IScalarEvaluatorFactory frameOffsetEvalFactory;
    private IScalarEvaluator frameOffsetEval;
    private final int frameMaxObjects;
    private final IBinaryBooleanInspectorFactory booleanAccessorFactory;
    private IBinaryBooleanInspector booleanAccessor;
    private final IBinaryIntegerInspectorFactory integerAccessorFactory;
    private IBinaryIntegerInspector integerAccessor;
    private IPointable tmpPointable;
    private FrameTupleAccessor tAccess2;
    private FrameTupleReference tRef2;
    private int chunkIdxFrameStartGlobal;
    private int tBeginIdxFrameStartGlobal;

    WindowNestedPlansPushRuntime(int[] partitionColumns, IBinaryComparatorFactory[] partitionComparatorFactories, IBinaryComparatorFactory[] orderComparatorFactories, IScalarEvaluatorFactory[] frameValueEvalFactories, IBinaryComparatorFactory[] frameValueComparatorFactories, IScalarEvaluatorFactory[] frameStartEvalFactories, IScalarEvaluatorFactory[] frameStartValidationEvalFactories, boolean frameStartIsMonotonic, IScalarEvaluatorFactory[] frameEndEvalFactories, IScalarEvaluatorFactory[] frameEndValidationEvalFactories, IScalarEvaluatorFactory[] frameExcludeEvalFactories, int frameExcludeNegationStartIdx, IBinaryComparatorFactory[] frameExcludeComparatorFactories, IScalarEvaluatorFactory frameExcludeUnaryEvalFactory, IScalarEvaluatorFactory frameOffsetEvalFactory, int frameMaxObjects, IBinaryBooleanInspectorFactory booleanAccessorFactory, IBinaryIntegerInspectorFactory integerAccessorFactory, int[] projectionColumns, int[] runningAggOutColumns, IRunningAggregateEvaluatorFactory[] runningAggFactories, int nestedAggOutSchemaSize, WindowAggregatorDescriptorFactory nestedAggFactory, IHyracksTaskContext ctx, int memSizeInFrames, SourceLocation sourceLoc) {
        super(partitionColumns, partitionComparatorFactories, orderComparatorFactories, projectionColumns, runningAggOutColumns, runningAggFactories, nestedAggOutSchemaSize, nestedAggFactory, ctx, memSizeInFrames, sourceLoc);
        this.frameValueEvalFactories = frameValueEvalFactories;
        this.frameValueExists = frameValueEvalFactories != null && frameValueEvalFactories.length > 0;
        this.frameStartEvalFactories = frameStartEvalFactories;
        this.frameStartExists = frameStartEvalFactories != null && frameStartEvalFactories.length > 0;
        this.frameStartValidationEvalFactories = frameStartValidationEvalFactories;
        this.frameStartValidationExists = frameStartValidationEvalFactories != null && frameStartValidationEvalFactories.length > 0;
        this.frameStartIsMonotonic = this.frameStartExists && frameStartIsMonotonic;
        this.frameEndEvalFactories = frameEndEvalFactories;
        this.frameEndExists = frameEndEvalFactories != null && frameEndEvalFactories.length > 0;
        this.frameEndValidationEvalFactories = frameEndValidationEvalFactories;
        this.frameEndValidationExists = frameEndValidationEvalFactories != null && frameEndValidationEvalFactories.length > 0;
        this.frameValueComparatorFactories = frameValueComparatorFactories;
        this.frameExcludeEvalFactories = frameExcludeEvalFactories;
        this.frameExcludeExists = frameExcludeEvalFactories != null && frameExcludeEvalFactories.length > 0;
        this.frameExcludeComparatorFactories = frameExcludeComparatorFactories;
        this.frameExcludeNegationStartIdx = frameExcludeNegationStartIdx;
        this.frameExcludeUnaryExists = frameExcludeUnaryEvalFactory != null;
        this.frameExcludeUnaryEvalFactory = frameExcludeUnaryEvalFactory;
        this.frameOffsetExists = frameOffsetEvalFactory != null;
        this.frameOffsetEvalFactory = frameOffsetEvalFactory;
        this.frameMaxObjects = frameMaxObjects;
        this.booleanAccessorFactory = booleanAccessorFactory;
        this.integerAccessorFactory = integerAccessorFactory;
    }

    @Override
    protected void init() throws HyracksDataException {
        super.init();
        if (this.frameValueExists) {
            this.frameValueEvals = WindowNestedPlansPushRuntime.createEvaluators(this.frameValueEvalFactories, this.ctx);
            this.frameValueComparators = MultiComparator.create((IBinaryComparatorFactory[])this.frameValueComparatorFactories);
            this.frameValuePointables = PointableTupleReference.create((int)this.frameValueEvalFactories.length, (IPointableFactory)VoidPointable.FACTORY);
        }
        if (this.frameStartExists) {
            this.frameStartEvals = WindowNestedPlansPushRuntime.createEvaluators(this.frameStartEvalFactories, this.ctx);
            this.frameStartPointables = PointableTupleReference.create((int)this.frameStartEvalFactories.length, (IPointableFactory)VoidPointable.FACTORY);
        }
        if (this.frameStartValidationExists) {
            this.frameStartValidationEvals = WindowNestedPlansPushRuntime.createEvaluators(this.frameStartValidationEvalFactories, this.ctx);
            this.frameStartValidationPointables = PointableTupleReference.create((int)this.frameStartValidationEvalFactories.length, (IPointableFactory)VoidPointable.FACTORY);
        }
        if (this.frameEndExists) {
            this.frameEndEvals = WindowNestedPlansPushRuntime.createEvaluators(this.frameEndEvalFactories, this.ctx);
            this.frameEndPointables = PointableTupleReference.create((int)this.frameEndEvalFactories.length, (IPointableFactory)VoidPointable.FACTORY);
        }
        if (this.frameEndValidationExists) {
            this.frameEndValidationEvals = WindowNestedPlansPushRuntime.createEvaluators(this.frameEndValidationEvalFactories, this.ctx);
            this.frameEndValidationPointables = PointableTupleReference.create((int)this.frameEndValidationEvalFactories.length, (IPointableFactory)VoidPointable.FACTORY);
        }
        if (this.frameExcludeExists) {
            this.frameExcludeEvals = WindowNestedPlansPushRuntime.createEvaluators(this.frameExcludeEvalFactories, this.ctx);
            this.frameExcludeComparators = WindowNestedPlansPushRuntime.createBinaryComparators(this.frameExcludeComparatorFactories);
            this.frameExcludePointables = PointableTupleReference.create((int)this.frameExcludeEvalFactories.length, (IPointableFactory)VoidPointable.FACTORY);
        }
        if (this.frameExcludeUnaryExists) {
            this.frameExcludeUnaryEval = this.frameExcludeUnaryEvalFactory.createScalarEvaluator(this.ctx);
        }
        if (this.frameOffsetExists) {
            this.frameOffsetEval = this.frameOffsetEvalFactory.createScalarEvaluator(this.ctx);
        }
        if (this.frameExcludeExists || this.frameExcludeUnaryExists || this.frameOffsetExists) {
            this.tmpPointable = VoidPointable.FACTORY.createPointable();
        }
        if (this.frameStartValidationExists || this.frameEndValidationExists || this.frameExcludeUnaryExists) {
            this.booleanAccessor = this.booleanAccessorFactory.createBinaryBooleanInspector(this.ctx.getTaskContext());
        }
        if (this.frameOffsetExists) {
            this.integerAccessor = this.integerAccessorFactory.createBinaryIntegerInspector(this.ctx.getTaskContext());
        }
        this.tAccess2 = new FrameTupleAccessor(this.inputRecordDesc);
        this.tRef2 = new FrameTupleReference();
    }

    @Override
    protected void beginPartitionImpl() throws HyracksDataException {
        super.beginPartitionImpl();
        this.chunkIdxFrameStartGlobal = -1;
        this.tBeginIdxFrameStartGlobal = -1;
    }

    @Override
    protected void producePartitionTuples(int chunkIdx, IFrame chunkFrame) throws HyracksDataException {
        this.partitionReader.savePosition(0);
        int nChunks = this.getPartitionChunkCount();
        boolean isFirstChunkInPartition = chunkIdx == 0;
        this.tAccess.reset(chunkFrame.getBuffer());
        int tBeginIdx = this.getTupleBeginIdx(chunkIdx);
        int tEndIdx = this.getTupleEndIdx(chunkIdx);
        for (int tIdx = tBeginIdx; tIdx <= tEndIdx; ++tIdx) {
            boolean isFirstTupleInPartition = isFirstChunkInPartition && tIdx == tBeginIdx;
            this.tRef.reset((IFrameTupleAccessor)this.tAccess, tIdx);
            this.produceTuple(this.tupleBuilder, (IFrameTupleAccessor)this.tAccess, tIdx, this.tRef);
            this.nestedAggInit();
            boolean frameValid = true;
            if (this.frameStartExists) {
                if (this.frameStartValidationExists) {
                    WindowNestedPlansPushRuntime.evaluate(this.frameStartValidationEvals, (IFrameTupleReference)this.tRef, this.frameStartValidationPointables);
                    frameValid = WindowNestedPlansPushRuntime.allTrue((ITupleReference)this.frameStartValidationPointables, this.booleanAccessor);
                }
                if (frameValid) {
                    WindowNestedPlansPushRuntime.evaluate(this.frameStartEvals, (IFrameTupleReference)this.tRef, this.frameStartPointables);
                }
            }
            if (frameValid && this.frameEndExists) {
                if (this.frameEndValidationExists) {
                    WindowNestedPlansPushRuntime.evaluate(this.frameEndValidationEvals, (IFrameTupleReference)this.tRef, this.frameEndValidationPointables);
                    frameValid = WindowNestedPlansPushRuntime.allTrue((ITupleReference)this.frameEndValidationPointables, this.booleanAccessor);
                }
                if (frameValid) {
                    WindowNestedPlansPushRuntime.evaluate(this.frameEndEvals, (IFrameTupleReference)this.tRef, this.frameEndPointables);
                }
            }
            int toSkip = 0;
            if (frameValid && this.frameOffsetExists) {
                this.frameOffsetEval.evaluate((IFrameTupleReference)this.tRef, this.tmpPointable);
                toSkip = this.integerAccessor.getIntegerValue(this.tmpPointable.getByteArray(), this.tmpPointable.getStartOffset(), this.tmpPointable.getLength());
                boolean bl = frameValid = toSkip >= 0;
            }
            if (frameValid) {
                int tBeginIdxInnerStart;
                if (this.frameExcludeExists) {
                    WindowNestedPlansPushRuntime.evaluate(this.frameExcludeEvals, (IFrameTupleReference)this.tRef, this.frameExcludePointables);
                }
                int toWrite = this.frameMaxObjects;
                boolean frameStartForward = this.frameStartIsMonotonic && this.chunkIdxFrameStartGlobal >= 0;
                int chunkIdxInnerStart = frameStartForward ? this.chunkIdxFrameStartGlobal : 0;
                int n = tBeginIdxInnerStart = frameStartForward ? this.tBeginIdxFrameStartGlobal : -1;
                if (chunkIdxInnerStart < nChunks) {
                    if (frameStartForward && !isFirstTupleInPartition) {
                        this.partitionReader.restorePosition(1);
                    } else {
                        this.partitionReader.rewind();
                    }
                }
                int chunkIdxFrameStartLocal = -1;
                int tBeginIdxFrameStartLocal = -1;
                block1: for (int chunkIdxInner = chunkIdxInnerStart; chunkIdxInner < nChunks; ++chunkIdxInner) {
                    int tBeginIdxInner;
                    this.partitionReader.savePosition(2);
                    IFrame frameInner = this.partitionReader.nextFrame(false);
                    this.tAccess2.reset(frameInner.getBuffer());
                    if (tBeginIdxInnerStart < 0) {
                        tBeginIdxInner = this.getTupleBeginIdx(chunkIdxInner);
                    } else {
                        tBeginIdxInner = tBeginIdxInnerStart;
                        tBeginIdxInnerStart = -1;
                    }
                    int tEndIdxInner = this.getTupleEndIdx(chunkIdxInner);
                    for (int tIdxInner = tBeginIdxInner; tIdxInner <= tEndIdxInner; ++tIdxInner) {
                        this.tRef2.reset((IFrameTupleAccessor)this.tAccess2, tIdxInner);
                        if (this.frameStartExists || this.frameEndExists) {
                            WindowNestedPlansPushRuntime.evaluate(this.frameValueEvals, (IFrameTupleReference)this.tRef2, this.frameValuePointables);
                            if (this.frameStartExists) {
                                if (this.frameValueComparators.compare((ITupleReference)this.frameValuePointables, (ITupleReference)this.frameStartPointables) < 0) continue;
                                if (chunkIdxFrameStartLocal < 0) {
                                    chunkIdxFrameStartLocal = chunkIdxInner;
                                    tBeginIdxFrameStartLocal = tIdxInner;
                                    this.partitionReader.copyPosition(2, 1);
                                }
                            }
                            if (this.frameEndExists && this.frameValueComparators.compare((ITupleReference)this.frameValuePointables, (ITupleReference)this.frameEndPointables) > 0) break block1;
                        }
                        if (this.frameExcludeExists && this.isExcluded() || this.frameExcludeUnaryExists && this.isExcludedUnary()) continue;
                        if (toSkip > 0) {
                            --toSkip;
                            continue;
                        }
                        if (toWrite != 0) {
                            this.nestedAggAggregate(this.tAccess2, tIdxInner);
                        }
                        if (toWrite > 0) {
                            --toWrite;
                        }
                        if (toWrite == 0) break block1;
                    }
                }
                if (this.frameStartIsMonotonic) {
                    if (chunkIdxFrameStartLocal >= 0) {
                        this.chunkIdxFrameStartGlobal = chunkIdxFrameStartLocal;
                        this.tBeginIdxFrameStartGlobal = tBeginIdxFrameStartLocal;
                    } else {
                        this.chunkIdxFrameStartGlobal = nChunks;
                        this.tBeginIdxFrameStartGlobal = 0;
                    }
                }
            }
            this.nestedAggOutputFinalResult(this.tupleBuilder);
            this.appendToFrameFromTupleBuilder(this.tupleBuilder);
        }
        this.partitionReader.restorePosition(0);
    }

    private boolean isExcluded() throws HyracksDataException {
        for (int i = 0; i < this.frameExcludeEvals.length; ++i) {
            boolean b;
            this.frameExcludeEvals[i].evaluate((IFrameTupleReference)this.tRef2, this.tmpPointable);
            boolean bl = b = DataUtils.compare((IValueReference)this.frameExcludePointables.getField(i), (IValueReference)this.tmpPointable, (IBinaryComparator)this.frameExcludeComparators[i]) != 0;
            if (i >= this.frameExcludeNegationStartIdx) {
                boolean bl2 = b = !b;
            }
            if (!b) continue;
            return false;
        }
        return true;
    }

    private boolean isExcludedUnary() throws HyracksDataException {
        this.frameExcludeUnaryEval.evaluate((IFrameTupleReference)this.tRef2, this.tmpPointable);
        return this.booleanAccessor.getBooleanValue(this.tmpPointable.getByteArray(), this.tmpPointable.getStartOffset(), this.tmpPointable.getLength());
    }

    @Override
    protected int getPartitionReaderSlotCount() {
        return 3;
    }
}

