/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.partitions;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hyracks.api.channels.IInputChannel;
import org.apache.hyracks.api.channels.IInputChannelMonitor;
import org.apache.hyracks.api.comm.IFrameReader;
import org.apache.hyracks.api.comm.IPartitionCollector;
import org.apache.hyracks.api.comm.PartitionChannel;
import org.apache.hyracks.api.context.IHyracksCommonContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ConnectorDescriptorId;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.partitions.PartitionId;
import org.apache.hyracks.control.nc.partitions.MaterializedPartitionInputChannel;
import org.apache.hyracks.control.nc.partitions.MaterializedPartitionWriter;
import org.apache.hyracks.control.nc.partitions.PartitionManager;

public class ReceiveSideMaterializingCollector
implements IPartitionCollector {
    private final IHyracksTaskContext ctx;
    private PartitionManager manager;
    private final IPartitionCollector delegate;
    private final TaskAttemptId taId;
    private final Executor executor;

    public ReceiveSideMaterializingCollector(IHyracksTaskContext ctx, PartitionManager manager, IPartitionCollector collector, TaskAttemptId taId, Executor executor) {
        this.ctx = ctx;
        this.manager = manager;
        this.delegate = collector;
        this.taId = taId;
        this.executor = executor;
    }

    public JobId getJobId() {
        return this.delegate.getJobId();
    }

    public ConnectorDescriptorId getConnectorId() {
        return this.delegate.getConnectorId();
    }

    public int getReceiverIndex() {
        return this.delegate.getReceiverIndex();
    }

    public void open() throws HyracksException {
        this.delegate.open();
    }

    public void addPartitions(Collection<PartitionChannel> partitions) throws HyracksException {
        for (PartitionChannel pc : partitions) {
            PartitionWriter writer = new PartitionWriter(pc);
            this.executor.execute(writer);
        }
    }

    public IFrameReader getReader() throws HyracksException {
        return this.delegate.getReader();
    }

    public void close() throws HyracksException {
        this.delegate.close();
    }

    public Collection<PartitionId> getRequiredPartitionIds() throws HyracksException {
        return this.delegate.getRequiredPartitionIds();
    }

    public void abort() {
        this.delegate.abort();
    }

    private class PartitionWriter
    implements Runnable,
    IInputChannelMonitor {
        private PartitionChannel pc;
        private final AtomicInteger nAvailableFrames;
        private final AtomicBoolean eos;
        private final AtomicBoolean failed;

        public PartitionWriter(PartitionChannel pc) {
            this.pc = pc;
            this.nAvailableFrames = new AtomicInteger(0);
            this.eos = new AtomicBoolean(false);
            this.failed = new AtomicBoolean(false);
        }

        public synchronized void notifyFailure(IInputChannel channel, int errorCode) {
            this.failed.set(true);
            this.notifyAll();
        }

        public synchronized void notifyDataAvailability(IInputChannel channel, int nFrames) {
            this.nAvailableFrames.addAndGet(nFrames);
            this.notifyAll();
        }

        public synchronized void notifyEndOfStream(IInputChannel channel) {
            this.eos.set(true);
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PartitionId pid = this.pc.getPartitionId();
            MaterializedPartitionWriter mpw = new MaterializedPartitionWriter(ReceiveSideMaterializingCollector.this.ctx, ReceiveSideMaterializingCollector.this.manager, pid, ReceiveSideMaterializingCollector.this.taId, ReceiveSideMaterializingCollector.this.executor);
            IInputChannel channel = this.pc.getInputChannel();
            try {
                channel.registerMonitor((IInputChannelMonitor)this);
                channel.open((IHyracksCommonContext)ReceiveSideMaterializingCollector.this.ctx);
                mpw.open();
                while (true) {
                    Object buffer;
                    if (this.nAvailableFrames.get() > 0) {
                        buffer = channel.getNextBuffer();
                        this.nAvailableFrames.decrementAndGet();
                        mpw.nextFrame((ByteBuffer)buffer);
                        channel.recycleBuffer((ByteBuffer)buffer);
                        continue;
                    }
                    if (this.eos.get()) break;
                    if (this.failed.get()) {
                        mpw.fail();
                        continue;
                    }
                    try {
                        buffer = this;
                        synchronized (buffer) {
                            if (this.nAvailableFrames.get() <= 0 && !this.eos.get() && !this.failed.get()) {
                                this.wait();
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        throw HyracksDataException.create((Throwable)e);
                    }
                }
                mpw.close();
                channel.close();
                ReceiveSideMaterializingCollector.this.delegate.addPartitions(Collections.singleton(new PartitionChannel(pid, (IInputChannel)new MaterializedPartitionInputChannel(1, pid, ReceiveSideMaterializingCollector.this.manager))));
            }
            catch (HyracksException hyracksException) {
                // empty catch block
            }
        }
    }
}

