/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.file;

import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParser;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParserFactory;
import org.apache.hyracks.dataflow.std.file.FieldCursorForDelimitedDataParser;
import org.apache.hyracks.dataflow.std.file.ITupleParser;
import org.apache.hyracks.dataflow.std.file.ITupleParserFactory;

public class DelimitedDataTupleParserFactory
implements ITupleParserFactory {
    private static final long serialVersionUID = 1L;
    private IValueParserFactory[] valueParserFactories;
    private char fieldDelimiter;
    private char quote;

    public DelimitedDataTupleParserFactory(IValueParserFactory[] fieldParserFactories, char fieldDelimiter) {
        this(fieldParserFactories, fieldDelimiter, '\"');
    }

    public DelimitedDataTupleParserFactory(IValueParserFactory[] fieldParserFactories, char fieldDelimiter, char quote) {
        this.valueParserFactories = fieldParserFactories;
        this.fieldDelimiter = fieldDelimiter;
        this.quote = quote;
    }

    @Override
    public ITupleParser createTupleParser(final IHyracksTaskContext ctx) {
        return new ITupleParser(){
            final IWarningCollector warningCollector;
            {
                this.warningCollector = ctx.getWarningCollector();
            }

            @Override
            public void parse(InputStream in, IFrameWriter writer) throws HyracksDataException {
                try {
                    IValueParser[] valueParsers = new IValueParser[DelimitedDataTupleParserFactory.this.valueParserFactories.length];
                    for (int i = 0; i < DelimitedDataTupleParserFactory.this.valueParserFactories.length; ++i) {
                        valueParsers[i] = DelimitedDataTupleParserFactory.this.valueParserFactories[i].createValueParser();
                    }
                    VSizeFrame frame = new VSizeFrame((IHyracksFrameMgrContext)ctx);
                    FrameTupleAppender appender = new FrameTupleAppender();
                    appender.reset((IFrame)frame, true);
                    ArrayTupleBuilder tb = new ArrayTupleBuilder(valueParsers.length);
                    DataOutput dos = tb.getDataOutput();
                    FieldCursorForDelimitedDataParser cursor = new FieldCursorForDelimitedDataParser(new InputStreamReader(in), DelimitedDataTupleParserFactory.this.fieldDelimiter, DelimitedDataTupleParserFactory.this.quote, this.warningCollector, () -> "");
                    while (cursor.nextRecord()) {
                        tb.reset();
                        for (int i = 0; i < valueParsers.length; ++i) {
                            FieldCursorForDelimitedDataParser.Result result = cursor.nextField();
                            switch (result) {
                                case OK: {
                                    break;
                                }
                                case END: 
                                case ERROR: {
                                    throw new HyracksDataException("Failed to parse record");
                                }
                                default: {
                                    throw new IllegalStateException();
                                }
                            }
                            if (cursor.fieldHasDoubleQuote()) {
                                cursor.eliminateDoubleQuote();
                            }
                            if (!valueParsers[i].parse(cursor.getBuffer(), cursor.getFieldStart(), cursor.getFieldLength(), dos)) {
                                throw new HyracksDataException("Failed to parse field");
                            }
                            tb.addFieldEndOffset();
                        }
                        FrameUtils.appendToWriter((IFrameWriter)writer, (IFrameTupleAppender)appender, (int[])tb.getFieldEndOffsets(), (byte[])tb.getByteArray(), (int)0, (int)tb.getSize());
                    }
                    appender.write(writer, true);
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }
        };
    }
}

