/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.nc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.replication.IPartitionReplica;
import org.apache.asterix.common.storage.IReplicaManager;
import org.apache.asterix.common.storage.ReplicaIdentifier;
import org.apache.asterix.common.transactions.IRecoveryManager;
import org.apache.asterix.replication.api.PartitionReplica;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.hyracks.api.client.NodeStatus;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.storage.common.LocalResource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplicaManager
implements IReplicaManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final INcApplicationContext appCtx;
    private final Map<Integer, Object> partitions = new HashMap<Integer, Object>();
    private final Map<ReplicaIdentifier, PartitionReplica> replicas = new HashMap<ReplicaIdentifier, PartitionReplica>();
    private final Set<Integer> nodeOriginatedPartitions = new HashSet<Integer>();

    public ReplicaManager(INcApplicationContext appCtx, Set<Integer> partitions) {
        this.appCtx = appCtx;
        for (Integer partition : partitions) {
            this.partitions.put(partition, new Object());
        }
        this.setNodeOriginatedPartitions(appCtx);
    }

    public synchronized void addReplica(ReplicaIdentifier id) {
        NodeControllerService controllerService = (NodeControllerService)this.appCtx.getServiceContext().getControllerService();
        NodeStatus nodeStatus = controllerService.getNodeStatus();
        if (nodeStatus != NodeStatus.ACTIVE) {
            LOGGER.warn("Ignoring request to add replica. Node is not ACTIVE yet. Current status: {}", (Object)nodeStatus);
            return;
        }
        if (!this.partitions.containsKey(id.getPartition())) {
            throw new IllegalStateException("This node is not the current master of partition(" + id.getPartition() + ")");
        }
        if (this.isSelf(id)) {
            LOGGER.info("ignoring request to add replica to ourselves");
            return;
        }
        this.replicas.computeIfAbsent(id, k -> new PartitionReplica(k, this.appCtx));
        this.replicas.get(id).sync();
    }

    public synchronized void removeReplica(ReplicaIdentifier id) {
        if (!this.replicas.containsKey(id)) {
            throw new IllegalStateException("replica with id(" + id + ") does not exist");
        }
        PartitionReplica replica = this.replicas.remove(id);
        this.appCtx.getReplicationManager().unregister((IPartitionReplica)replica);
    }

    public synchronized List<IPartitionReplica> getReplicas(int partition) {
        return this.replicas.entrySet().stream().filter(e -> ((ReplicaIdentifier)e.getKey()).getPartition() == partition).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public synchronized IPartitionReplica getReplica(ReplicaIdentifier id) {
        return (IPartitionReplica)this.replicas.get(id);
    }

    public synchronized Set<Integer> getPartitions() {
        return Collections.unmodifiableSet(this.partitions.keySet());
    }

    public synchronized void setActivePartitions(Set<Integer> activePartitions) {
        this.partitions.clear();
        for (Integer partition : activePartitions) {
            this.partitions.put(partition, new Object());
        }
    }

    public synchronized void promote(int partition) throws HyracksDataException {
        if (this.partitions.containsKey(partition)) {
            return;
        }
        LOGGER.warn("promoting partition {}", (Object)partition);
        PersistentLocalResourceRepository localResourceRepository = (PersistentLocalResourceRepository)this.appCtx.getLocalResourceRepository();
        if (!this.appCtx.isCloudDeployment()) {
            localResourceRepository.cleanup(partition);
            IRecoveryManager recoveryManager = this.appCtx.getTransactionSubsystem().getRecoveryManager();
            recoveryManager.replayReplicaPartitionLogs(Stream.of(Integer.valueOf(partition)).collect(Collectors.toSet()), true);
        }
        this.partitions.put(partition, new Object());
    }

    public synchronized void release(int partition) throws HyracksDataException {
        if (!this.partitions.containsKey(partition)) {
            return;
        }
        this.closePartitionResources(partition);
        List<IPartitionReplica> partitionReplicas = this.getReplicas(partition);
        for (IPartitionReplica replica : partitionReplicas) {
            this.appCtx.getReplicationManager().unregister(replica);
        }
        this.partitions.remove(partition);
    }

    public synchronized Object getPartitionSyncLock(int partition) {
        Object syncLock = this.partitions.get(partition);
        if (syncLock == null) {
            throw new IllegalStateException("partition " + partition + " is not active on this node");
        }
        return syncLock;
    }

    public synchronized List<IPartitionReplica> getReplicas() {
        return new ArrayList<PartitionReplica>(this.replicas.values());
    }

    public boolean isPartitionOrigin(int partition) {
        return this.nodeOriginatedPartitions.contains(partition);
    }

    public void closePartitionResources(int partition) throws HyracksDataException {
        IDatasetLifecycleManager datasetLifecycleManager = this.appCtx.getDatasetLifecycleManager();
        datasetLifecycleManager.flushAllDatasets(p -> p == partition);
        PersistentLocalResourceRepository resourceRepository = (PersistentLocalResourceRepository)this.appCtx.getLocalResourceRepository();
        Map partitionResources = resourceRepository.getPartitionResources(partition);
        for (LocalResource resource : partitionResources.values()) {
            datasetLifecycleManager.closeIfOpen(resource.getPath());
        }
        datasetLifecycleManager.closePartition(partition);
    }

    private boolean isSelf(ReplicaIdentifier id) {
        String nodeId = this.appCtx.getServiceContext().getNodeId();
        return id.getNodeId().equals(nodeId);
    }

    private void setNodeOriginatedPartitions(INcApplicationContext appCtx) {
        Set nodePartitions = appCtx.getMetadataProperties().getNodePartitions(appCtx.getServiceContext().getNodeId());
        this.nodeOriginatedPartitions.addAll(nodePartitions);
    }
}

