/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractComplexType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.IATypeVisitor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;

public class AUnionType
extends AbstractComplexType {
    private static final long serialVersionUID = 1L;
    private static final int OPTIONAL_TYPE_INDEX_IN_UNION_LIST = 0;
    private static final String UNION_LIST_FIELD = "unionList";
    private final List<IAType> unionList;

    public AUnionType(List<IAType> unionList, String typeName) {
        super(typeName);
        this.unionList = unionList;
    }

    public List<IAType> getUnionList() {
        return this.unionList;
    }

    public boolean isMissableType() {
        return this.containsType(BuiltinType.AMISSING);
    }

    public boolean isNullableType() {
        return this.containsType(BuiltinType.ANULL);
    }

    public boolean isUnknownableType() {
        return this.isMissableType() || this.isNullableType();
    }

    @Override
    public boolean containsType(IAType type) {
        for (int index = 0; index < this.unionList.size(); ++index) {
            if (this.unionList.get(index) == null || !this.unionList.get(index).equals(type)) continue;
            return true;
        }
        return false;
    }

    public IAType getType(ATypeTag typeTag) {
        for (int i = 0; i < this.unionList.size(); ++i) {
            IAType type = this.unionList.get(i);
            if (typeTag != type.getTypeTag()) continue;
            return type;
        }
        return null;
    }

    public IAType getActualType() {
        return this.unionList.get(0);
    }

    public void setActualType(IAType type) {
        if (0 < this.unionList.size()) {
            this.unionList.set(0, type);
        } else {
            this.unionList.add(type);
        }
    }

    public static IAType createMissableType(IAType type, String typeName) {
        if (type != null && type.getTypeTag() == ATypeTag.MISSING) {
            return type;
        }
        ArrayList<IAType> unionList = new ArrayList<IAType>();
        if (type != null && type.getTypeTag() == ATypeTag.UNION) {
            AUnionType unionType = (AUnionType)type;
            unionList.addAll(unionType.getUnionList());
        } else {
            unionList.add(type);
        }
        unionList.add(BuiltinType.AMISSING);
        return new AUnionType(unionList, typeName);
    }

    public static IAType createMissableType(IAType t) {
        if (t != null && t.getTypeTag() == ATypeTag.MISSING) {
            return t;
        }
        String s = t != null ? t.getTypeName() : null;
        return AUnionType.createMissableType(t, s == null ? null : s + "?");
    }

    public static IAType createNullableType(IAType t) {
        if (t != null && t.getTypeTag() == ATypeTag.NULL) {
            return t;
        }
        String s = t != null ? t.getTypeName() : null;
        return AUnionType.createNullableType(t, s == null ? null : s + "?");
    }

    public static IAType createNullableType(IAType type, String typeName) {
        if (type != null && type.getTypeTag() == ATypeTag.NULL) {
            return type;
        }
        ArrayList<IAType> unionList = new ArrayList<IAType>();
        if (type != null && type.getTypeTag() == ATypeTag.UNION) {
            AUnionType unionType = (AUnionType)type;
            unionList.addAll(unionType.getUnionList());
        } else {
            unionList.add(type);
        }
        unionList.add(BuiltinType.ANULL);
        return new AUnionType(unionList, typeName);
    }

    public static IAType createUnknownableType(IAType type, String typeName) {
        IAType resultType = AUnionType.createNullableType(type, typeName);
        resultType = AUnionType.createMissableType(resultType, typeName);
        return resultType;
    }

    public static IAType createUnknownableType(IAType t) {
        String s = t != null ? t.getTypeName() : null;
        return AUnionType.createUnknownableType(t, s == null ? null : s + "?");
    }

    @Override
    public String getDisplayName() {
        return "union";
    }

    @Override
    public ATypeTag getTypeTag() {
        return ATypeTag.UNION;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("union(");
        Iterator<IAType> iter = this.unionList.iterator();
        if (iter.hasNext()) {
            IAType t0 = iter.next();
            sb.append(t0.toString());
            while (iter.hasNext()) {
                sb.append(", " + iter.next());
            }
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public IAType getType() {
        return BuiltinType.ALL_TYPE;
    }

    @Override
    public void generateNestedDerivedTypeNames() {
        IAType nullableType;
        if (this.isUnknownableType() && (nullableType = this.getActualType()).getTypeTag().isDerivedType() && nullableType.getTypeName() == null) {
            AbstractComplexType derivedType = (AbstractComplexType)nullableType;
            derivedType.setTypeName(this.getTypeName());
            derivedType.generateNestedDerivedTypeNames();
        }
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        if (!(obj instanceof AUnionType)) {
            return false;
        }
        AUnionType ut = (AUnionType)obj;
        if (ut.getUnionList().size() != this.unionList.size()) {
            return false;
        }
        for (int i = 0; i < this.unionList.size(); ++i) {
            if (this.unionList.get(i).deepEqual(ut.getUnionList().get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hash() {
        int h = 0;
        for (IAType t : this.unionList) {
            h += 31 * h + t.hash();
        }
        return h;
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode type = om.createObjectNode();
        type.put("type", AUnionType.class.getName());
        ArrayNode fields = om.createArrayNode();
        Iterator<IAType> iter = this.unionList.iterator();
        if (iter.hasNext()) {
            IAType t0 = iter.next();
            fields.add((JsonNode)t0.toJSON());
            while (iter.hasNext()) {
                fields.add((JsonNode)iter.next().toJSON());
            }
        }
        type.set("fields", (JsonNode)fields);
        return type;
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        ObjectNode jsonObject = registry.getClassIdentifier(this.getClass(), 1L);
        this.addToJson(jsonObject);
        ArrayNode fieldTypesArray = OBJECT_MAPPER.createArrayNode();
        for (int i = 0; i < this.unionList.size(); ++i) {
            fieldTypesArray.add(this.unionList.get(i).toJson(registry));
        }
        jsonObject.set(UNION_LIST_FIELD, (JsonNode)fieldTypesArray);
        return jsonObject;
    }

    @Override
    public <R, T> R accept(IATypeVisitor<R, T> visitor, T arg) {
        return visitor.visit(this, arg);
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) throws HyracksDataException {
        String typeName = json.get("typeName").asText();
        ArrayNode unionListJson = (ArrayNode)json.get(UNION_LIST_FIELD);
        ArrayList<IAType> unionList = new ArrayList<IAType>();
        for (int i = 0; i < unionListJson.size(); ++i) {
            unionList.add((IAType)registry.deserialize(unionListJson.get(i)));
        }
        return new AUnionType(unionList, typeName);
    }
}

