/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.TypePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.properties.VariablePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypeEnvPointer;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.typing.PropagatingTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class NestedTupleSourceOperator
extends AbstractLogicalOperator {
    private Mutable<ILogicalOperator> dataSourceReference;

    public NestedTupleSourceOperator(Mutable<ILogicalOperator> dataSourceReference) {
        this.dataSourceReference = dataSourceReference;
    }

    public ILogicalOperator getSourceOperator() {
        return (ILogicalOperator)((ILogicalOperator)this.dataSourceReference.getValue()).getInputs().get(0).getValue();
    }

    @Override
    public LogicalOperatorTag getOperatorTag() {
        return LogicalOperatorTag.NESTEDTUPLESOURCE;
    }

    public Mutable<ILogicalOperator> getDataSourceReference() {
        return this.dataSourceReference;
    }

    public void setDataSourceReference(Mutable<ILogicalOperator> dataSourceReference) {
        this.dataSourceReference = dataSourceReference;
    }

    @Override
    public void recomputeSchema() {
        this.schema = new ArrayList();
        ILogicalOperator topOp = (ILogicalOperator)this.dataSourceReference.getValue();
        for (Mutable<ILogicalOperator> i : topOp.getInputs()) {
            List<LogicalVariable> inputSchema = ((ILogicalOperator)i.getValue()).getSchema();
            if (inputSchema == null) continue;
            this.schema.addAll(inputSchema);
        }
    }

    @Override
    public VariablePropagationPolicy getVariablePropagationPolicy() {
        return VariablePropagationPolicy.ALL;
    }

    @Override
    public boolean acceptExpressionTransform(ILogicalExpressionReferenceTransform visitor) {
        return false;
    }

    @Override
    public <R, T> R accept(ILogicalOperatorVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitNestedTupleSourceOperator(this, arg);
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public IVariableTypeEnvironment computeOutputTypeEnvironment(final ITypingContext ctx) throws AlgebricksException {
        ITypeEnvPointer[] p = new ITypeEnvPointer[]{new ITypeEnvPointer(){

            @Override
            public IVariableTypeEnvironment getTypeEnv() {
                ILogicalOperator op = (ILogicalOperator)((ILogicalOperator)NestedTupleSourceOperator.this.dataSourceReference.getValue()).getInputs().get(0).getValue();
                return ctx.getOutputTypeEnvironment(op);
            }
        }};
        return new PropagatingTypeEnvironment(ctx.getExpressionTypeComputer(), ctx.getMissableTypeComputer(), ctx.getMetadataProvider(), TypePropagationPolicy.ALL, p);
    }

    @Override
    public IVariableTypeEnvironment computeInputTypeEnvironment(ITypingContext ctx) throws AlgebricksException {
        return this.computeOutputTypeEnvironment(ctx);
    }
}

