/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.prefetch;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.impl.prefetch.BlockData;
import org.apache.hadoop.fs.impl.prefetch.BlockManager;
import org.apache.hadoop.fs.impl.prefetch.BufferData;
import org.apache.hadoop.fs.impl.prefetch.ExecutorServiceFuturePool;
import org.apache.hadoop.fs.impl.prefetch.FilePosition;
import org.apache.hadoop.fs.s3a.S3AInputStream;
import org.apache.hadoop.fs.s3a.S3AReadOpContext;
import org.apache.hadoop.fs.s3a.S3ObjectAttributes;
import org.apache.hadoop.fs.s3a.prefetch.S3ACachingBlockManager;
import org.apache.hadoop.fs.s3a.prefetch.S3ARemoteInputStream;
import org.apache.hadoop.fs.s3a.prefetch.S3ARemoteObjectReader;
import org.apache.hadoop.fs.s3a.statistics.S3AInputStreamStatistics;
import org.apache.hadoop.fs.statistics.DurationTracker;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ACachingInputStream
extends S3ARemoteInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(S3ACachingInputStream.class);
    private final int numBlocksToPrefetch = this.getContext().getPrefetchBlockCount();
    private final BlockManager blockManager;

    public S3ACachingInputStream(S3AReadOpContext context, S3ObjectAttributes s3Attributes, S3AInputStream.InputStreamCallbacks client, S3AInputStreamStatistics streamStatistics, Configuration conf, LocalDirAllocator localDirAllocator) {
        super(context, s3Attributes, client, streamStatistics);
        int bufferPoolSize = this.numBlocksToPrefetch + 1;
        this.blockManager = this.createBlockManager(this.getContext().getFuturePool(), this.getReader(), this.getBlockData(), bufferPoolSize, conf, localDirAllocator);
        int fileSize = (int)s3Attributes.getLen();
        LOG.debug("Created caching input stream for {} (size = {})", (Object)this.getName(), (Object)fileSize);
    }

    @Override
    public void close() throws IOException {
        this.blockManager.close();
        super.close();
        LOG.info("closed: {}", (Object)this.getName());
    }

    @Override
    protected boolean ensureCurrentBuffer() throws IOException {
        int prefetchCount;
        boolean outOfOrderRead;
        if (this.isClosed()) {
            return false;
        }
        long readPos = this.getNextReadPos();
        if (!this.getBlockData().isValidOffset(readPos)) {
            return false;
        }
        FilePosition filePosition = this.getFilePosition();
        boolean bl = outOfOrderRead = !filePosition.setAbsolute(readPos);
        if (!outOfOrderRead && filePosition.buffer().hasRemaining()) {
            return true;
        }
        if (filePosition.isValid()) {
            if (filePosition.bufferFullyRead()) {
                this.blockManager.release(filePosition.data());
            } else {
                this.blockManager.requestCaching(filePosition.data());
            }
            filePosition.invalidate();
        }
        if (outOfOrderRead) {
            LOG.debug("lazy-seek({})", (Object)this.getOffsetStr(readPos));
            this.blockManager.cancelPrefetches();
            prefetchCount = 1;
        } else {
            prefetchCount = this.numBlocksToPrefetch;
        }
        int toBlockNumber = this.getBlockData().getBlockNumber(readPos);
        long startOffset = this.getBlockData().getStartOffset(toBlockNumber);
        for (int i = 1; i <= prefetchCount; ++i) {
            int b = toBlockNumber + i;
            if (b >= this.getBlockData().getNumBlocks()) continue;
            this.blockManager.requestPrefetch(b);
        }
        BufferData data = (BufferData)IOStatisticsBinding.invokeTrackingDuration((DurationTracker)this.getS3AStreamStatistics().trackDuration("stream_read_block_acquire_read"), () -> this.blockManager.get(toBlockNumber));
        filePosition.setData(data, startOffset, readPos);
        return true;
    }

    @Override
    public String toString() {
        if (this.isClosed()) {
            return "closed";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s%n", super.toString()));
        sb.append(this.blockManager.toString());
        return sb.toString();
    }

    protected BlockManager createBlockManager(ExecutorServiceFuturePool futurePool, S3ARemoteObjectReader reader, BlockData blockData, int bufferPoolSize, Configuration conf, LocalDirAllocator localDirAllocator) {
        return new S3ACachingBlockManager(futurePool, reader, blockData, bufferPoolSize, this.getS3AStreamStatistics(), conf, localDirAllocator);
    }
}

