/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import org.apache.asterix.common.annotations.TypeDataGen;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.asterix.lang.common.base.AbstractStatement;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.expression.TypeExpression;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public class TypeDecl
extends AbstractStatement {
    private final Namespace namespace;
    private final Identifier ident;
    private final TypeExpression typeDef;
    private final TypeDataGen datagenAnnotation;
    private final boolean ifNotExists;

    public TypeDecl(Namespace namespace, Identifier ident, TypeExpression typeDef, TypeDataGen datagen, boolean ifNotExists) {
        this.namespace = namespace;
        this.ident = ident;
        this.typeDef = typeDef;
        this.datagenAnnotation = datagen;
        this.ifNotExists = ifNotExists;
    }

    public Identifier getIdent() {
        return this.ident;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public DataverseName getDataverseName() {
        return this.namespace == null ? null : this.namespace.getDataverseName();
    }

    public TypeExpression getTypeDef() {
        return this.typeDef;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    public Statement.Kind getKind() {
        return Statement.Kind.TYPE_DECL;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public TypeDataGen getDatagenAnnotation() {
        return this.datagenAnnotation;
    }

    @Override
    public byte getCategory() {
        return 4;
    }
}

