/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.writer;

import org.apache.hyracks.algebricks.runtime.base.IPushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.writer.SinkExternalWriterRuntime;
import org.apache.hyracks.algebricks.runtime.writers.IExternalWriter;
import org.apache.hyracks.algebricks.runtime.writers.IExternalWriterFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public final class SinkExternalWriterRuntimeFactory
extends AbstractPushRuntimeFactory {
    private static final long serialVersionUID = -2215789207336628581L;
    private final int sourceColumn;
    private final int[] partitionColumn;
    private final IBinaryComparatorFactory[] partitionComparatorFactories;
    private final RecordDescriptor inputRecordDescriptor;
    private final IExternalWriterFactory writerFactory;

    public SinkExternalWriterRuntimeFactory(int sourceColumn, int[] partitionColumn, IBinaryComparatorFactory[] partitionComparatorFactories, RecordDescriptor inputRecordDescriptor, IExternalWriterFactory writerFactory) {
        this.sourceColumn = sourceColumn;
        this.partitionColumn = partitionColumn;
        this.partitionComparatorFactories = partitionComparatorFactories;
        this.inputRecordDescriptor = inputRecordDescriptor;
        this.writerFactory = writerFactory;
    }

    @Override
    public IPushRuntime[] createPushRuntime(IHyracksTaskContext ctx) throws HyracksDataException {
        IExternalWriter writer = this.writerFactory.createWriter(ctx);
        IBinaryComparator[] partitionComparators = new IBinaryComparator[this.partitionComparatorFactories.length];
        for (int i = 0; i < this.partitionComparatorFactories.length; ++i) {
            partitionComparators[i] = this.partitionComparatorFactories[i].createBinaryComparator();
        }
        SinkExternalWriterRuntime runtime = new SinkExternalWriterRuntime(this.sourceColumn, this.partitionColumn, partitionComparators, this.inputRecordDescriptor, writer);
        return new IPushRuntime[]{runtime};
    }
}

