/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.bitwise;

import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.functions.AbstractScalarEval;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

abstract class AbstractBitMultipleValuesEvaluator
extends AbstractScalarEval {
    private final AMutableInt64 resultMutableInt64 = new AMutableInt64(0L);
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final IScalarEvaluator[] argEvaluators;
    private final IPointable[] argPointables;
    private final ISerializerDeserializer aInt64Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
    private final IEvaluatorContext context;

    AbstractBitMultipleValuesEvaluator(IEvaluatorContext context, IScalarEvaluatorFactory[] argEvaluatorFactories, FunctionIdentifier functionIdentifier, SourceLocation sourceLocation) throws HyracksDataException {
        super(sourceLocation, functionIdentifier);
        this.context = context;
        this.argPointables = new IPointable[argEvaluatorFactories.length];
        this.argEvaluators = new IScalarEvaluator[argEvaluatorFactories.length];
        for (int i = 0; i < argEvaluatorFactories.length; ++i) {
            this.argEvaluators[i] = argEvaluatorFactories[i].createScalarEvaluator(context);
            this.argPointables[i] = new VoidPointable();
        }
    }

    abstract long applyBitwiseOperation(long var1, long var3);

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        int startOffset;
        boolean isReturnNull = false;
        for (int i = 0; i < this.argEvaluators.length; ++i) {
            this.argEvaluators[i].evaluate(tuple, this.argPointables[i]);
            if (!PointableHelper.checkAndSetMissingOrNull(result, this.argPointables[i])) continue;
            if (result.getByteArray()[result.getStartOffset()] == ATypeTag.SERIALIZED_MISSING_TYPE_TAG) {
                return;
            }
            isReturnNull = true;
        }
        if (isReturnNull) {
            PointableHelper.setNull(result);
            return;
        }
        byte[] bytes = this.argPointables[0].getByteArray();
        if (!PointableHelper.isValidLongValue(bytes, startOffset = this.argPointables[0].getStartOffset(), true)) {
            ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.context, (SourceLocation)this.srcLoc, (FunctionIdentifier)this.funID, (byte)bytes[startOffset], (int)0, (ATypeTag)ATypeTag.BIGINT);
            PointableHelper.setNull(result);
            return;
        }
        long longResult = ATypeHierarchy.getLongValue((String)this.funID.getName(), (int)0, (byte[])bytes, (int)startOffset);
        for (int i = 1; i < this.argPointables.length; ++i) {
            bytes = this.argPointables[i].getByteArray();
            if (!PointableHelper.isValidLongValue(bytes, startOffset = this.argPointables[i].getStartOffset(), true)) {
                ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.context, (SourceLocation)this.srcLoc, (FunctionIdentifier)this.funID, (byte)bytes[startOffset], (int)i, (ATypeTag)ATypeTag.BIGINT);
                PointableHelper.setNull(result);
                return;
            }
            long nextValue = ATypeHierarchy.getLongValue((String)this.funID.getName(), (int)i, (byte[])bytes, (int)startOffset);
            longResult = this.applyBitwiseOperation(longResult, nextValue);
        }
        this.resultStorage.reset();
        this.resultMutableInt64.setValue(longResult);
        this.aInt64Serde.serialize((Object)this.resultMutableInt64, this.resultStorage.getDataOutput());
        result.set((IValueReference)this.resultStorage);
    }
}

