/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.cbo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.asterix.common.annotations.IndexedNLJoinExpressionAnnotation;
import org.apache.asterix.common.annotations.SkipSecondaryIndexSearchExpressionAnnotation;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.metadata.declared.DatasetDataSource;
import org.apache.asterix.metadata.declared.SampleDataSource;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.optimizer.cost.Cost;
import org.apache.asterix.optimizer.cost.ICost;
import org.apache.asterix.optimizer.rules.am.AccessMethodAnalysisContext;
import org.apache.asterix.optimizer.rules.am.IAccessMethod;
import org.apache.asterix.optimizer.rules.am.IOptimizableFuncExpr;
import org.apache.asterix.optimizer.rules.am.IntroduceJoinAccessMethodRule;
import org.apache.asterix.optimizer.rules.am.IntroduceSelectAccessMethodRule;
import org.apache.asterix.optimizer.rules.cbo.EnumerateJoinsRule;
import org.apache.asterix.optimizer.rules.cbo.JoinCondition;
import org.apache.asterix.optimizer.rules.cbo.JoinEnum;
import org.apache.asterix.optimizer.rules.cbo.JoinOperator;
import org.apache.asterix.optimizer.rules.cbo.PlanNode;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Quadruple;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.BroadcastExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.HashJoinExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.PredicateCardinalityAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.plan.ALogicalPlanImpl;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JoinNode {
    private static final Logger LOGGER = LogManager.getLogger();
    protected JoinEnum joinEnum;
    protected int jnArrayIndex;
    protected int datasetBits;
    protected List<Integer> datasetIndexes;
    protected List<String> datasetNames;
    protected List<String> aliases;
    protected int cheapestPlanIndex;
    private ICost cheapestPlanCost;
    protected double origCardinality;
    protected double cardinality;
    protected double size;
    protected double diskProjectionSize;
    protected double projectionSizeAfterScan;
    protected double distinctCardinality;
    protected List<Integer> planIndexesArray;
    protected int jnIndex;
    protected int level;
    protected int highestDatasetId;
    private JoinNode rightJn;
    private JoinNode leftJn;
    private int limitVal = -1;
    private List<Integer> applicableJoinConditions;
    protected ILogicalOperator leafInput;
    protected Index.SampleIndexDetails idxDetails;
    private List<Triple<Index, Double, AbstractFunctionCallExpression>> IndexCostInfo;
    protected static int NO_JN = -1;
    private static int NO_CARDS = -2;
    private int numVarsFromDisk = -1;
    private int numVarsAfterScan = -1;
    private double sizeVarsFromDisk = -1.0;
    private double sizeVarsAfterScan = -1.0;
    private boolean columnar = true;

    private JoinNode(int i) {
        this.jnArrayIndex = i;
        this.planIndexesArray = new ArrayList<Integer>();
        this.cheapestPlanIndex = PlanNode.NO_PLAN;
        this.size = 1.0;
    }

    protected JoinNode(int i, JoinEnum joinE) {
        this(i);
        this.joinEnum = joinE;
        this.cheapestPlanCost = this.joinEnum.getCostHandle().maxCost();
    }

    protected boolean IsBaseLevelJoinNode() {
        return this.jnArrayIndex <= this.joinEnum.numberOfTerms;
    }

    protected boolean IsHigherLevelJoinNode() {
        return !this.IsBaseLevelJoinNode();
    }

    public double getCardinality() {
        return this.cardinality;
    }

    protected void setCardinality(double card, boolean setMinCard) {
        this.cardinality = setMinCard ? Math.max(card, 2.1) : card;
    }

    public double getOrigCardinality() {
        return this.origCardinality;
    }

    protected void setOrigCardinality(double card, boolean setMinCard) {
        this.origCardinality = setMinCard ? Math.max(card, 2.1) : card;
    }

    public void setAvgDocSize(double avgDocSize) {
        this.size = avgDocSize;
    }

    public double getAvgDocSize() {
        return this.size;
    }

    public void setLimitVal(int val) {
        this.limitVal = val;
    }

    public int getLimitVal() {
        return this.limitVal;
    }

    public double getInputSize() {
        return this.sizeVarsFromDisk;
    }

    public double getOutputSize() {
        return this.sizeVarsAfterScan;
    }

    public JoinNode getLeftJn() {
        return this.leftJn;
    }

    public JoinNode getRightJn() {
        return this.rightJn;
    }

    private List<String> getAliases() {
        return this.aliases;
    }

    protected List<String> getDatasetNames() {
        return this.datasetNames;
    }

    protected Index.SampleIndexDetails getIdxDetails() {
        return this.idxDetails;
    }

    public void setNumVarsFromDisk(int num) {
        this.numVarsFromDisk = num;
    }

    public void setNumVarsAfterScan(int num) {
        this.numVarsAfterScan = num;
    }

    public void setSizeVarsFromDisk(double size) {
        this.sizeVarsFromDisk = size;
    }

    public void setSizeVarsAfterScan(double size) {
        this.sizeVarsAfterScan = size;
    }

    public int getNumVarsFromDisk() {
        return this.numVarsFromDisk;
    }

    public int getNumVarsAfterScan() {
        return this.numVarsAfterScan;
    }

    public double getSizeVarsFromDisk() {
        return this.sizeVarsFromDisk;
    }

    public double getSizeVarsAfterScan() {
        return this.sizeVarsAfterScan;
    }

    public void setColumnar(boolean format) {
        this.columnar = format;
    }

    public boolean getColumnar() {
        return this.columnar;
    }

    public void setCardsAndSizes(Index.SampleIndexDetails idxDetails, ILogicalOperator leafInput) throws AlgebricksException {
        boolean scaleUp;
        double sizeVarsAfterScan;
        double sizeVarsFromDisk;
        DatasetDataSource dds;
        SelectOperator selop;
        double origDatasetCard;
        double finalDatasetCard = origDatasetCard = (double)idxDetails.getSourceCardinality();
        DataSourceScanOperator scanOp = this.joinEnum.findDataSourceScanOperator(leafInput);
        if (scanOp == null) {
            return;
        }
        double sampleCard = Math.min((double)idxDetails.getSampleCardinalityTarget(), origDatasetCard);
        if (sampleCard == 0.0) {
            sampleCard = 1.0;
            IWarningCollector warningCollector = this.joinEnum.optCtx.getWarningCollector();
            if (warningCollector.shouldWarn()) {
                warningCollector.warn(Warning.of((SourceLocation)scanOp.getSourceLocation(), (IError)org.apache.asterix.common.exceptions.ErrorCode.SAMPLE_HAS_ZERO_ROWS, (Serializable[])new Serializable[0]));
            }
        }
        if ((selop = (SelectOperator)this.joinEnum.findASelectOp(leafInput)) == null) {
            SelectOperator op = selop = new SelectOperator((Mutable)new MutableObject((Object)ConstantExpression.TRUE));
            op.getInputs().add(new MutableObject((Object)leafInput));
            leafInput = op;
        }
        ILogicalOperator parent = this.joinEnum.findDataSourceScanOperatorParent(leafInput);
        MutableObject ref = new MutableObject((Object)leafInput);
        OperatorPropertiesUtil.typeOpRec((Mutable)ref, (IOptimizationContext)this.joinEnum.optCtx);
        if (LOGGER.isTraceEnabled()) {
            String viewPlan = new ALogicalPlanImpl((Mutable)ref).toString();
            LOGGER.trace("viewPlan");
            LOGGER.trace(viewPlan);
        }
        if ((dds = (DatasetDataSource)scanOp.getDataSource()).getDataset().getDatasetFormatInfo().getFormat() == DatasetConfig.DatasetFormat.ROW) {
            this.setColumnar(false);
        }
        SampleDataSource sampledatasource = this.joinEnum.getSampleDataSource(scanOp);
        DataSourceScanOperator deepCopyofScan = (DataSourceScanOperator)OperatorManipulationUtil.bottomUpCopyOperators((ILogicalOperator)scanOp);
        deepCopyofScan.setDataSource((IDataSource)sampledatasource);
        LogicalVariable primaryKey = deepCopyofScan.getVariables().size() > 1 ? (LogicalVariable)deepCopyofScan.getVariables().get(1) : (LogicalVariable)deepCopyofScan.getVariables().get(0);
        ((Mutable)parent.getInputs().get(0)).setValue((Object)deepCopyofScan);
        List<List<IAObject>> result = this.joinEnum.getStatsHandle().runSamplingQueryProjection(this.joinEnum.optCtx, leafInput, this.jnArrayIndex, primaryKey);
        double predicateCardinalityFromSample = this.joinEnum.getStatsHandle().findPredicateCardinality(result, true);
        if (predicateCardinalityFromSample > 0.0) {
            sizeVarsFromDisk = this.joinEnum.getStatsHandle().findSizeVarsFromDisk(result, this.getNumVarsFromDisk());
            sizeVarsAfterScan = this.joinEnum.getStatsHandle().findSizeVarsAfterScan(result, this.getNumVarsFromDisk());
        } else {
            ILogicalExpression saveExpr = (ILogicalExpression)selop.getCondition().getValue();
            selop.getCondition().setValue((Object)ConstantExpression.TRUE);
            result = this.joinEnum.getStatsHandle().runSamplingQueryProjection(this.joinEnum.optCtx, leafInput, this.jnArrayIndex, primaryKey);
            double x = this.joinEnum.getStatsHandle().findPredicateCardinality(result, true);
            if (x == 0.0) {
                sizeVarsFromDisk = this.getNumVarsFromDisk() * 100;
                sizeVarsAfterScan = this.getNumVarsAfterScan() * 100;
            } else {
                sizeVarsFromDisk = this.joinEnum.getStatsHandle().findSizeVarsFromDisk(result, this.getNumVarsFromDisk());
                sizeVarsAfterScan = this.joinEnum.getStatsHandle().findSizeVarsAfterScan(result, this.getNumVarsFromDisk());
            }
            selop.getCondition().setValue((Object)saveExpr);
        }
        predicateCardinalityFromSample = Math.max(predicateCardinalityFromSample, 1.0E-4);
        boolean bl = scaleUp = sampleCard != origDatasetCard;
        finalDatasetCard = scaleUp ? (finalDatasetCard *= predicateCardinalityFromSample / sampleCard) : predicateCardinalityFromSample;
        ((Mutable)parent.getInputs().get(0)).setValue((Object)scanOp);
        if (this.getCardinality() == this.getOrigCardinality()) {
            this.setCardinality(finalDatasetCard, scaleUp);
        }
        this.setSizeVarsFromDisk(sizeVarsFromDisk);
        this.setSizeVarsAfterScan(sizeVarsAfterScan);
        this.setAvgDocSize(idxDetails.getSourceAvgItemSize());
    }

    private boolean subset(int one, int two) {
        return (one & two) == one;
    }

    private void findApplicableJoinConditions() {
        List<JoinCondition> joinConditions = this.joinEnum.getJoinConditions();
        int i = 0;
        for (JoinCondition jc : joinConditions) {
            if (this.subset(jc.datasetBits, this.datasetBits)) {
                this.applicableJoinConditions.add(i);
            }
            ++i;
        }
    }

    private List<Integer> getNewJoinConditionsOnly() {
        ArrayList<Integer> newJoinConditions = new ArrayList<Integer>();
        JoinNode leftJn = this.leftJn;
        JoinNode rightJn = this.rightJn;
        int newTableBits = 0;
        if (leftJn.jnArrayIndex <= this.joinEnum.numberOfTerms) {
            newTableBits = leftJn.datasetBits;
        } else if (rightJn.jnArrayIndex <= this.joinEnum.numberOfTerms) {
            newTableBits = rightJn.datasetBits;
        }
        if (LOGGER.isTraceEnabled() && newTableBits == 0) {
            LOGGER.trace("newTable Bits == 0");
        }
        for (int idx : this.applicableJoinConditions) {
            if ((this.joinEnum.joinConditions.get((int)idx).datasetBits & newTableBits) <= 0) continue;
            newJoinConditions.add(idx);
        }
        return newJoinConditions;
    }

    public double computeJoinCardinality() {
        JoinNode[] jnArray = this.joinEnum.getJnArray();
        List<JoinCondition> joinConditions = this.joinEnum.getJoinConditions();
        this.applicableJoinConditions = new ArrayList<Integer>();
        this.findApplicableJoinConditions();
        if (LOGGER.isTraceEnabled() && this.applicableJoinConditions.size() == 0) {
            LOGGER.trace("applicable Join Conditions size is 0 in join Node " + this.jnArrayIndex);
        }
        double productJoinCardinality = 1.0;
        for (int idx : this.datasetIndexes) {
            productJoinCardinality *= jnArray[idx].cardinality;
        }
        double productJoinSels = 1.0;
        for (int idx : this.applicableJoinConditions) {
            if (joinConditions.get((int)idx).partOfComposite) continue;
            productJoinSels *= joinConditions.get((int)idx).selectivity;
        }
        double joinCard = productJoinCardinality * productJoinSels;
        double redundantSel = 1.0;
        if (this.applicableJoinConditions.size() >= 3) {
            redundantSel = this.removeRedundantPred(this.applicableJoinConditions);
        }
        return joinCard / redundantSel;
    }

    private static double adjustSelectivities(JoinCondition jc1, JoinCondition jc2, JoinCondition jc3) {
        double sel = jc1.comparisonType == JoinCondition.comparisonOp.OP_EQ && jc2.comparisonType == JoinCondition.comparisonOp.OP_EQ && jc3.comparisonType == JoinCondition.comparisonOp.OP_EQ ? JoinNode.findRedundantSel(jc1.selectivity, jc2.selectivity, jc3.selectivity) : (jc1.comparisonType != JoinCondition.comparisonOp.OP_EQ ? jc1.selectivity : (jc2.comparisonType != JoinCondition.comparisonOp.OP_EQ ? jc2.selectivity : jc3.selectivity));
        return sel;
    }

    private double removeRedundantPred(List<Integer> applicablePredicatesInCurrentJn) {
        double redundantSel = 1.0;
        List<JoinCondition> joinConditions = this.joinEnum.getJoinConditions();
        int[] vertices = new int[6];
        int[] verticesCopy = new int[6];
        for (int i = 0; i <= applicablePredicatesInCurrentJn.size() - 3; ++i) {
            JoinCondition jc1 = joinConditions.get(applicablePredicatesInCurrentJn.get(i));
            if (jc1.partOfComposite) continue;
            vertices[0] = jc1.leftSideBits;
            vertices[1] = jc1.rightSideBits;
            for (int j = i + 1; j <= applicablePredicatesInCurrentJn.size() - 2; ++j) {
                JoinCondition jc2 = joinConditions.get(applicablePredicatesInCurrentJn.get(j));
                if (jc2.partOfComposite) continue;
                vertices[2] = jc2.leftSideBits;
                vertices[3] = jc2.rightSideBits;
                for (int k = j + 1; k <= applicablePredicatesInCurrentJn.size() - 1; ++k) {
                    JoinCondition jc3 = joinConditions.get(applicablePredicatesInCurrentJn.get(k));
                    if (jc3.partOfComposite) continue;
                    vertices[4] = jc3.leftSideBits;
                    vertices[5] = jc3.rightSideBits;
                    System.arraycopy(vertices, 0, verticesCopy, 0, 6);
                    Arrays.sort(verticesCopy);
                    if (verticesCopy[0] != verticesCopy[1] || verticesCopy[2] != verticesCopy[3] || verticesCopy[4] != verticesCopy[5]) continue;
                    redundantSel *= JoinNode.adjustSelectivities(jc1, jc2, jc3);
                }
            }
        }
        return redundantSel;
    }

    private static double findRedundantSel(double sel1, double sel2, double sel3) {
        double[] sels = new double[]{sel1, sel2, sel3};
        Arrays.sort(sels);
        return sels[1];
    }

    protected int addSingleDatasetPlans() {
        boolean forceEnum;
        List<PlanNode> allPlans = this.joinEnum.allPlans;
        Cost opCost = this.joinEnum.getCostMethodsHandle().costFullScan(this);
        boolean bl = forceEnum = this.level <= this.joinEnum.cboFullEnumLevel;
        if (this.cheapestPlanIndex == PlanNode.NO_PLAN || opCost.costLT(this.cheapestPlanCost) || forceEnum) {
            PlanNode pn = new PlanNode(allPlans.size(), this.joinEnum, this, this.datasetNames.get(0), this.leafInput);
            pn.setScanMethod(PlanNode.ScanMethod.TABLE_SCAN);
            pn.setScanCosts(opCost);
            this.planIndexesArray.add(pn.allPlansIndex);
            allPlans.add(pn);
            this.setCheapestPlan(pn, forceEnum);
            return pn.allPlansIndex;
        }
        return PlanNode.NO_PLAN;
    }

    private AbstractFunctionCallExpression buildExpr(List<IOptimizableFuncExpr> exprs, List<Pair<Integer, Integer>> pairs) {
        if (pairs.size() == 1) {
            int i = (Integer)pairs.get(0).getFirst();
            return exprs.get(i).getFuncExpr();
        }
        ScalarFunctionCallExpression andExpr = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)AlgebricksBuiltinFunctions.AND));
        for (int i = 0; i < pairs.size(); ++i) {
            IOptimizableFuncExpr expr = exprs.get((Integer)pairs.get(i).getFirst());
            andExpr.getArguments().add(new MutableObject((Object)expr.getFuncExpr()));
        }
        return andExpr;
    }

    private void setSkipIndexAnnotationsForUnusedIndexes() {
        for (int i = 0; i < this.IndexCostInfo.size(); ++i) {
            if ((Double)this.IndexCostInfo.get((int)i).second != -1.0) continue;
            AbstractFunctionCallExpression afce = (AbstractFunctionCallExpression)this.IndexCostInfo.get((int)i).third;
            EnumerateJoinsRule.setAnnotation(afce, (IExpressionAnnotation)SkipSecondaryIndexSearchExpressionAnnotation.newInstance(Collections.singleton(((Index)this.IndexCostInfo.get((int)i).first).getIndexName())));
        }
    }

    private void costAndChooseIndexPlans(ILogicalOperator leafInput, Map<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs) throws AlgebricksException {
        ArrayList<Triple<Index, Double, AbstractFunctionCallExpression>> IndexCostInfo = new ArrayList<Triple<Index, Double, AbstractFunctionCallExpression>>();
        for (Map.Entry<IAccessMethod, AccessMethodAnalysisContext> amEntry : analyzedAMs.entrySet()) {
            AccessMethodAnalysisContext analysisCtx = amEntry.getValue();
            Iterator<Map.Entry<Index, List<Pair<Integer, Integer>>>> indexIt = analysisCtx.getIteratorForIndexExprsAndVars();
            List<IOptimizableFuncExpr> exprs = analysisCtx.getMatchedFuncExprs();
            while (indexIt.hasNext()) {
                double sel;
                Map.Entry<Index, List<Pair<Integer, Integer>>> indexEntry = indexIt.next();
                Index chosenIndex = indexEntry.getKey();
                if (chosenIndex.getIndexType().equals((Object)DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX) || chosenIndex.getIndexType().equals((Object)DatasetConfig.IndexType.SINGLE_PARTITION_WORD_INVIX) || chosenIndex.getIndexType().equals((Object)DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX) || chosenIndex.getIndexType().equals((Object)DatasetConfig.IndexType.SINGLE_PARTITION_NGRAM_INVIX)) continue;
                AbstractFunctionCallExpression afce = this.buildExpr(exprs, indexEntry.getValue());
                PredicateCardinalityAnnotation selectivityAnnotation = (PredicateCardinalityAnnotation)afce.getAnnotation(PredicateCardinalityAnnotation.class);
                if (selectivityAnnotation != null) {
                    sel = selectivityAnnotation.getSelectivity();
                } else {
                    SelectOperator selOp;
                    if (leafInput.getOperatorTag().equals((Object)LogicalOperatorTag.SELECT)) {
                        selOp = this.joinEnum.getStatsHandle().findSelectOpWithExpr(leafInput, (ILogicalExpression)afce);
                        if (selOp == null) {
                            selOp = (SelectOperator)leafInput;
                        }
                    } else {
                        selOp = new SelectOperator((Mutable)new MutableObject((Object)afce));
                        selOp.getInputs().add(new MutableObject((Object)leafInput));
                    }
                    sel = this.joinEnum.getStatsHandle().findSelectivityForThisPredicate(selOp, afce, chosenIndex.getIndexType().equals((Object)DatasetConfig.IndexType.ARRAY) || this.joinEnum.findUnnestOp((ILogicalOperator)selOp));
                }
                IndexCostInfo.add((Triple<Index, Double, AbstractFunctionCallExpression>)new Triple((Object)chosenIndex, (Object)sel, (Object)afce));
            }
        }
        this.IndexCostInfo = IndexCostInfo;
        if (IndexCostInfo.size() > 0) {
            this.buildIndexPlans();
        }
        this.setSkipIndexAnnotationsForUnusedIndexes();
    }

    private void buildIndexPlans() {
        boolean forceEnum;
        List<PlanNode> allPlans = this.joinEnum.getAllPlans();
        ArrayList<Triple<Index, Double, AbstractFunctionCallExpression>> mandatoryIndexesInfo = new ArrayList<Triple<Index, Double, AbstractFunctionCallExpression>>();
        ArrayList<Object> optionalIndexesInfo = new ArrayList<Object>();
        double sel = 1.0;
        ICost opCost = this.joinEnum.getCostHandle().zeroCost();
        for (int i = 0; i < this.IndexCostInfo.size(); ++i) {
            if (this.joinEnum.findUseIndexHint((AbstractFunctionCallExpression)this.IndexCostInfo.get((int)i).third)) {
                mandatoryIndexesInfo.add(this.IndexCostInfo.get(i));
                continue;
            }
            optionalIndexesInfo.add(this.IndexCostInfo.get(i));
        }
        ArrayList<Cost> indexCosts = new ArrayList<Cost>();
        if (mandatoryIndexesInfo.size() > 0) {
            int i;
            for (i = 0; i < mandatoryIndexesInfo.size(); ++i) {
                indexCosts.add(this.joinEnum.getCostMethodsHandle().costIndexScan(this, (Double)((Triple)mandatoryIndexesInfo.get((int)i)).second));
            }
            opCost = this.joinEnum.getCostHandle().zeroCost();
            for (i = 0; i < mandatoryIndexesInfo.size(); ++i) {
                opCost = opCost.costAdd((ICost)indexCosts.get(i));
                sel *= ((Double)((Triple)mandatoryIndexesInfo.get((int)i)).second).doubleValue();
            }
            Cost dataScanCost = this.joinEnum.getCostMethodsHandle().costIndexDataScan(this, sel);
            opCost = opCost.costAdd(dataScanCost);
        }
        ICost mandatoryIndexesCost = opCost;
        ArrayList<Cost> dataCosts = new ArrayList<Cost>();
        indexCosts.clear();
        if (optionalIndexesInfo.size() > 0) {
            optionalIndexesInfo.sort(Comparator.comparingDouble(o -> (Double)o.second));
            for (int i = 0; i < optionalIndexesInfo.size(); ++i) {
                indexCosts.add(this.joinEnum.getCostMethodsHandle().costIndexScan(this, (Double)((Triple)optionalIndexesInfo.get((int)i)).second));
                dataCosts.add(this.joinEnum.getCostMethodsHandle().costIndexDataScan(this, sel *= ((Double)((Triple)optionalIndexesInfo.get((int)i)).second).doubleValue()));
            }
            opCost = ((ICost)indexCosts.get(0)).costAdd((ICost)dataCosts.get(0));
            ICost newIdxCost = (ICost)indexCosts.get(0);
            for (int i = 1; i < optionalIndexesInfo.size(); ++i) {
                ICost currentCost = (newIdxCost = newIdxCost.costAdd((ICost)indexCosts.get(i))).costAdd((ICost)dataCosts.get(i));
                if (currentCost.costLT(opCost) || this.level <= this.joinEnum.cboFullEnumLevel) {
                    opCost = currentCost;
                    continue;
                }
                for (int j = i; j < optionalIndexesInfo.size(); ++j) {
                    ((Triple)optionalIndexesInfo.get((int)j)).second = -1.0;
                }
                break;
            }
        }
        if (opCost.costGT(this.cheapestPlanCost) && this.level > this.joinEnum.cboFullEnumLevel) {
            for (int j = 0; j < optionalIndexesInfo.size(); ++j) {
                ((Triple)optionalIndexesInfo.get((int)j)).second = -1.0;
            }
        }
        ICost totalCost = opCost.costAdd(mandatoryIndexesCost);
        boolean bl = forceEnum = mandatoryIndexesInfo.size() > 0 || this.level <= this.joinEnum.cboFullEnumLevel;
        if (opCost.costLT(this.cheapestPlanCost) || forceEnum) {
            PlanNode pn = new PlanNode(allPlans.size(), this.joinEnum, this, this.datasetNames.get(0), this.leafInput);
            pn.setScanAndHintInfo(PlanNode.ScanMethod.INDEX_SCAN, mandatoryIndexesInfo);
            pn.setScanCosts(totalCost);
            this.planIndexesArray.add(pn.allPlansIndex);
            allPlans.add(pn);
            this.setCheapestPlan(pn, forceEnum);
        }
    }

    private SelectOperator copySelExprsAndSetTrue(List<ILogicalExpression> selExprs, List<SelectOperator> selOpers, ILogicalOperator leafInput) {
        ILogicalOperator op = leafInput;
        SelectOperator firstSelOp = null;
        boolean firstSel = true;
        while (op != null && op.getOperatorTag() != LogicalOperatorTag.EMPTYTUPLESOURCE) {
            if (op.getOperatorTag() == LogicalOperatorTag.SELECT) {
                SelectOperator selOp = (SelectOperator)op;
                if (firstSel) {
                    firstSelOp = selOp;
                    firstSel = false;
                }
                selOpers.add(selOp);
                selExprs.add((ILogicalExpression)selOp.getCondition().getValue());
                selOp.getCondition().setValue((Object)ConstantExpression.TRUE);
            }
            op = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        }
        return firstSelOp;
    }

    private void restoreSelExprs(List<ILogicalExpression> selExprs, List<SelectOperator> selOpers) {
        for (int i = 0; i < selExprs.size(); ++i) {
            selOpers.get(i).getCondition().setValue((Object)selExprs.get(i));
        }
    }

    private ILogicalExpression andAlltheExprs(List<ILogicalExpression> selExprs) {
        if (selExprs.size() == 1) {
            return selExprs.get(0);
        }
        ScalarFunctionCallExpression andExpr = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)AlgebricksBuiltinFunctions.AND));
        for (ILogicalExpression se : selExprs) {
            andExpr.getArguments().add(new MutableObject((Object)se));
        }
        return andExpr;
    }

    private boolean combineDoubleSelectsBeforeSubPlans(ILogicalOperator op) {
        boolean changes = false;
        while (op != null && op.getOperatorTag() != LogicalOperatorTag.EMPTYTUPLESOURCE) {
            SelectOperator selOp2;
            ILogicalOperator op2;
            SelectOperator selOp1;
            if (op.getOperatorTag() == LogicalOperatorTag.SELECT && ((ILogicalOperator)((Mutable)(selOp1 = (SelectOperator)op).getInputs().get(0)).getValue()).getOperatorTag().equals((Object)LogicalOperatorTag.SELECT) && (op2 = (ILogicalOperator)((Mutable)(selOp2 = (SelectOperator)((Mutable)op.getInputs().get(0)).getValue()).getInputs().get(0)).getValue()).getOperatorTag() == LogicalOperatorTag.SUBPLAN) {
                ((Mutable)selOp1.getInputs().get(0)).setValue((Object)op2);
                ILogicalExpression exp1 = (ILogicalExpression)selOp1.getCondition().getValue();
                ILogicalExpression exp2 = (ILogicalExpression)selOp2.getCondition().getValue();
                ScalarFunctionCallExpression andExpr = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)AlgebricksBuiltinFunctions.AND));
                andExpr.getArguments().add(new MutableObject((Object)exp1));
                andExpr.getArguments().add(new MutableObject((Object)exp2));
                selOp1.getCondition().setValue((Object)andExpr);
                op = (ILogicalOperator)((Mutable)op2.getInputs().get(0)).getValue();
                changes = true;
            }
            op = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        }
        return changes;
    }

    protected void addIndexAccessPlans(ILogicalOperator leafInput) throws AlgebricksException {
        IntroduceSelectAccessMethodRule tmp = new IntroduceSelectAccessMethodRule();
        ArrayList<Pair<IAccessMethod, Index>> chosenIndexes = new ArrayList<Pair<IAccessMethod, Index>>();
        TreeMap<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs = new TreeMap<IAccessMethod, AccessMethodAnalysisContext>();
        while (this.combineDoubleSelectsBeforeSubPlans(leafInput)) {
        }
        ArrayList<ILogicalExpression> selExprs = new ArrayList<ILogicalExpression>();
        ArrayList<SelectOperator> selOpers = new ArrayList<SelectOperator>();
        SelectOperator firstSelop = this.copySelExprsAndSetTrue(selExprs, selOpers, leafInput);
        if (firstSelop != null) {
            firstSelop.getCondition().setValue((Object)this.andAlltheExprs(selExprs));
            boolean index_access_possible = tmp.checkApplicable((Mutable<ILogicalOperator>)new MutableObject((Object)leafInput), this.joinEnum.optCtx, chosenIndexes, analyzedAMs);
            this.restoreSelExprs(selExprs, selOpers);
            if (index_access_possible) {
                this.costAndChooseIndexPlans(leafInput, analyzedAMs);
            }
        } else {
            this.restoreSelExprs(selExprs, selOpers);
        }
    }

    private boolean nullExtendingSide(int bits, boolean outerJoin) {
        if (outerJoin) {
            for (Quadruple<Integer, Integer, JoinOperator, Integer> qu : this.joinEnum.outerJoinsDependencyList) {
                if (!((JoinOperator)qu.getThird()).getOuterJoin() || (Integer)qu.getSecond() != bits) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hashJoinApplicable(JoinNode leftJn, boolean outerJoin, ILogicalExpression hashJoinExpr) {
        if (this.nullExtendingSide(leftJn.datasetBits, outerJoin)) {
            return false;
        }
        if (hashJoinExpr == null || hashJoinExpr == ConstantExpression.TRUE) {
            return false;
        }
        if (this.joinEnum.queryPlanShape.equals("leftdeep") && !leftJn.IsBaseLevelJoinNode() && this.level > this.joinEnum.cboFullEnumLevel) {
            return false;
        }
        return !this.joinEnum.queryPlanShape.equals("rightdeep") || this.rightJn.IsBaseLevelJoinNode() || this.level <= this.joinEnum.cboFullEnumLevel;
    }

    private boolean nestedLoopsApplicable(ILogicalExpression joinExpr) throws AlgebricksException {
        ArrayList usedVarList = new ArrayList();
        joinExpr.getUsedVariables(usedVarList);
        if (usedVarList.size() != 2) {
            return false;
        }
        if (joinExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        LogicalVariable var0 = (LogicalVariable)usedVarList.get(0);
        LogicalVariable var1 = (LogicalVariable)usedVarList.get(1);
        ILogicalOperator joinLeafInput0 = this.joinEnum.findLeafInput(Collections.singletonList(var0));
        if (joinLeafInput0 == null) {
            return false;
        }
        ILogicalOperator joinLeafInput1 = this.joinEnum.findLeafInput(Collections.singletonList(var1));
        if (joinLeafInput1 == null) {
            return false;
        }
        ILogicalOperator innerLeafInput = this.leafInput;
        if (innerLeafInput != joinLeafInput1 && innerLeafInput != joinLeafInput0) {
            return false;
        }
        if (innerLeafInput == joinLeafInput0) {
            ((Mutable)this.joinEnum.localJoinOp.getInputs().get(0)).setValue((Object)joinLeafInput1);
        } else {
            ((Mutable)this.joinEnum.localJoinOp.getInputs().get(0)).setValue((Object)joinLeafInput0);
        }
        ((Mutable)this.joinEnum.localJoinOp.getInputs().get(1)).setValue((Object)innerLeafInput);
        AbstractBinaryJoinOperator joinOp = (AbstractBinaryJoinOperator)this.joinEnum.localJoinOp;
        joinOp.getCondition().setValue((Object)joinExpr);
        IntroduceJoinAccessMethodRule tmp = new IntroduceJoinAccessMethodRule();
        boolean retVal = tmp.checkApplicable((Mutable<ILogicalOperator>)new MutableObject((Object)this.joinEnum.localJoinOp), this.joinEnum.optCtx);
        return retVal;
    }

    private boolean NLJoinApplicable(JoinNode leftJn, JoinNode rightJn, boolean outerJoin, ILogicalExpression nestedLoopJoinExpr) throws AlgebricksException {
        if (this.nullExtendingSide(leftJn.datasetBits, outerJoin)) {
            return false;
        }
        if (rightJn.jnArrayIndex > this.joinEnum.numberOfTerms) {
            return false;
        }
        return nestedLoopJoinExpr != null && rightJn.nestedLoopsApplicable(nestedLoopJoinExpr);
    }

    private boolean CPJoinApplicable(JoinNode leftJn, boolean outerJoin) {
        if (!this.joinEnum.cboCPEnumMode) {
            return false;
        }
        return !this.nullExtendingSide(leftJn.datasetBits, outerJoin);
    }

    protected int buildHashJoinPlan(PlanNode leftPlan, PlanNode rightPlan, ILogicalExpression hashJoinExpr, HashJoinExpressionAnnotation hintHashJoin, boolean outerJoin) {
        boolean forceEnum;
        List<PlanNode> allPlans = this.joinEnum.allPlans;
        JoinNode leftJn = leftPlan.getJoinNode();
        JoinNode rightJn = rightPlan.getJoinNode();
        this.leftJn = leftJn;
        this.rightJn = rightJn;
        if (!this.hashJoinApplicable(leftJn, outerJoin, hashJoinExpr)) {
            return PlanNode.NO_PLAN;
        }
        boolean bl = forceEnum = hintHashJoin != null || this.joinEnum.forceJoinOrderMode || !this.joinEnum.queryPlanShape.equals("zigzag") || outerJoin || this.level <= this.joinEnum.cboFullEnumLevel;
        if (rightJn.cardinality * rightJn.size <= leftJn.cardinality * leftJn.size || forceEnum) {
            Cost hjCost = this.joinEnum.getCostMethodsHandle().costHashJoin(this);
            Cost leftExchangeCost = this.joinEnum.getCostMethodsHandle().computeHJProbeExchangeCost(this);
            Cost rightExchangeCost = this.joinEnum.getCostMethodsHandle().computeHJBuildExchangeCost(this);
            ICost childCosts = allPlans.get((int)leftPlan.allPlansIndex).totalCost.costAdd(allPlans.get((int)rightPlan.allPlansIndex).totalCost);
            ICost totalCost = hjCost.costAdd(leftExchangeCost).costAdd(rightExchangeCost).costAdd(childCosts);
            if (this.cheapestPlanIndex == PlanNode.NO_PLAN || totalCost.costLT(this.cheapestPlanCost) || forceEnum) {
                PlanNode pn = new PlanNode(allPlans.size(), this.joinEnum, this, leftPlan, rightPlan, outerJoin);
                pn.setJoinAndHintInfo(PlanNode.JoinMethod.HYBRID_HASH_JOIN, hashJoinExpr, HashJoinExpressionAnnotation.BuildSide.RIGHT, (IExpressionAnnotation)hintHashJoin);
                pn.setJoinCosts(hjCost, totalCost, leftExchangeCost, rightExchangeCost);
                this.planIndexesArray.add(pn.allPlansIndex);
                allPlans.add(pn);
                this.setCheapestPlan(pn, forceEnum);
                return pn.allPlansIndex;
            }
        }
        return PlanNode.NO_PLAN;
    }

    private int buildBroadcastHashJoinPlan(PlanNode leftPlan, PlanNode rightPlan, ILogicalExpression hashJoinExpr, BroadcastExpressionAnnotation hintBroadcastHashJoin, boolean outerJoin) {
        boolean forceEnum;
        List<PlanNode> allPlans = this.joinEnum.allPlans;
        JoinNode leftJn = leftPlan.getJoinNode();
        JoinNode rightJn = rightPlan.getJoinNode();
        this.leftJn = leftJn;
        this.rightJn = rightJn;
        if (!this.hashJoinApplicable(leftJn, outerJoin, hashJoinExpr)) {
            return PlanNode.NO_PLAN;
        }
        boolean bl = forceEnum = hintBroadcastHashJoin != null || this.joinEnum.forceJoinOrderMode || !this.joinEnum.queryPlanShape.equals("zigzag") || outerJoin || this.level <= this.joinEnum.cboFullEnumLevel;
        if (rightJn.cardinality * rightJn.size <= leftJn.cardinality * leftJn.size || forceEnum) {
            Cost bcastHjCost = this.joinEnum.getCostMethodsHandle().costBroadcastHashJoin(this);
            ICost leftExchangeCost = this.joinEnum.getCostHandle().zeroCost();
            Cost rightExchangeCost = this.joinEnum.getCostMethodsHandle().computeBHJBuildExchangeCost(this);
            ICost childCosts = allPlans.get((int)leftPlan.allPlansIndex).totalCost.costAdd(allPlans.get((int)rightPlan.allPlansIndex).totalCost);
            ICost totalCost = bcastHjCost.costAdd(rightExchangeCost).costAdd(childCosts);
            if (this.cheapestPlanIndex == PlanNode.NO_PLAN || totalCost.costLT(this.cheapestPlanCost) || forceEnum) {
                PlanNode pn = new PlanNode(allPlans.size(), this.joinEnum, this, leftPlan, rightPlan, outerJoin);
                pn.setJoinAndHintInfo(PlanNode.JoinMethod.BROADCAST_HASH_JOIN, hashJoinExpr, HashJoinExpressionAnnotation.BuildSide.RIGHT, (IExpressionAnnotation)hintBroadcastHashJoin);
                pn.setJoinCosts(bcastHjCost, totalCost, leftExchangeCost, rightExchangeCost);
                this.planIndexesArray.add(pn.allPlansIndex);
                allPlans.add(pn);
                this.setCheapestPlan(pn, forceEnum);
                return pn.allPlansIndex;
            }
        }
        return PlanNode.NO_PLAN;
    }

    private int buildNLJoinPlan(PlanNode leftPlan, PlanNode rightPlan, ILogicalExpression nestedLoopJoinExpr, IndexedNLJoinExpressionAnnotation hintNLJoin, boolean outerJoin) throws AlgebricksException {
        boolean forceEnum;
        JoinNode leftJn = leftPlan.getJoinNode();
        JoinNode rightJn = rightPlan.getJoinNode();
        List<PlanNode> allPlans = this.joinEnum.allPlans;
        this.leftJn = leftJn;
        this.rightJn = rightJn;
        if (!this.NLJoinApplicable(leftJn, rightJn, outerJoin, nestedLoopJoinExpr)) {
            return PlanNode.NO_PLAN;
        }
        Cost nljCost = this.joinEnum.getCostMethodsHandle().costIndexNLJoin(this);
        Cost leftExchangeCost = this.joinEnum.getCostMethodsHandle().computeNLJOuterExchangeCost(this);
        ICost rightExchangeCost = this.joinEnum.getCostHandle().zeroCost();
        ICost childCosts = allPlans.get((int)leftPlan.allPlansIndex).totalCost;
        ICost totalCost = nljCost.costAdd(leftExchangeCost).costAdd(childCosts);
        boolean bl = forceEnum = hintNLJoin != null || this.joinEnum.forceJoinOrderMode || outerJoin || this.level <= this.joinEnum.cboFullEnumLevel;
        if (this.cheapestPlanIndex == PlanNode.NO_PLAN || totalCost.costLT(this.cheapestPlanCost) || forceEnum) {
            PlanNode pn = new PlanNode(allPlans.size(), this.joinEnum, this, leftPlan, rightPlan, outerJoin);
            pn.setJoinAndHintInfo(PlanNode.JoinMethod.INDEX_NESTED_LOOP_JOIN, nestedLoopJoinExpr, null, (IExpressionAnnotation)hintNLJoin);
            pn.setJoinCosts(nljCost, totalCost, leftExchangeCost, rightExchangeCost);
            this.planIndexesArray.add(pn.allPlansIndex);
            allPlans.add(pn);
            this.setCheapestPlan(pn, forceEnum);
            return pn.allPlansIndex;
        }
        return PlanNode.NO_PLAN;
    }

    private int buildCPJoinPlan(PlanNode leftPlan, PlanNode rightPlan, ILogicalExpression hashJoinExpr, ILogicalExpression nestedLoopJoinExpr, boolean outerJoin) {
        boolean forceEnum;
        ILogicalExpression cpJoinExpr;
        JoinNode leftJn = leftPlan.getJoinNode();
        JoinNode rightJn = rightPlan.getJoinNode();
        List<PlanNode> allPlans = this.joinEnum.allPlans;
        if (!this.CPJoinApplicable(leftJn, outerJoin)) {
            return PlanNode.NO_PLAN;
        }
        this.leftJn = leftJn;
        this.rightJn = rightJn;
        List<Integer> newJoinConditions = this.getNewJoinConditionsOnly();
        if (hashJoinExpr == null && nestedLoopJoinExpr == null) {
            cpJoinExpr = this.joinEnum.combineAllConditions(newJoinConditions);
        } else if (hashJoinExpr != null && nestedLoopJoinExpr == null) {
            cpJoinExpr = hashJoinExpr;
        } else if (hashJoinExpr == null) {
            cpJoinExpr = nestedLoopJoinExpr;
        } else if (Objects.equals(hashJoinExpr, nestedLoopJoinExpr)) {
            cpJoinExpr = hashJoinExpr;
        } else {
            ScalarFunctionCallExpression andExpr = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)AlgebricksBuiltinFunctions.AND));
            andExpr.getArguments().add(new MutableObject((Object)hashJoinExpr));
            andExpr.getArguments().add(new MutableObject((Object)nestedLoopJoinExpr));
            cpJoinExpr = andExpr;
        }
        Cost cpCost = this.joinEnum.getCostMethodsHandle().costCartesianProductJoin(this);
        ICost leftExchangeCost = this.joinEnum.getCostHandle().zeroCost();
        Cost rightExchangeCost = this.joinEnum.getCostMethodsHandle().computeCPRightExchangeCost(this);
        ICost childCosts = allPlans.get((int)leftPlan.allPlansIndex).totalCost.costAdd(allPlans.get((int)rightPlan.allPlansIndex).totalCost);
        ICost totalCost = cpCost.costAdd(rightExchangeCost).costAdd(childCosts);
        boolean bl = forceEnum = this.joinEnum.forceJoinOrderMode || outerJoin || this.level <= this.joinEnum.cboFullEnumLevel;
        if (this.cheapestPlanIndex == PlanNode.NO_PLAN || totalCost.costLT(this.cheapestPlanCost) || forceEnum) {
            PlanNode pn = new PlanNode(allPlans.size(), this.joinEnum, this, leftPlan, rightPlan, outerJoin);
            pn.setJoinAndHintInfo(PlanNode.JoinMethod.CARTESIAN_PRODUCT_JOIN, (ILogicalExpression)Objects.requireNonNullElse(cpJoinExpr, ConstantExpression.TRUE), null, null);
            pn.setJoinCosts(cpCost, totalCost, leftExchangeCost, rightExchangeCost);
            this.planIndexesArray.add(pn.allPlansIndex);
            allPlans.add(pn);
            this.setCheapestPlan(pn, forceEnum);
            return pn.allPlansIndex;
        }
        return PlanNode.NO_PLAN;
    }

    protected void addMultiDatasetPlans(JoinNode leftJn, JoinNode rightJn) throws AlgebricksException {
        if (this.level > this.joinEnum.cboFullEnumLevel) {
            if (leftJn.cheapestPlanIndex == PlanNode.NO_PLAN || rightJn.cheapestPlanIndex == PlanNode.NO_PLAN) {
                return;
            }
            PlanNode leftPlan = this.joinEnum.allPlans.get(leftJn.cheapestPlanIndex);
            PlanNode rightPlan = this.joinEnum.allPlans.get(rightJn.cheapestPlanIndex);
            this.addMultiDatasetPlans(leftPlan, rightPlan);
        } else {
            for (int leftPlanIndex : leftJn.planIndexesArray) {
                PlanNode leftPlan = this.joinEnum.allPlans.get(leftPlanIndex);
                for (int rightPlanIndex : rightJn.planIndexesArray) {
                    PlanNode rightPlan = this.joinEnum.allPlans.get(rightPlanIndex);
                    this.addMultiDatasetPlans(leftPlan, rightPlan);
                }
            }
        }
    }

    protected void addMultiDatasetPlans(PlanNode leftPlan, PlanNode rightPlan) throws AlgebricksException {
        JoinNode leftJn = leftPlan.getJoinNode();
        JoinNode rightJn = rightPlan.getJoinNode();
        this.leftJn = leftJn;
        this.rightJn = rightJn;
        if (leftJn.planIndexesArray.size() == 0 || rightJn.planIndexesArray.size() == 0) {
            return;
        }
        if (this.cardinality >= 1.0E200) {
            return;
        }
        if (leftJn.cheapestPlanIndex == PlanNode.NO_PLAN || rightJn.cheapestPlanIndex == PlanNode.NO_PLAN) {
            return;
        }
        List<Integer> newJoinConditions = this.getNewJoinConditionsOnly();
        if (newJoinConditions.size() == 0 && this.joinEnum.connectedJoinGraph && leftJn.cardinality * rightJn.cardinality > 10000.0 && this.level > this.joinEnum.cboFullEnumLevel) {
            return;
        }
        ILogicalExpression hashJoinExpr = this.joinEnum.getHashJoinExpr(newJoinConditions);
        ILogicalExpression nestedLoopJoinExpr = this.joinEnum.getNestedLoopJoinExpr(newJoinConditions);
        boolean outerJoin = this.joinEnum.lookForOuterJoins(newJoinConditions);
        double current_card = this.cardinality;
        if (current_card >= 1.0E200) {
            return;
        }
        if (leftJn.distinctCardinality == 0.0) {
            this.distinctCardinality = rightJn.distinctCardinality;
        } else if (rightJn.distinctCardinality == 0.0) {
            this.distinctCardinality = leftJn.distinctCardinality;
        } else {
            double leftJnCard = leftJn.IsBaseLevelJoinNode() ? leftJn.getOrigCardinality() : leftJn.getCardinality();
            double rightJnCard = rightJn.IsBaseLevelJoinNode() ? rightJn.getOrigCardinality() : rightJn.getCardinality();
            this.distinctCardinality = leftJn.distinctCardinality > rightJn.distinctCardinality ? leftJn.distinctCardinality * this.cardinality / leftJnCard : rightJn.distinctCardinality * this.cardinality / rightJnCard;
            this.distinctCardinality = (double)Math.round(this.distinctCardinality * 100.0) / 100.0;
        }
        boolean validPlan = false;
        HashJoinExpressionAnnotation hintHashJoin = this.joinEnum.findHashJoinHint(newJoinConditions);
        BroadcastExpressionAnnotation hintBroadcastHashJoin = this.joinEnum.findBroadcastHashJoinHint(newJoinConditions);
        IndexedNLJoinExpressionAnnotation hintNLJoin = this.joinEnum.findNLJoinHint(newJoinConditions);
        if (hintHashJoin != null) {
            validPlan = this.buildHintedHJPlans(leftPlan, rightPlan, hashJoinExpr, hintHashJoin, outerJoin, newJoinConditions);
        } else if (hintBroadcastHashJoin != null) {
            validPlan = this.buildHintedBcastHJPlans(leftPlan, rightPlan, hashJoinExpr, hintBroadcastHashJoin, outerJoin, newJoinConditions);
        } else if (hintNLJoin != null) {
            validPlan = this.buildHintedNLJPlans(leftPlan, rightPlan, nestedLoopJoinExpr, hintNLJoin, outerJoin, newJoinConditions);
        }
        if (!validPlan) {
            this.buildAllNonHintedPlans(leftPlan, rightPlan, hashJoinExpr, nestedLoopJoinExpr, outerJoin);
        }
        this.leftJn = leftJn;
        this.rightJn = rightJn;
    }

    private boolean buildHintedHJPlans(PlanNode leftPlan, PlanNode rightPlan, ILogicalExpression hashJoinExpr, HashJoinExpressionAnnotation hintHashJoin, boolean outerJoin, List<Integer> newJoinConditions) {
        int commutativeHjPlan;
        JoinNode leftJn = leftPlan.getJoinNode();
        JoinNode rightJn = rightPlan.getJoinNode();
        int hjPlan = commutativeHjPlan = PlanNode.NO_PLAN;
        boolean build = hintHashJoin.getBuildOrProbe() == HashJoinExpressionAnnotation.BuildOrProbe.BUILD;
        boolean probe = hintHashJoin.getBuildOrProbe() == HashJoinExpressionAnnotation.BuildOrProbe.PROBE;
        boolean validBuildOrProbeObject = false;
        String buildOrProbeObject = hintHashJoin.getName();
        if (buildOrProbeObject != null && (rightJn.datasetNames.contains(buildOrProbeObject) || rightJn.aliases.contains(buildOrProbeObject) || leftJn.datasetNames.contains(buildOrProbeObject) || leftJn.aliases.contains(buildOrProbeObject))) {
            validBuildOrProbeObject = true;
        }
        if (validBuildOrProbeObject) {
            if (build && (rightJn.datasetNames.contains(buildOrProbeObject) || rightJn.aliases.contains(buildOrProbeObject)) || probe && (leftJn.datasetNames.contains(buildOrProbeObject) || leftJn.aliases.contains(buildOrProbeObject))) {
                hjPlan = this.buildHashJoinPlan(leftPlan, rightPlan, hashJoinExpr, hintHashJoin, outerJoin);
            } else if (build && (leftJn.datasetNames.contains(buildOrProbeObject) || leftJn.aliases.contains(buildOrProbeObject)) || probe && (rightJn.datasetNames.contains(buildOrProbeObject) || rightJn.aliases.contains(buildOrProbeObject))) {
                commutativeHjPlan = this.buildHashJoinPlan(rightPlan, leftPlan, hashJoinExpr, hintHashJoin, outerJoin);
            }
        }
        return this.handleHints(hjPlan, commutativeHjPlan, (IExpressionAnnotation)hintHashJoin, newJoinConditions);
    }

    private boolean buildHintedBcastHJPlans(PlanNode leftPlan, PlanNode rightPlan, ILogicalExpression hashJoinExpr, BroadcastExpressionAnnotation hintBroadcastHashJoin, boolean outerJoin, List<Integer> newJoinConditions) {
        int commutativeBcastHjPlan;
        JoinNode leftJn = leftPlan.getJoinNode();
        JoinNode rightJn = rightPlan.getJoinNode();
        int bcastHjPlan = commutativeBcastHjPlan = PlanNode.NO_PLAN;
        boolean validBroadcastObject = false;
        String broadcastObject = hintBroadcastHashJoin.getName();
        if (broadcastObject != null && (rightJn.datasetNames.contains(broadcastObject) || rightJn.aliases.contains(broadcastObject) || leftJn.datasetNames.contains(broadcastObject) || leftJn.aliases.contains(broadcastObject))) {
            validBroadcastObject = true;
        }
        if (validBroadcastObject) {
            if (rightJn.datasetNames.contains(broadcastObject) || rightJn.aliases.contains(broadcastObject)) {
                bcastHjPlan = this.buildBroadcastHashJoinPlan(leftPlan, rightPlan, hashJoinExpr, hintBroadcastHashJoin, outerJoin);
            } else if (leftJn.datasetNames.contains(broadcastObject) || leftJn.aliases.contains(broadcastObject)) {
                commutativeBcastHjPlan = this.buildBroadcastHashJoinPlan(rightPlan, leftPlan, hashJoinExpr, hintBroadcastHashJoin, outerJoin);
            }
        } else if (broadcastObject == null) {
            bcastHjPlan = this.buildBroadcastHashJoinPlan(leftPlan, rightPlan, hashJoinExpr, hintBroadcastHashJoin, outerJoin);
            if (!this.joinEnum.forceJoinOrderMode || this.level <= this.joinEnum.cboFullEnumLevel) {
                commutativeBcastHjPlan = this.buildBroadcastHashJoinPlan(rightPlan, leftPlan, hashJoinExpr, hintBroadcastHashJoin, outerJoin);
            }
        }
        return this.handleHints(bcastHjPlan, commutativeBcastHjPlan, (IExpressionAnnotation)hintBroadcastHashJoin, newJoinConditions);
    }

    private boolean buildHintedNLJPlans(PlanNode leftPlan, PlanNode rightPlan, ILogicalExpression nestedLoopJoinExpr, IndexedNLJoinExpressionAnnotation hintNLJoin, boolean outerJoin, List<Integer> newJoinConditions) throws AlgebricksException {
        int commutativeNljPlan;
        int nljPlan = commutativeNljPlan = PlanNode.NO_PLAN;
        nljPlan = this.buildNLJoinPlan(leftPlan, rightPlan, nestedLoopJoinExpr, hintNLJoin, outerJoin);
        if (!this.joinEnum.forceJoinOrderMode || this.level <= this.joinEnum.cboFullEnumLevel) {
            commutativeNljPlan = this.buildNLJoinPlan(rightPlan, leftPlan, nestedLoopJoinExpr, hintNLJoin, outerJoin);
        }
        return this.handleHints(nljPlan, commutativeNljPlan, (IExpressionAnnotation)hintNLJoin, newJoinConditions);
    }

    private boolean handleHints(int plan, int commutativePlan, IExpressionAnnotation hint, List<Integer> newJoinConditions) {
        if (plan != PlanNode.NO_PLAN || commutativePlan != PlanNode.NO_PLAN) {
            this.joinEnum.joinHints.put(hint, null);
            return true;
        }
        if (!this.joinEnum.joinHints.containsKey(hint) || this.joinEnum.joinHints.get(hint) != null) {
            this.inapplicableHintWarning(hint, newJoinConditions);
            return false;
        }
        return true;
    }

    private void buildAllNonHintedPlans(PlanNode leftPlan, PlanNode rightPlan, ILogicalExpression hashJoinExpr, ILogicalExpression nestedLoopJoinExpr, boolean outerJoin) throws AlgebricksException {
        this.buildHashJoinPlan(leftPlan, rightPlan, hashJoinExpr, null, outerJoin);
        if (!this.joinEnum.forceJoinOrderMode || this.level <= this.joinEnum.cboFullEnumLevel) {
            this.buildHashJoinPlan(rightPlan, leftPlan, hashJoinExpr, null, outerJoin);
        }
        this.buildBroadcastHashJoinPlan(leftPlan, rightPlan, hashJoinExpr, null, outerJoin);
        if (!this.joinEnum.forceJoinOrderMode || this.level <= this.joinEnum.cboFullEnumLevel) {
            this.buildBroadcastHashJoinPlan(rightPlan, leftPlan, hashJoinExpr, null, outerJoin);
        }
        this.buildNLJoinPlan(leftPlan, rightPlan, nestedLoopJoinExpr, null, outerJoin);
        if (!this.joinEnum.forceJoinOrderMode || this.level <= this.joinEnum.cboFullEnumLevel) {
            this.buildNLJoinPlan(rightPlan, leftPlan, nestedLoopJoinExpr, null, outerJoin);
        }
        this.buildCPJoinPlan(leftPlan, rightPlan, hashJoinExpr, nestedLoopJoinExpr, outerJoin);
        if (!this.joinEnum.forceJoinOrderMode || this.level <= this.joinEnum.cboFullEnumLevel) {
            this.buildCPJoinPlan(rightPlan, leftPlan, hashJoinExpr, nestedLoopJoinExpr, outerJoin);
        }
    }

    private void inapplicableHintWarning(IExpressionAnnotation hint, List<Integer> newJoinConditions) {
        String param1 = "";
        Object param2 = "";
        if (hint instanceof HashJoinExpressionAnnotation) {
            HashJoinExpressionAnnotation hintHashJoin = (HashJoinExpressionAnnotation)hint;
            boolean build = hintHashJoin.getBuildOrProbe() == HashJoinExpressionAnnotation.BuildOrProbe.BUILD;
            String buildOrProbeObject = hintHashJoin.getName();
            param1 = "hash join";
            param2 = (build ? "build " : "probe ") + "with " + buildOrProbeObject;
        } else if (hint instanceof BroadcastExpressionAnnotation) {
            BroadcastExpressionAnnotation hintBroadcastHashJoin = (BroadcastExpressionAnnotation)hint;
            String broadcastObject = hintBroadcastHashJoin.getName();
            param1 = "broadcast hash join";
            param2 = "broadcast " + broadcastObject == null ? "" : broadcastObject;
        } else if (hint instanceof IndexedNLJoinExpressionAnnotation) {
            param1 = "index nested loop join";
            param2 = "ignored";
        }
        if (!(this.joinEnum.joinHints.containsKey(hint) && this.joinEnum.joinHints.get(hint) == null || this.joinEnum.getJoinConditions().isEmpty() || newJoinConditions.isEmpty())) {
            this.joinEnum.joinHints.put(hint, Warning.of((SourceLocation)this.joinEnum.getJoinConditions().get((int)newJoinConditions.get((int)0).intValue()).joinCondition.getSourceLocation(), (IError)ErrorCode.INAPPLICABLE_HINT, (Serializable[])new Serializable[]{param1, param2}));
        }
    }

    private PlanNode findCheapestPlan() {
        List<PlanNode> allPlans = this.joinEnum.allPlans;
        ICost cheapestCost = this.joinEnum.getCostHandle().maxCost();
        PlanNode cheapestPlanNode = null;
        int numHintsUsedInCheapestPlan = 0;
        for (int planIndex : this.planIndexesArray) {
            PlanNode plan = allPlans.get(planIndex);
            if (plan.numHintsUsed > numHintsUsedInCheapestPlan) {
                cheapestPlanNode = plan;
                cheapestCost = plan.totalCost;
                numHintsUsedInCheapestPlan = plan.numHintsUsed;
                continue;
            }
            if (plan.numHintsUsed != numHintsUsedInCheapestPlan || !plan.totalCost.costLT(cheapestCost)) continue;
            cheapestPlanNode = plan;
            cheapestCost = plan.totalCost;
        }
        return cheapestPlanNode;
    }

    private void setCheapestPlan(PlanNode pn, boolean forceEnum) {
        PlanNode cheapestPlan = forceEnum ? this.findCheapestPlan() : pn;
        this.cheapestPlanCost = cheapestPlan.totalCost;
        this.cheapestPlanIndex = cheapestPlan.allPlansIndex;
    }

    public String toString() {
        int j;
        List<PlanNode> allPlans = this.joinEnum.getAllPlans();
        StringBuilder sb = new StringBuilder(128);
        if (this.IsBaseLevelJoinNode()) {
            sb.append("Printing Scan Node ");
        } else {
            sb.append("Printing Join Node ");
        }
        sb.append(this.jnArrayIndex).append('\n');
        sb.append("datasetNames (aliases) ");
        for (j = 0; j < this.datasetNames.size(); ++j) {
            sb.append(this.datasetNames.get(j)).append('(').append(this.aliases.get(j)).append(')').append(' ');
        }
        sb.append('\n');
        sb.append("datasetIndexes ");
        for (j = 0; j < this.datasetIndexes.size(); ++j) {
            sb.append(j).append(this.datasetIndexes.get(j)).append(' ');
        }
        sb.append('\n');
        sb.append("datasetBits ").append(this.datasetBits).append('\n');
        sb.append("jnIndex ").append(this.jnIndex).append('\n');
        sb.append("level ").append(this.level).append('\n');
        sb.append("highestDatasetId ").append(this.highestDatasetId).append('\n');
        if (this.IsBaseLevelJoinNode()) {
            sb.append("orig cardinality ").append(this.dumpDouble(this.origCardinality));
        }
        sb.append("cardinality ").append(this.dumpDouble(this.cardinality));
        sb.append("size ").append(this.dumpDouble(this.size));
        sb.append("outputSize(sizeVarsAfterScan) ").append(this.dumpDouble(this.sizeVarsAfterScan));
        if (this.planIndexesArray.size() == 0) {
            sb.append("No plans considered for this join node").append('\n');
        } else {
            for (j = 0; j < this.planIndexesArray.size(); ++j) {
                int k = this.planIndexesArray.get(j);
                PlanNode pn = allPlans.get(k);
                sb.append("\nPrinting Plan ").append(k).append('\n');
                sb.append("planIndexesArray [").append(j).append("] ").append(k).append('\n');
                if (this.IsBaseLevelJoinNode()) {
                    if (pn.IsScanNode()) {
                        if (pn.getScanOp() == PlanNode.ScanMethod.TABLE_SCAN) {
                            sb.append("DATA_SOURCE_SCAN").append('\n');
                        } else {
                            sb.append("INDEX_SCAN").append('\n');
                        }
                    }
                } else {
                    sb.append((String)pn.joinMethod().getFirst()).append('\n');
                    sb.append("Join expr ");
                    if (pn.joinExpr != null) {
                        sb.append(pn.joinExpr).append('\n');
                        sb.append("outer join " + pn.outerJoin).append('\n');
                    } else {
                        sb.append("null").append('\n');
                    }
                }
                sb.append("operator cost ").append(this.dumpCost(pn.getOpCost()));
                sb.append("total cost ").append(this.dumpCost(pn.getTotalCost()));
                sb.append("jnIndexes ").append(pn.jnIndexes[0]).append(" ").append(pn.jnIndexes[1]).append('\n');
                if (!this.IsHigherLevelJoinNode()) continue;
                PlanNode leftPlan = pn.getLeftPlanNode();
                PlanNode rightPlan = pn.getRightPlanNode();
                sb.append("planIndexes ").append(leftPlan.getIndex()).append(" ").append(rightPlan.getIndex()).append('\n');
                sb.append(this.dumpLeftRightPlanCosts(pn));
            }
            if (this.cheapestPlanIndex != PlanNode.NO_PLAN) {
                sb.append("\nCheapest plan for JoinNode ").append(this.jnArrayIndex).append(" is ").append(this.cheapestPlanIndex).append(", cost is ").append(this.dumpDouble(allPlans.get(this.cheapestPlanIndex).getTotalCost().computeTotalCost()));
            }
        }
        sb.append("-----------------------------------------------------------------").append('\n');
        return sb.toString();
    }

    protected String dumpCost(ICost cost) {
        StringBuilder sb = new StringBuilder(128);
        sb.append((double)Math.round(cost.computeTotalCost() * 100.0) / 100.0).append('\n');
        return sb.toString();
    }

    protected String dumpDouble(double val) {
        StringBuilder sb = new StringBuilder(128);
        sb.append((double)Math.round(val * 100.0) / 100.0).append('\n');
        return sb.toString();
    }

    protected String dumpDoubleNoNewline(double val) {
        StringBuilder sb = new StringBuilder(128);
        sb.append((double)Math.round(val * 100.0) / 100.0);
        return sb.toString();
    }

    protected String dumpLeftRightPlanCosts(PlanNode pn) {
        StringBuilder sb = new StringBuilder(128);
        PlanNode leftPlan = pn.getLeftPlanNode();
        PlanNode rightPlan = pn.getRightPlanNode();
        ICost leftPlanTotalCost = leftPlan.getTotalCost();
        ICost rightPlanTotalCost = rightPlan.getTotalCost();
        sb.append("  left plan cost ").append(this.dumpDoubleNoNewline(leftPlanTotalCost.computeTotalCost())).append(", right plan cost ").append(this.dumpDouble(rightPlanTotalCost.computeTotalCost()));
        return sb.toString();
    }

    protected void printCostOfAllPlans(StringBuilder sb) {
        List<PlanNode> allPlans = this.joinEnum.allPlans;
        ICost minCost = this.joinEnum.getCostHandle().maxCost();
        int lowestCostPlanIndex = 0;
        for (int planIndex : this.planIndexesArray) {
            ICost planCost = allPlans.get((int)planIndex).totalCost;
            sb.append("plan ").append(planIndex).append(" cost is ").append(this.dumpDouble(planCost.computeTotalCost()));
            if (!planCost.costLT(minCost)) continue;
            minCost = planCost;
            lowestCostPlanIndex = planIndex;
        }
        sb.append("Cheapest Plan is ").append(lowestCostPlanIndex).append(", Cost is ").append(this.dumpDouble(minCost.computeTotalCost()));
    }
}

